/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.action;

import groove.grammar.model.ResourceKind;
import groove.gui.Icons;
import groove.gui.Simulator;
import groove.gui.action.SimulatorAction;
import groove.io.store.EditType;
import java.io.IOException;
import java.util.Set;

public class EnableUniqueAction
extends SimulatorAction {
    public EnableUniqueAction(Simulator simulator, ResourceKind kind) {
        super(simulator, EditType.ENABLE, kind);
        this.putValue("Name", this.ACTION_NAME(kind));
        this.putValue("ShortDescription", this.HOVER_DESCRIPTION(kind));
        this.putValue("SmallIcon", Icons.ENABLE_UNIQUE_ICON);
    }

    @Override
    public void execute() {
        String name = this.getSimulatorModel().getSelected(this.getResourceKind());
        if (!this.getDisplay().saveEditor(name, true, false)) {
            return;
        }
        try {
            this.getSimulatorModel().doEnableUniquely(this.getResourceKind(), name);
        }
        catch (IOException exc) {
            this.showErrorDialog(exc, "Error during %s enabling", this.getResourceKind().getDescription());
        }
    }

    @Override
    public void refresh() {
        Set<String> selected = this.getSimulatorModel().getSelectSet(this.getResourceKind());
        if (selected.size() == 1) {
            Set<String> enabled = this.getSimulatorModel().getGrammar().getActiveNames(this.getResourceKind());
            this.setEnabled(this.getGrammarStore().isModifiable() && !selected.equals(enabled));
        } else {
            this.setEnabled(false);
        }
    }

    private final String ACTION_NAME(ResourceKind kind) {
        return "Enable This " + kind.getName() + " Only";
    }

    private final String HOVER_DESCRIPTION(ResourceKind kind) {
        return "Enable this " + kind.getDescription() + ", and disable all " + "other " + kind.getDescription() + "s";
    }
}

