/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.action;

import groove.grammar.model.ResourceModel;
import groove.graph.Graph;
import groove.graph.GraphRole;
import groove.gui.Icons;
import groove.gui.Options;
import groove.gui.Simulator;
import groove.gui.action.SimulatorAction;
import groove.gui.display.Display;
import groove.gui.display.DisplayKind;
import groove.gui.display.GraphEditorTab;
import groove.gui.display.GraphTab;
import groove.gui.display.ResourceDisplay;
import groove.gui.display.ResourceTab;
import groove.gui.jgraph.AspectJGraph;
import groove.gui.jgraph.JGraph;
import groove.io.external.Exporter;

public class ExportAction
extends SimulatorAction {
    private final JGraph<?> jGraph;
    private final Display display;
    private final DisplayKind displayKind;
    private boolean isGraph;

    public ExportAction(Simulator simulator, DisplayKind displayKind) {
        super(simulator, "Export ...", Icons.EXPORT_ICON);
        this.putValue("AcceleratorKey", Options.EXPORT_KEY);
        this.displayKind = displayKind;
        this.display = simulator.getDisplaysPanel().getDisplay(displayKind);
        this.jGraph = null;
        this.isGraph = this.displayKind.isGraphBased();
    }

    public ExportAction(JGraph<?> jGraph) {
        super(jGraph.getActions().getSimulator(), "Export ...", Icons.EXPORT_ICON);
        this.putValue("AcceleratorKey", Options.EXPORT_KEY);
        this.display = null;
        this.displayKind = null;
        this.jGraph = jGraph;
        this.isGraph = true;
    }

    @Override
    public void execute() {
        Exporter.Exportable exportable = this.isGraph ? (this.getResource() != null ? new Exporter.Exportable(this.getJGraph(), this.getResource()) : new Exporter.Exportable(this.getJGraph())) : new Exporter.Exportable(this.getResource());
        Exporter.instance().doExport(this.getSimulator(), exportable);
    }

    @Override
    public void refresh() {
        boolean setenabled;
        boolean bl = setenabled = this.getSimulatorModel().getGrammar() != null;
        if (this.isGraph && setenabled) {
            JGraph<?> jGraph = this.getJGraph();
            setenabled = jGraph != null && jGraph.isEnabled();
        } else if (setenabled) {
            setenabled = this.getResource() != null;
        }
        this.setEnabled(setenabled);
        if (setenabled) {
            this.putValue("Name", this.getActionName());
            this.putValue("ShortDescription", this.getActionName());
        } else {
            this.putValue("Name", "Export...");
            this.putValue("ShortDescription", "Export...");
        }
    }

    private String getActionName() {
        String type = null;
        if (this.isGraph) {
            JGraph<?> jGraph = this.getJGraph();
            Graph graph = jGraph.getModel().getGraph();
            GraphRole role = graph.getRole();
            boolean isState = jGraph instanceof AspectJGraph && ((AspectJGraph)jGraph).isForState();
            type = isState ? "State" : role.getDescription();
        } else {
            type = this.displayKind.getResource().getDescription();
        }
        return "Export " + type + " ...";
    }

    private final ResourceModel<?> getResource() {
        if (!(this.display instanceof ResourceDisplay)) {
            return null;
        }
        ResourceTab tab = ((ResourceDisplay)this.display).getSelectedTab();
        if (tab == null) {
            return null;
        }
        return this.getGrammarModel().getResource(this.displayKind.getResource(), tab.getName());
    }

    private final JGraph<?> getJGraph() {
        assert (this.isGraph);
        if (this.jGraph == null) {
            switch (this.displayKind) {
                case HOST: 
                case RULE: 
                case TYPE: {
                    ResourceTab selectedTab = ((ResourceDisplay)this.display).getSelectedTab();
                    return selectedTab == null ? null : (selectedTab instanceof GraphTab ? ((GraphTab)selectedTab).getJGraph() : ((GraphEditorTab)selectedTab).getJGraph());
                }
                case STATE: {
                    return this.getStateDisplay().getJGraph();
                }
                case LTS: {
                    return this.getLtsDisplay().getJGraph();
                }
            }
            assert (false);
            return null;
        }
        return this.jGraph;
    }
}

