/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.action;

import groove.gui.Options;
import groove.gui.Simulator;
import groove.gui.action.SimulatorAction;
import groove.lts.GTS;
import groove.lts.GraphState;
import java.util.Collection;
import java.util.Iterator;

public class GotoFinalStateAction
extends SimulatorAction {
    public GotoFinalStateAction(Simulator simulator, boolean animated) {
        super(simulator, "Go to Final State", null);
        this.putValue("AcceleratorKey", Options.GOTO_FINAL_STATE_KEY);
        this.getSimulator().addAccelerator(this);
    }

    @Override
    public void execute() {
        GraphState state;
        Iterator<GraphState> it;
        Collection<GraphState> finalStates = this.getFinalStates();
        if (finalStates.isEmpty()) {
            this.getActions().getExploreAction().execute();
            finalStates = this.getFinalStates();
        }
        if ((it = finalStates.iterator()).hasNext()) {
            GraphState current = this.getSimulatorModel().getState();
            state = null;
            while (state != current && it.hasNext()) {
                state = it.next();
            }
            state = it.hasNext() ? it.next() : finalStates.iterator().next();
        } else {
            state = this.getSimulatorModel().getExploration().getLastState();
            if (state == null) {
                state = this.getSimulatorModel().getGts().startState();
            }
        }
        this.getSimulatorModel().setState(state);
    }

    private Collection<GraphState> getFinalStates() {
        GTS gts = this.getSimulatorModel().getGts();
        Collection<GraphState> result = gts.getFinalStates();
        if (result.isEmpty()) {
            result = gts.getResultStates();
        }
        return result;
    }

    @Override
    public void refresh() {
        this.setEnabled(this.getSimulatorModel().getGts() != null);
    }
}

