/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.action;

import groove.gui.Simulator;
import groove.gui.action.SimulatorAction;
import groove.gui.display.LTSDisplay;
import groove.gui.jgraph.JCell;
import groove.gui.jgraph.JEdge;
import groove.gui.jgraph.JVertex;
import groove.gui.jgraph.LTSJModel;
import groove.gui.look.VisualKey;

public class ReloadLTSAction
extends SimulatorAction {
    protected ReloadLTSAction(Simulator simulator) {
        super(simulator, "Reload LTS", null);
    }

    @Override
    public void execute() {
        LTSDisplay display = this.getLtsDisplay();
        LTSJModel ltsJModel = display.getJModel();
        int newBound = display.getStateBound();
        int oldBound = ltsJModel.setStateBound(newBound);
        int lower = Math.min(oldBound, newBound);
        int upper = Math.max(oldBound, newBound);
        for (JCell jCell : ltsJModel.getRoots()) {
            JVertex jVertex;
            int nr;
            if (!(jCell instanceof JVertex) || lower > (nr = (jVertex = (JVertex)jCell).getNumber()) || nr > upper) continue;
            jVertex.setStale(VisualKey.VISIBLE);
            for (JEdge jEdge : jVertex.getContext()) {
                jEdge.setStale(VisualKey.VISIBLE);
            }
        }
        display.getJGraph().refreshAllCells();
        display.getGraphPanel().refreshBackground();
    }
}

