/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.action;

import groove.grammar.aspect.AspectGraph;
import groove.grammar.model.ResourceKind;
import groove.graph.GraphInfo;
import groove.gui.Icons;
import groove.gui.Simulator;
import groove.gui.action.SimulatorAction;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;

public class ShiftPriorityAction
extends SimulatorAction {
    private final boolean up;

    public ShiftPriorityAction(Simulator simulator, boolean up) {
        super(simulator, up ? "Raise Priority" : "Lower Priority", up ? Icons.ARROW_SIMPLE_UP_ICON : Icons.ARROW_SIMPLE_DOWN_ICON);
        this.up = up;
    }

    @Override
    public void refresh() {
        boolean ruleSelected = this.getSimulatorModel().isSelected(ResourceKind.RULE);
        this.setEnabled(ruleSelected && this.getGrammarStore().isModifiable());
    }

    @Override
    public void execute() {
        int i;
        NavigableMap<Integer, HashSet<String>> rulesMap = new TreeMap();
        for (AspectGraph ruleGraph : this.getGrammarStore().getGraphs(ResourceKind.RULE).values()) {
            int priority = GraphInfo.getPriority(ruleGraph);
            HashSet<String> cell = (HashSet<String>)rulesMap.get(priority);
            if (cell == null) {
                cell = new HashSet<String>();
                rulesMap.put(priority, cell);
            }
            cell.add(ruleGraph.getName());
        }
        if (!this.up) {
            rulesMap = rulesMap.descendingMap();
        }
        Set<String> selectedRules = this.getSimulatorModel().getSelectSet(ResourceKind.RULE);
        ArrayList<Integer> priorities = new ArrayList<Integer>();
        ArrayList remainingRules = new ArrayList();
        ArrayList<Set<Object>> shiftedRules = new ArrayList<Set<Object>>();
        Set oldShifted = Collections.emptySet();
        for (Map.Entry cell : rulesMap.entrySet()) {
            priorities.add((Integer)cell.getKey());
            HashSet remaining = new HashSet((Collection)cell.getValue());
            HashSet<String> shifted = new HashSet<String>(selectedRules);
            shifted.retainAll(remaining);
            remaining.removeAll(shifted);
            boolean allShifted = remaining.isEmpty();
            remaining.addAll(oldShifted);
            remainingRules.add(remaining);
            if (allShifted && priorities.size() < rulesMap.size()) {
                shiftedRules.add(Collections.emptySet());
                oldShifted = shifted;
                continue;
            }
            shiftedRules.add(shifted);
            oldShifted = Collections.emptySet();
        }
        ArrayList<Integer> newPriorities = new ArrayList<Integer>();
        ArrayList<Set> newCells = new ArrayList<Set>();
        int last = this.start();
        int i2 = 0;
        while (i2 < priorities.size()) {
            Set cell;
            int priority = (Integer)priorities.get(i2);
            if (!this.exceeds(priority, last)) {
                priority = this.inc(last);
            }
            if (!(cell = (Set)remainingRules.get(i2)).isEmpty()) {
                newPriorities.add(priority);
                newCells.add(cell);
                last = priority;
            }
            if (!(cell = (Set)shiftedRules.get(i2)).isEmpty()) {
                priority = this.inc(priority);
                newCells.add(cell);
                newPriorities.add(priority);
                last = priority;
            }
            ++i2;
        }
        if (!this.up && last < 0) {
            int corrected = 0;
            i = newPriorities.size() - 1;
            while (i >= 0) {
                int current = (Integer)newPriorities.get(i);
                if (current >= corrected) break;
                newPriorities.set(i, corrected);
                ++corrected;
                --i;
            }
        }
        HashMap<String, Integer> priorityMap = new HashMap<String, Integer>();
        i = 0;
        while (i < newPriorities.size()) {
            int priority = (Integer)newPriorities.get(i);
            for (String ruleName : (Set)newCells.get(i)) {
                AspectGraph ruleGraph = this.getGrammarStore().getGraphs(ResourceKind.RULE).get(ruleName);
                if (GraphInfo.getPriority(ruleGraph) == priority) continue;
                priorityMap.put(ruleName, priority);
            }
            ++i;
        }
        if (!priorityMap.isEmpty()) {
            try {
                this.getSimulatorModel().doSetPriority(priorityMap);
            }
            catch (IOException exc) {
                this.showErrorDialog(exc, "Error during rule priority change", new Object[0]);
            }
        }
    }

    private int start() {
        return this.up ? -1 : Integer.MAX_VALUE;
    }

    private int inc(int index) {
        return this.up ? index + 1 : index - 1;
    }

    private boolean exceeds(int ix, int last) {
        return this.up ? ix > last : ix < last;
    }
}

