/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.action;

import groove.gui.Icons;
import groove.gui.Simulator;
import groove.gui.action.SimulatorAction;
import groove.gui.display.GraphEditorTab;
import java.util.HashSet;
import java.util.Set;

public class SnapToGridAction
extends SimulatorAction {
    private final Set<GraphEditorTab> observers = new HashSet<GraphEditorTab>();
    private boolean snapToGrid;

    public SnapToGridAction(Simulator simulator) {
        super(simulator, "Snap to grid", Icons.GRID_ICON);
    }

    @Override
    public void execute() {
        this.snapToGrid = !this.snapToGrid;
        for (GraphEditorTab observer : this.observers) {
            observer.setSnapToGrid();
        }
    }

    public void addSnapListener(GraphEditorTab editorTab) {
        this.observers.add(editorTab);
    }

    public void removeSnapListener(GraphEditorTab editorTab) {
        this.observers.remove(editorTab);
    }

    public boolean getSnap() {
        return this.snapToGrid;
    }
}

