/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;

public class ErrorDialog
extends JDialog {
    protected final JButton detailsButton;
    protected final JButton cancelButton;
    protected final JPanel detailsPane;
    protected final JTextArea detailsArea;
    protected final JScrollPane detailsTextPane;
    protected final Throwable exc;
    protected int detailsLevel = 0;
    public static final String ERROR_MESSAGE_TEXT = "Error message";
    public static final String NO_DETAILS_BUTTON_TEXT = "Details >>";
    public static final String SOME_DETAILS_BUTTON_TEXT = "More >>";
    public static final String ALL_DETAILS_BUTTON_TEXT = "Details <<";
    public static final String CANCEL_BUTTON_TEXT = "OK";
    public static final int NO_DETAILS = 0;
    public static final int SOME_DETAILS = 1;
    public static final int FULL_DETAILS = 2;
    private static final String[] DETAILS_LEVEL_TEXT = new String[]{"Details >>", "More >>", "Details <<"};

    public ErrorDialog(Component component, String message, Throwable exc) {
        super(ErrorDialog.getParentFrame(component), ERROR_MESSAGE_TEXT, true);
        this.setLocationRelativeTo(component);
        this.exc = exc;
        Box cancelPane = Box.createHorizontalBox();
        this.cancelButton = new JButton(CANCEL_BUTTON_TEXT);
        cancelPane.add(Box.createHorizontalGlue());
        cancelPane.add(this.cancelButton);
        cancelPane.add(Box.createHorizontalGlue());
        this.cancelButton.setSelected(true);
        this.detailsButton = new JButton(NO_DETAILS_BUTTON_TEXT);
        this.detailsButton.setEnabled(exc != null);
        Box detailsButtonPane = Box.createHorizontalBox();
        detailsButtonPane.add(this.cancelButton);
        detailsButtonPane.add(Box.createHorizontalGlue());
        detailsButtonPane.add(this.detailsButton);
        this.detailsPane = new JPanel(new BorderLayout());
        this.detailsPane.add((Component)detailsButtonPane, "South");
        JPanel messagePane = new JPanel(new BorderLayout());
        messagePane.setPreferredSize(new Dimension(300, 100));
        messagePane.add((Component)this.detailsPane, "Center");
        JOptionPane optionPane = new JOptionPane(message, 0, -1, null, new Object[]{messagePane});
        optionPane.add((Component)messagePane, "South");
        Container contentPane = this.getContentPane();
        contentPane.add(optionPane);
        this.setPreferredSize();
        this.detailsArea = new JTextArea();
        this.detailsArea.setEditable(false);
        this.detailsTextPane = new JScrollPane(this.detailsArea);
        this.detailsTextPane.setPreferredSize(new Dimension(300, 100));
        this.detailsTextPane.setBorder(new EmptyBorder(5, 0, 5, 0));
        this.setDetailsLevel(0);
        ButtonListener buttonListener = new ButtonListener();
        this.cancelButton.addActionListener(buttonListener);
        this.detailsButton.addActionListener(buttonListener);
        this.pack();
    }

    public void setDetailsLevel(int detailsLevel) {
        switch (detailsLevel) {
            case 0: {
                this.detailsPane.remove(this.detailsTextPane);
                break;
            }
            case 1: {
                this.detailsArea.setText(String.valueOf(this.exc.getMessage()) + "\n");
                this.detailsPane.add((Component)this.detailsTextPane, "Center");
                this.detailsTextPane.scrollRectToVisible(new Rectangle(0, 0, 10, 10));
                break;
            }
            case 2: {
                StackTraceElement[] traceElems;
                this.detailsArea.setText("");
                this.detailsArea.append(String.valueOf(this.exc.toString()) + "\n");
                StackTraceElement[] stackTraceElementArray = traceElems = this.exc.getStackTrace();
                int n = traceElems.length;
                int n2 = 0;
                while (n2 < n) {
                    StackTraceElement element = stackTraceElementArray[n2];
                    this.detailsArea.append("    " + element.toString() + "\n");
                    ++n2;
                }
                this.detailsPane.add((Component)this.detailsTextPane, "Center");
                this.detailsArea.scrollRectToVisible(new Rectangle(0, 0, 10, 10));
            }
        }
        this.detailsButton.setText(DETAILS_LEVEL_TEXT[detailsLevel]);
        this.repaint();
    }

    protected static JFrame getParentFrame(Component component) {
        if (component == null || component instanceof JFrame) {
            return (JFrame)component;
        }
        return ErrorDialog.getParentFrame(component.getParent());
    }

    private void setPreferredSize() {
        Container contentPane = this.getContentPane();
        contentPane.setPreferredSize(null);
        Dimension size = contentPane.getPreferredSize();
        size.width = Math.min(size.width, 500);
        contentPane.setPreferredSize(size);
    }

    protected class ButtonListener
    implements ActionListener {
        protected ButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            Object source = evt.getSource();
            if (source.equals(ErrorDialog.this.detailsButton)) {
                ErrorDialog.this.detailsLevel = (ErrorDialog.this.detailsLevel + 1) % 3;
                if (ErrorDialog.this.detailsLevel == 1 && ErrorDialog.this.exc.getMessage() == null) {
                    ErrorDialog.this.detailsLevel = (ErrorDialog.this.detailsLevel + 1) % 3;
                }
                ErrorDialog.this.setDetailsLevel(ErrorDialog.this.detailsLevel);
            } else if (source.equals(ErrorDialog.this.cancelButton)) {
                ErrorDialog.this.setVisible(false);
            }
        }
    }
}

