/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.dialog;

import groove.gui.Simulator;
import groove.gui.layout.SpringUtilities;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SpringLayout;

public class ExplorationStatsDialog
extends JDialog
implements ActionListener {
    private static String CLOSE_COMMAND = "Close";
    private static String DIALOG_TITLE = "Exploration Statistics";
    private static String STATS_HEADER_TEXT = "Statistics of last state space exploration: ";
    private Simulator simulator;

    public ExplorationStatsDialog(Simulator simulator, JFrame parent) {
        super(parent, DIALOG_TITLE, true);
        this.setDefaultCloseOperation(0);
        this.setResizable(false);
        this.simulator = simulator;
        JPanel dialogContent = new JPanel(new SpringLayout());
        dialogContent.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                ExplorationStatsDialog.this.closeDialog();
            }
        });
        dialogContent.add(this.getInfoPane());
        dialogContent.add(this.getButtonPanel());
        SpringUtilities.makeCompactGrid(dialogContent, 2, 1, 0, 0, 0, 0);
        this.add(dialogContent);
        this.pack();
        this.setLocationRelativeTo(parent);
        this.setVisible(true);
    }

    private JScrollPane getInfoPane() {
        JTextArea infoPane = new JTextArea();
        infoPane.setEditable(false);
        infoPane.setBackground(Color.WHITE);
        Font font = new Font("Lucida Sans Typewriter", 0, 12);
        infoPane.setFont(font);
        infoPane.setTabSize(4);
        String info = this.simulator.getModel().getExplorationStats().getReport();
        infoPane.setText(info);
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setPreferredSize(new Dimension(700, 500));
        scrollPane.setBorder(BorderFactory.createTitledBorder(null, STATS_HEADER_TEXT, 0, 0));
        scrollPane.setViewportView(infoPane);
        return scrollPane;
    }

    private JPanel getButtonPanel() {
        JPanel buttonPanel = new JPanel();
        JButton closeButton = new JButton(CLOSE_COMMAND);
        closeButton.addActionListener(this);
        buttonPanel.add(closeButton);
        return buttonPanel;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getActionCommand().equals(CLOSE_COMMAND)) {
            this.closeDialog();
        }
    }

    private void closeDialog() {
        this.dispose();
    }
}

