/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.dialog;

import groove.grammar.QualName;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public abstract class FreshNameDialog<Name> {
    private JOptionPane optionPane;
    private JButton okButton;
    private JButton cancelButton;
    private JTextField nameField;
    private CloseListener nameFieldListener;
    private JLabel errorLabel;
    private final Set<Name> existingNames;
    private final Set<String> existingLowerCaseNames;
    private final Name suggestion;
    private Name name;
    private static String DEFAULT_TITLE = "Select rule name";

    public FreshNameDialog(Set<Name> existingNames, String suggestion, boolean mustBeFresh) {
        this.existingNames = new HashSet<Name>(existingNames);
        this.existingLowerCaseNames = new HashSet<String>();
        for (Name name : existingNames) {
            this.existingLowerCaseNames.add(name.toString().toLowerCase());
        }
        this.suggestion = mustBeFresh ? this.generateNewName(suggestion, existingNames) : this.createName(suggestion);
    }

    private Name generateNewName(String basis, Set<Name> existingNames) {
        Name result = this.createName(basis);
        int i = 1;
        while (existingNames.contains(result)) {
            result = this.createName(String.valueOf(basis) + i);
            ++i;
        }
        return result;
    }

    protected abstract Name createName(String var1);

    public boolean showDialog(JFrame frame, String title) {
        JTextField nameField = this.getNameField();
        nameField.setText(this.suggestion.toString());
        nameField.setSelectionStart(0);
        nameField.setSelectionEnd(nameField.getText().length());
        this.setOkEnabled();
        JDialog dialog = this.getOptionPane().createDialog(frame, title == null ? DEFAULT_TITLE : title);
        dialog.setVisible(true);
        Object response = this.getOptionPane().getValue();
        boolean result = response == this.getOkButton() || response == this.getNameField();
        this.setName(result ? (Name)this.getChosenName() : null);
        return result;
    }

    private void setOkEnabled() {
        boolean enabled = true;
        String errorText = " ";
        Name label = this.getChosenName();
        StringBuilder error = new StringBuilder();
        if (!QualName.isValid(label.toString(), null, error)) {
            errorText = error.toString();
            enabled = false;
        } else if (this.existingNames.contains(label)) {
            if (!this.suggestion.equals(label)) {
                errorText = "Name already exists";
                enabled = false;
            }
        } else if (this.existingLowerCaseNames.contains(label.toString().toLowerCase())) {
            errorText = "Name already exists (with different case)";
            enabled = false;
        }
        this.getErrorLabel().setText(errorText);
        this.getOkButton().setEnabled(enabled);
        this.getNameFieldListener().setEnabled(enabled);
    }

    private JOptionPane getOptionPane() {
        if (this.optionPane == null) {
            JTextField nameField = this.getNameField();
            this.optionPane = new JOptionPane(new Object[]{nameField, this.getErrorLabel()}, -1, 2, null, new Object[]{this.getOkButton(), this.getCancelButton()});
        }
        return this.optionPane;
    }

    private Name getChosenName() {
        return this.createName(this.getNameField().getText());
    }

    private JButton getOkButton() {
        if (this.okButton == null) {
            this.okButton = new JButton("OK");
            this.okButton.addActionListener(new CloseListener());
        }
        return this.okButton;
    }

    private JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton("Cancel");
            this.cancelButton.addActionListener(new CloseListener());
        }
        return this.cancelButton;
    }

    private JTextField getNameField() {
        if (this.nameField == null) {
            this.nameField = new JTextField(30);
            this.nameField.getDocument().addDocumentListener(new OverlapListener());
            this.nameField.addActionListener(this.getNameFieldListener());
        }
        return this.nameField;
    }

    private CloseListener getNameFieldListener() {
        if (this.nameFieldListener == null) {
            this.nameFieldListener = new CloseListener();
        }
        return this.nameFieldListener;
    }

    private JLabel getErrorLabel() {
        if (this.errorLabel == null) {
            JLabel result = this.errorLabel = new JLabel();
            result.setForeground(Color.RED);
            result.setMinimumSize(this.getOkButton().getPreferredSize());
        }
        return this.errorLabel;
    }

    public final Name getName() {
        return this.name;
    }

    private final void setName(Name name) {
        this.name = name;
    }

    private class CloseListener
    implements ActionListener {
        private boolean enabled = true;

        CloseListener() {
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.enabled) {
                FreshNameDialog.this.getOptionPane().setValue(e.getSource());
                FreshNameDialog.this.getOptionPane().setVisible(false);
            }
        }
    }

    private class OverlapListener
    implements DocumentListener {
        OverlapListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            FreshNameDialog.this.setOkEnabled();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            FreshNameDialog.this.setOkEnabled();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            FreshNameDialog.this.setOkEnabled();
        }
    }
}

