/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.dialog;

import groove.grammar.model.FormatException;
import groove.gui.Options;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ToolTipManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public abstract class StringDialog {
    private MyComboBox choiceBox;
    private JButton okButton;
    private JButton cancelButton;
    private JLabel errorLabel;
    private final Map<String, String> docMap;
    private final List<String> history;
    private final String title;
    private boolean parsed;
    private String result;
    private JDialog dialog;
    private final CloseListener closeListener = new CloseListener();
    private static final int MAX_PERSISTENT_SIZE = 10;
    private final ChangeListener changeListener = new ChangeListener();

    public StringDialog(String title, Map<String, String> docMap) {
        this.history = new ArrayList<String>();
        this.title = title;
        this.docMap = docMap;
        this.parsed = docMap != null;
    }

    public StringDialog(String title) {
        this(title, null);
    }

    public String showDialog(Component frame) {
        String[] storedValues;
        if (this.title != null) {
            storedValues = Options.getUserPrefs(this.title);
            this.history.clear();
            String[] stringArray = storedValues;
            int n = storedValues.length;
            int n2 = 0;
            while (n2 < n) {
                String value = stringArray[n2];
                String parsedValue = this.parseText(value);
                if (value != null && parsedValue != null) {
                    this.history.add(value);
                }
                ++n2;
            }
        }
        this.dialog = this.createDialog(frame);
        this.getChoiceBox().setSelectedItem("");
        this.getEditor().setText("");
        this.processTextChange();
        this.getChoiceBox().revalidate();
        this.getEditor().selectAll();
        this.dialog.pack();
        this.dialog.setResizable(true);
        this.dialog.setVisible(true);
        if (this.title != null) {
            storedValues = new String[Math.min(this.history.size(), 10)];
            int i = 0;
            while (i < storedValues.length) {
                storedValues[i] = this.history.get(i);
                ++i;
            }
            Options.storeUserPrefs(this.title, storedValues);
        }
        return this.getResult();
    }

    private JDialog createDialog(Component frame) {
        Object[] buttons = new Object[]{this.getOkButton(), this.getCancelButton()};
        JPanel input = new JPanel();
        input.setLayout(new BorderLayout());
        input.add((Component)this.getChoiceBox(), "North");
        if (this.parsed) {
            JPanel errorPanel = new JPanel(new BorderLayout());
            errorPanel.add(this.getErrorLabel());
            input.add((Component)errorPanel, "South");
        }
        JPanel main = new JPanel();
        main.setLayout(new BorderLayout());
        main.add((Component)input, "Center");
        if (this.parsed) {
            main.add((Component)this.createSyntaxPanel(), "East");
        }
        JOptionPane panel = new JOptionPane(main, -1, 2, null, buttons);
        JDialog result = panel.createDialog(frame, this.title);
        result.setDefaultCloseOperation(0);
        result.addWindowListener(this.closeListener);
        return result;
    }

    private JComponent createSyntaxPanel() {
        final JList<Object> list = new JList<Object>();
        DefaultListModel<String> model = new DefaultListModel<String>();
        for (Map.Entry<String, String> entry : this.docMap.entrySet()) {
            model.addElement(entry.getKey());
        }
        list.setModel(model);
        list.setCellRenderer(new MyCellRenderer(this.docMap));
        list.addMouseListener(new MouseAdapter(){
            private final ToolTipManager manager = ToolTipManager.sharedInstance();
            private final int standardDelay = this.manager.getDismissDelay();

            @Override
            public void mouseEntered(MouseEvent e) {
                if (e.getSource() == list) {
                    this.manager.setDismissDelay(Integer.MAX_VALUE);
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (e.getSource() == list) {
                    this.manager.setDismissDelay(this.standardDelay);
                }
            }
        });
        return new JScrollPane(list);
    }

    private MyComboBox getChoiceBox() {
        if (this.choiceBox == null) {
            this.choiceBox = new MyComboBox();
            this.choiceBox.setPrototypeDisplayValue("The longest value we want to display completely");
            this.choiceBox.setModel(this.createModel());
            this.choiceBox.setEditable(true);
            JTextField editor = (JTextField)this.choiceBox.getEditor().getEditorComponent();
            editor.addActionListener(this.closeListener);
            editor.getDocument().addDocumentListener(this.changeListener);
        }
        return this.choiceBox;
    }

    private MyComboBoxModel createModel() {
        MyComboBoxModel result = new MyComboBoxModel();
        result.setDirty("");
        return result;
    }

    private JTextField getEditor() {
        return (JTextField)this.getChoiceBox().getEditor().getEditorComponent();
    }

    private MyComboBoxModel getModel() {
        return (MyComboBoxModel)this.getChoiceBox().getModel();
    }

    private void processTextChange() {
        String currentText = this.getEditor().getText();
        String result = this.parseText(currentText);
        this.getOkButton().setEnabled(result != null && !currentText.isEmpty());
        this.getModel().setDirty(currentText);
    }

    private String parseText(String text) {
        String result;
        if (this.parsed) {
            try {
                result = this.parse(text);
                this.getErrorLabel().setText(null);
            }
            catch (FormatException e) {
                this.getErrorLabel().setText(e.getMessage());
                result = null;
            }
        } else {
            result = text;
        }
        return result;
    }

    protected abstract String parse(String var1) throws FormatException;

    private JButton getOkButton() {
        if (this.okButton == null) {
            this.okButton = new JButton("OK");
            this.okButton.addActionListener(this.closeListener);
            this.okButton.setEnabled(false);
        }
        return this.okButton;
    }

    private JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton("Cancel");
            this.cancelButton.addActionListener(this.closeListener);
        }
        return this.cancelButton;
    }

    private JLabel getErrorLabel() {
        if (this.errorLabel == null) {
            JLabel result = this.errorLabel = new JLabel();
            result.setForeground(Color.RED);
            result.setMinimumSize(this.getOkButton().getPreferredSize());
        }
        return this.errorLabel;
    }

    private boolean setResult(String resultObject) {
        boolean ok;
        if (resultObject == null) {
            this.result = null;
            ok = true;
        } else {
            this.result = this.parseText(resultObject);
            boolean bl = ok = this.result != null;
        }
        if (ok && resultObject != null) {
            this.history.remove(resultObject);
            this.history.add(0, resultObject);
        }
        return ok;
    }

    public String getResult() {
        return this.result;
    }

    public static void main(String[] args) {
        StringDialog dialog = StringDialog.createStringDialog("Input a string");
        boolean stop = false;
        do {
            dialog.showDialog(null);
            System.out.printf("Selected string: %s%n", dialog.getResult());
        } while (!(stop = "stop".equals(dialog.getResult())));
        System.exit(0);
    }

    public static final StringDialog createStringDialog(String title) {
        return new StringDialog(title, null){

            @Override
            protected String parse(String text) throws FormatException {
                return text;
            }
        };
    }

    private class ChangeListener
    implements DocumentListener {
        private ChangeListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            StringDialog.this.processTextChange();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            StringDialog.this.processTextChange();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            StringDialog.this.processTextChange();
        }
    }

    private class CloseListener
    extends WindowAdapter
    implements ActionListener {
        private CloseListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean ok = false;
            if (e.getSource() == StringDialog.this.getOkButton() || e.getSource() instanceof JTextField) {
                ok = StringDialog.this.setResult(StringDialog.this.getEditor().getText());
            } else if (e.getSource() == StringDialog.this.getCancelButton()) {
                ok = StringDialog.this.setResult(null);
            }
            if (ok) {
                StringDialog.this.dialog.setVisible(false);
            }
        }

        @Override
        public void windowClosing(WindowEvent e) {
            if (StringDialog.this.setResult(null)) {
                StringDialog.this.dialog.setVisible(false);
            }
        }
    }

    private static class MyCellRenderer
    extends DefaultListCellRenderer {
        private final Map<String, String> tipMap;

        MyCellRenderer(Map<String, String> tipMap) {
            this.tipMap = tipMap;
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component result = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (result == this) {
                this.setToolTipText(this.tipMap.get(value));
            }
            return result;
        }
    }

    private static class MyComboBox
    extends JComboBox {
        private boolean configure;

        private MyComboBox() {
        }

        @Override
        public void configureEditor(ComboBoxEditor anEditor, Object anItem) {
            if (anItem != null && this.configure) {
                super.configureEditor(anEditor, anItem);
            }
        }

        public void doConfigure(boolean configure) {
            this.configure = configure;
        }
    }

    private class MyComboBoxModel
    implements ComboBoxModel {
        private boolean ignoreChange = false;
        private boolean dirty = true;
        private String filterText;
        private final List<String> contents = new ArrayList<String>();
        private final List<ListDataListener> listeners = new ArrayList<ListDataListener>();
        private Object selectedItem;

        private MyComboBoxModel() {
        }

        @Override
        public Object getSelectedItem() {
            return this.selectedItem;
        }

        @Override
        public void setSelectedItem(Object anItem) {
            this.selectedItem = anItem;
            if (anItem != null) {
                this.ignoreChange = true;
                StringDialog.this.getEditor().setText(anItem.toString());
                StringDialog.this.getEditor().selectAll();
                this.ignoreChange = false;
            }
        }

        @Override
        public void addListDataListener(ListDataListener l) {
            this.listeners.add(l);
        }

        @Override
        public String getElementAt(int index) {
            this.synchroniseModel();
            return this.contents.get(index);
        }

        @Override
        public int getSize() {
            this.synchroniseModel();
            return this.contents.size();
        }

        @Override
        public void removeListDataListener(ListDataListener l) {
            this.listeners.remove(l);
        }

        public void setDirty(String filterText) {
            if (!this.ignoreChange) {
                StringDialog.this.getChoiceBox().doConfigure(false);
                this.dirty = true;
                this.filterText = filterText;
                this.selectedItem = null;
                for (ListDataListener l : this.listeners) {
                    l.contentsChanged(new ListDataEvent(this, 0, 0, this.getSize()));
                }
                StringDialog.this.getChoiceBox().hidePopup();
                if (this.getSize() > 0 && filterText.length() > 0) {
                    StringDialog.this.getChoiceBox().showPopup();
                }
                StringDialog.this.getChoiceBox().doConfigure(true);
            }
        }

        private void synchroniseModel() {
            if (this.dirty) {
                this.dirty = false;
                this.contents.clear();
                for (String entry : StringDialog.this.history) {
                    if (!entry.contains(this.filterText)) continue;
                    this.contents.add(entry);
                }
            }
        }
    }
}

