/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.display;

import groove.grammar.aspect.AspectGraph;
import groove.grammar.model.GrammarModel;
import groove.grammar.model.ResourceKind;
import groove.graph.GraphProperties;
import groove.gui.Icons;
import groove.gui.dialog.PropertiesTable;
import groove.gui.display.JGraphPanel;
import groove.gui.display.ResourceDisplay;
import groove.gui.display.ResourceTab;
import groove.gui.display.TitledPanel;
import groove.gui.jgraph.AspectJGraph;
import groove.gui.jgraph.AspectJModel;
import groove.gui.jgraph.JCell;
import groove.gui.tree.RuleLevelTree;
import groove.gui.tree.TypeTree;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import org.jgraph.graph.DefaultGraphModel;
import org.jgraph.graph.GraphModel;

public final class GraphTab
extends ResourceTab
implements UndoableEditListener {
    private JGraphPanel<AspectGraph> editArea;
    private JTabbedPane upperInfoPanel;
    private TitledPanel labelPanel;
    private PropertiesTable propertiesPanel;
    private JPanel lowerInfoPanel;
    private RuleLevelTree levelTree;
    private TypeTree labelTree;
    private AspectJGraph jGraph;
    private final Map<String, AspectJModel> jModelMap = new HashMap<String, AspectJModel>();
    private static final boolean DEBUG = false;

    public GraphTab(ResourceDisplay display) {
        super(display);
        this.setFocusable(false);
        this.setEnabled(false);
        this.start();
    }

    @Override
    protected void start() {
        super.start();
        this.getJGraph().setToolTipEnabled(true);
        this.getJGraph().addMouseListener(new ResourceTab.EditMouseListener(this));
    }

    @Override
    protected Observer createErrorListener() {
        return new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                JCell errorCell;
                if (arg != null && (errorCell = (JCell)GraphTab.this.getJModel().getErrorMap().get(arg)) != null) {
                    GraphTab.this.getJGraph().setSelectionCell(errorCell);
                }
            }
        };
    }

    @Override
    public JGraphPanel<AspectGraph> getEditArea() {
        JGraphPanel<AspectGraph> result = this.editArea;
        if (result == null) {
            this.editArea = result = new JGraphPanel<AspectGraph>(this.getJGraph());
            result.setFocusable(false);
            result.setEnabled(false);
            result.initialise();
        }
        return result;
    }

    @Override
    public boolean isDirty() {
        return false;
    }

    @Override
    public void setClean() {
    }

    @Override
    protected void saveResource() {
    }

    @Override
    public Icon getIcon() {
        return Icons.getMainTabIcon(this.getResourceKind());
    }

    @Override
    public final boolean isEditor() {
        return false;
    }

    @Override
    protected JComponent getUpperInfoPanel() {
        JTabbedPane result = this.upperInfoPanel;
        if (result == null) {
            this.upperInfoPanel = result = new JTabbedPane();
            result.add(this.getLabelPanel());
            if (this.getResourceKind().hasProperties()) {
                PropertiesTable propertiesPanel = this.getPropertiesPanel();
                JScrollPane scrollPanel = new JScrollPane(propertiesPanel);
                scrollPanel.setName(propertiesPanel.getName());
                scrollPanel.getViewport().setBackground(propertiesPanel.getBackground());
                result.add(scrollPanel);
                result.addChangeListener(this.createInfoListener(true));
            }
        }
        if (this.getResourceKind().hasProperties()) {
            result.setSelectedIndex(this.getDisplay().getInfoTabIndex(true));
        }
        return result;
    }

    private TitledPanel getLabelPanel() {
        TitledPanel result = this.labelPanel;
        if (result == null) {
            TypeTree labelTree = this.getLabelTree();
            this.labelPanel = result = new TitledPanel("Labels", labelTree, labelTree.createToolBar(), true);
            result.setTitled(false);
        }
        return result;
    }

    private PropertiesTable getPropertiesPanel() {
        PropertiesTable result = this.propertiesPanel;
        if (result == null) {
            this.propertiesPanel = result = new PropertiesTable(GraphProperties.getKeyMap(), false);
            result.setName("Properties");
            result.addMouseListener(new ResourceTab.EditMouseListener(this));
        }
        return result;
    }

    @Override
    protected JComponent getLowerInfoPanel() {
        JPanel result = this.lowerInfoPanel;
        RuleLevelTree levelTree = this.getLevelTree();
        if (result == null && levelTree != null) {
            this.lowerInfoPanel = result = new TitledPanel("Nesting levels", levelTree, null, true);
        }
        return levelTree != null && levelTree.isEnabled() ? result : null;
    }

    private RuleLevelTree getLevelTree() {
        RuleLevelTree result = this.levelTree;
        if (result == null && this.getResourceKind() == ResourceKind.RULE) {
            result = this.levelTree = new RuleLevelTree(this.getJGraph());
        }
        return result;
    }

    private TypeTree getLabelTree() {
        TypeTree result = this.labelTree;
        if (result == null) {
            result = this.labelTree = new TypeTree(this.getJGraph(), true);
        }
        return result;
    }

    @Override
    public boolean setResource(String name) {
        AspectJModel oldJModel;
        AspectGraph graph;
        AspectJModel jModel = this.jModelMap.get(name);
        if (jModel == null && name != null && (graph = this.getSimulatorModel().getStore().getGraphs(this.getResourceKind()).get(name)) != null) {
            jModel = this.getJGraph().newModel();
            this.jModelMap.put(name, jModel);
            this.loadGraphIntoJModel(jModel, graph);
        }
        if (jModel == null) {
            name = null;
        }
        if ((oldJModel = this.getJModel()) != null) {
            oldJModel.removeUndoableEditListener(this);
        }
        this.getJGraph().setModel((GraphModel)jModel);
        if (jModel != null) {
            jModel.addUndoableEditListener(this);
            this.getPropertiesPanel().setProperties(jModel.getProperties());
        }
        this.setName(name);
        this.getTabLabel().setTitle(name);
        this.updateErrors();
        return jModel != null;
    }

    private void loadGraphIntoJModel(AspectJModel jModel, AspectGraph graph) {
        AspectGraph graphClone = graph.clone();
        graphClone.setFixed();
        jModel.loadGraph(graphClone);
    }

    @Override
    public boolean removeResource(String name) {
        boolean result = name.equals(this.getName());
        this.jModelMap.remove(name);
        if (result) {
            this.setResource(null);
        }
        return result;
    }

    @Override
    public void updateGrammar(GrammarModel grammar) {
        this.jModelMap.clear();
        this.setResource(this.getName());
    }

    @Override
    public void undoableEditHappened(UndoableEditEvent e) {
        if (e.getEdit() instanceof DefaultGraphModel.GraphModelEdit) {
            try {
                this.getJModel().syncGraph();
                AspectGraph graph = this.getJModel().getGraph();
                AspectGraph graphClone = graph.clone();
                graphClone.setFixed();
                this.getSimulatorModel().doAddGraph(this.getResourceKind(), graphClone, true);
                this.getPropertiesPanel().setProperties(this.getJModel().getProperties());
            }
            catch (IOException iOException) {}
        }
    }

    public final AspectJGraph getJGraph() {
        AspectJGraph result = this.jGraph;
        if (result == null) {
            result = this.jGraph = new AspectJGraph(this.getSimulator(), this.getDisplay().getKind(), false);
            result.setLabelTree(this.getLabelTree());
            result.setLevelTree(this.getLevelTree());
        }
        return result;
    }

    public final AspectJModel getJModel() {
        return this.getJGraph().getModel();
    }
}

