/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.display;

import groove.grammar.groovy.GraphManager;
import groove.grammar.model.ResourceKind;
import groove.gui.Simulator;
import groove.gui.display.ResourceDisplay;
import groove.io.FileType;
import groovy.lang.Binding;
import groovy.lang.GroovyRuntimeException;
import groovy.lang.GroovyShell;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.codehaus.groovy.control.CompilationFailedException;

public final class GroovyDisplay
extends ResourceDisplay {
    private JEditorPane editorPane;

    public GroovyDisplay(Simulator simulator) {
        super(simulator, ResourceKind.GROOVY);
    }

    @Override
    protected void buildDisplay() {
        this.setLayout(new BorderLayout());
        this.setFocusable(false);
        JSplitPane splitPane = new JSplitPane(0, this.getTabPane(), new JScrollPane(this.getEditorPane()));
        this.getEditorPane().setEditable(false);
        splitPane.setOneTouchExpandable(true);
        splitPane.setDividerLocation(0.8);
        splitPane.setResizeWeight(0.8);
        this.add((Component)splitPane, "Center");
    }

    /*
     * Unable to fully structure code
     */
    public void executeGroovy(String name) {
        block13: {
            program = this.getSimulatorModel().getStore().getTexts(this.getResourceKind()).get(name);
            manager = new GraphManager(this.getSimulatorModel());
            binding = new Binding();
            output = new PipedOutputStream();
            newstream = new PrintStream(output);
            try {
                writer = new PaneWriter(this.getEditorPane(), output);
            }
            catch (IOException e) {
                e.printStackTrace(System.err);
                return;
            }
            this.getEditorPane().setText("");
            writer.start();
            binding.setVariable("simulator", (Object)this.getSimulator());
            binding.setVariable("simulatorModel", (Object)this.getSimulatorModel());
            binding.setVariable("manager", (Object)manager);
            binding.setVariable("out", (Object)newstream);
            shell = new GroovyShell(binding);
            try {
                shell.evaluate(program);
            }
            catch (CompilationFailedException e) {
                newstream.println("Failed to compile Groovy script");
                newstream.println(e.getMessage());
            }
            catch (GroovyRuntimeException e) {
                newstream.println("Error during execution of Groovy script");
                loc = "";
                var14_16 = e.getStackTrace();
                var13_17 = var14_16.length;
                var12_19 = 0;
                ** while (var12_19 < var13_17)
            }
lbl-1000:
            // 1 sources

            {
                elem = var14_16[var12_19];
                if (elem.getFileName().endsWith(FileType.GROOVY.getExtension())) {
                    loc = String.valueOf(elem.getFileName()) + ":" + elem.getLineNumber() + " : ";
                    break;
                }
                ++var12_19;
                continue;
            }
lbl40:
            // 2 sources

            newstream.println(String.valueOf(loc) + e.getMessage());
            break block13;
            catch (Exception e) {
                newstream.println(String.valueOf(e.getClass().getSimpleName()) + " during execution of Groovy script");
                newstream.println(e.getMessage());
                var13_18 = e.getStackTrace();
                var12_20 = var13_18.length;
                var11_22 = 0;
                ** while (var11_22 < var12_20)
            }
lbl-1000:
            // 1 sources

            {
                elem = var13_18[var11_22];
                newstream.println(elem.toString());
                ++var11_22;
                continue;
lbl53:
                // 1 sources

                break block13;
            }
            catch (Error e) {
                newstream.println("!" + e.getClass().getSimpleName() + " during execution of Groovy script!");
                newstream.println(e.getMessage());
                e.printStackTrace(newstream);
            }
        }
        try {
            newstream.close();
            output.close();
            writer.join();
        }
        catch (IOException v0) {
        }
        catch (InterruptedException v1) {}
    }

    private JEditorPane getEditorPane() {
        if (this.editorPane == null) {
            this.editorPane = new JEditorPane();
        }
        return this.editorPane;
    }

    private class PaneWriter
    extends Thread {
        private JEditorPane pane;
        private PipedInputStream stream;

        public PaneWriter(JEditorPane pane, PipedOutputStream stream) throws IOException {
            this.pane = pane;
            this.stream = new PipedInputStream(stream);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            byte[] buffer = new byte[1024];
            Document doc = this.pane.getDocument();
            int lenRead = 0;
            try {
                while (true) {
                    if ((lenRead = this.stream.read(buffer, 0, 1023)) <= 0) {
                        return;
                    }
                    buffer[lenRead] = 0;
                    try {
                        doc.insertString(doc.getLength(), new String(buffer, 0, lenRead), null);
                    }
                    catch (BadLocationException badLocationException) {}
                }
            }
            catch (IOException iOException) {}
        }
    }
}

