/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.display;

import groove.grammar.GrammarProperties;
import groove.grammar.model.GrammarModel;
import groove.gui.Options;
import groove.gui.Simulator;
import groove.gui.SimulatorListener;
import groove.gui.SimulatorModel;
import groove.gui.dialog.PropertiesTable;
import groove.gui.display.Display;
import groove.gui.display.DisplayKind;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JToolBar;

public class PropertiesDisplay
extends Display
implements SimulatorListener {
    public PropertiesDisplay(Simulator simulator) {
        super(simulator, DisplayKind.PROPERTIES);
    }

    @Override
    protected void buildDisplay() {
    }

    @Override
    protected void installListeners() {
        this.getSimulatorModel().addListener(this, SimulatorModel.Change.GRAMMAR);
    }

    @Override
    protected JToolBar createListToolBar() {
        JToolBar result = Options.createToolBar();
        result.add(this.getActions().getEditSystemPropertiesAction());
        return result;
    }

    @Override
    public PropertiesTable getList() {
        return (PropertiesTable)super.getList();
    }

    @Override
    protected PropertiesTable createList() {
        PropertiesTable result = new PropertiesTable(GrammarProperties.KEYS, false);
        result.addMouseListener(new EditMouseListener());
        return result;
    }

    @Override
    protected JComponent createInfoPanel() {
        return null;
    }

    @Override
    public void update(SimulatorModel source, SimulatorModel oldModel, Set<SimulatorModel.Change> changes) {
        boolean enabled;
        GrammarModel grammar = source.getGrammar();
        boolean bl = enabled = grammar != null;
        if (enabled) {
            this.getList().setProperties(grammar.getProperties());
        } else {
            this.getList().resetProperties();
        }
        this.getListPanel().setEnabled(enabled);
    }

    private final class EditMouseListener
    extends MouseAdapter {
        private EditMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                PropertiesDisplay.this.getActions().getEditSystemPropertiesAction().execute();
            }
        }
    }
}

