/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.display;

import groove.control.parse.CtrlTokenMaker;
import groove.grammar.model.FormatError;
import groove.grammar.model.GrammarModel;
import groove.grammar.model.TextBasedModel;
import groove.gui.Icons;
import groove.gui.Options;
import groove.gui.display.ResourceDisplay;
import groove.gui.display.ResourceTab;
import groove.prolog.util.PrologTokenMaker;
import java.awt.BorderLayout;
import java.util.Collection;
import java.util.Collections;
import java.util.Observable;
import java.util.Observer;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.BadLocationException;
import org.fife.ui.rsyntaxtextarea.RSyntaxDocument;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.TokenMaker;
import org.fife.ui.rsyntaxtextarea.TokenMakerFactory;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;

public final class TextTab
extends ResourceTab {
    private JButton undoButton;
    private ChangeListener dirtyListener;
    private final TextArea textArea = new TextArea();
    private final boolean editing;

    public TextTab(ResourceDisplay display) {
        this(display, null, null);
    }

    public TextTab(ResourceDisplay display, String name, String program) {
        super(display);
        this.editing = name != null;
        this.textArea.setEditable(this.editing);
        this.setName(name);
        this.setBorder(null);
        this.setLayout(new BorderLayout());
        this.textArea.setProgram(program);
        this.updateErrors();
        this.start();
    }

    @Override
    protected JComponent getEditArea() {
        return new RTextScrollPane((RTextArea)this.textArea, true);
    }

    @Override
    protected Observer createErrorListener() {
        return new Observer(){

            @Override
            public void update(Observable observable, Object arg) {
                FormatError error;
                if (arg != null && (error = (FormatError)arg).getNumbers().size() > 1) {
                    int line = error.getNumbers().get(0);
                    int column = error.getNumbers().get(1);
                    TextTab.this.select(line, column);
                }
            }
        };
    }

    @Override
    protected JToolBar createToolBar() {
        JToolBar result = super.createToolBar();
        result.addSeparator();
        result.add(this.getUndoButton());
        result.add(this.textArea.getRedoAction());
        result.addSeparator();
        result.add(this.textArea.getCopyAction());
        result.add(this.textArea.getPasteAction());
        result.add(this.textArea.getCutAction());
        result.add(this.textArea.getDeleteAction());
        return result;
    }

    @Override
    protected JComponent getUpperInfoPanel() {
        return null;
    }

    @Override
    protected JComponent getLowerInfoPanel() {
        return null;
    }

    @Override
    public Icon getIcon() {
        return this.isEditor() ? super.getIcon() : Icons.getMainTabIcon(this.getDisplay().getResourceKind());
    }

    @Override
    public boolean isEditor() {
        return this.editing;
    }

    @Override
    public boolean setResource(String name) {
        String program = null;
        if (name != null) {
            program = this.getSimulatorModel().getStore().getTexts(this.getResourceKind()).get(name);
        }
        if (program != null) {
            this.setName(name);
            this.textArea.setProgram(program);
            this.updateErrors();
        }
        return program != null;
    }

    @Override
    public boolean removeResource(String name) {
        boolean result = name.equals(this.getName());
        if (result) {
            this.setName(null);
            this.textArea.setProgram(null);
            this.updateErrors();
        }
        return result;
    }

    @Override
    public void updateGrammar(GrammarModel grammar) {
        TextBasedModel textModel;
        TextBasedModel textBasedModel = textModel = this.getName() == null ? null : (TextBasedModel)grammar.getResource(this.getResourceKind(), this.getName());
        if (textModel == null) {
            this.dispose();
        } else if (!this.isDirty()) {
            this.textArea.setProgram(textModel.getProgram());
        }
    }

    @Override
    public final boolean isDirty() {
        return this.textArea.canUndo();
    }

    @Override
    public void setClean() {
        this.textArea.discardAllEdits();
        this.updateDirty();
        this.updateErrors();
    }

    public final String getProgram() {
        return this.textArea.getText();
    }

    @Override
    protected Collection<FormatError> getErrors() {
        String name = this.getName();
        if (name == null) {
            return Collections.emptySet();
        }
        return this.getDisplay().getResource(name).getErrors();
    }

    public void select(int line, int column) {
        try {
            int pos = this.textArea.getLineStartOffset(line - 1);
            if (column > 0) {
                pos += column - 1;
            }
            this.textArea.select(pos, pos);
            this.textArea.requestFocusInWindow();
        }
        catch (BadLocationException badLocationException) {}
    }

    @Override
    protected void saveResource() {
        this.getSaveAction().doSaveText(this.getName(), this.getProgram());
    }

    protected TokenMaker createTokenMaker() {
        switch (this.getResourceKind()) {
            case PROLOG: {
                return new PrologTokenMaker();
            }
            case GROOVY: {
                return TokenMakerFactory.getDefaultInstance().getTokenMaker("text/groovy");
            }
            case CONTROL: {
                return new CtrlTokenMaker();
            }
        }
        return TokenMakerFactory.getDefaultInstance().getTokenMaker("text/plain");
    }

    @Override
    public void dispose() {
        this.getUndoButton().removeChangeListener(this.getDirtyListener());
        this.getUndoButton().setAction(null);
        super.dispose();
    }

    private JButton getUndoButton() {
        if (this.undoButton == null) {
            this.undoButton = this.createUndoButton();
        }
        return this.undoButton;
    }

    private JButton createUndoButton() {
        JButton result = Options.createButton(this.textArea.getUndoAction());
        result.addChangeListener(this.getDirtyListener());
        return result;
    }

    ChangeListener getDirtyListener() {
        if (this.dirtyListener == null) {
            this.dirtyListener = this.createDirtyListener();
        }
        return this.dirtyListener;
    }

    ChangeListener createDirtyListener() {
        return new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                TextTab.this.updateDirty();
            }
        };
    }

    private class TextArea
    extends RSyntaxTextArea {
        public TextArea() {
            super(30, 100);
            ((RSyntaxDocument)this.getDocument()).setSyntaxStyle(TextTab.this.createTokenMaker());
            this.setTabSize(4);
            this.discardAllEdits();
            this.getUndoAction().putValue("SmallIcon", Icons.UNDO_ICON);
            this.getRedoAction().putValue("SmallIcon", Icons.REDO_ICON);
            this.getCopyAction().putValue("SmallIcon", Icons.COPY_ICON);
            this.getPasteAction().putValue("SmallIcon", Icons.PASTE_ICON);
            this.getCutAction().putValue("SmallIcon", Icons.CUT_ICON);
            this.getDeleteAction().putValue("SmallIcon", Icons.DELETE_ICON);
            this.addMouseListener(new ResourceTab.EditMouseListener());
        }

        public void setProgram(String program) {
            this.setText(program == null ? "" : program);
            this.setEnabled(program != null);
            this.discardAllEdits();
        }

        public Action getUndoAction() {
            return TextArea.getAction((int)6);
        }

        public Action getRedoAction() {
            return TextArea.getAction((int)4);
        }

        public Action getCopyAction() {
            return TextArea.getAction((int)0);
        }

        public Action getPasteAction() {
            return TextArea.getAction((int)3);
        }

        public Action getCutAction() {
            return TextArea.getAction((int)1);
        }

        public Action getDeleteAction() {
            return TextArea.getAction((int)2);
        }

        protected JPopupMenu createPopupMenu() {
            JPopupMenu result;
            if (this.isEditable()) {
                result = super.createPopupMenu();
                int i = 0;
                result.insert(TextTab.this.getDisplay().getSaveAction(), i++);
                result.insert(TextTab.this.getDisplay().getCancelEditAction(), i++);
                result.insert(new JPopupMenu.Separator(), i++);
            } else {
                result = new JPopupMenu();
                result.add(TextTab.this.getDisplay().getEditAction());
            }
            return result;
        }
    }
}

