/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.jgraph;

import groove.graph.Edge;
import groove.gui.jgraph.AJEdge;
import groove.gui.jgraph.LTSJCell;
import groove.gui.jgraph.LTSJGraph;
import groove.gui.jgraph.LTSJModel;
import groove.gui.jgraph.LTSJVertex;
import groove.gui.look.Look;
import groove.gui.look.VisualKey;
import groove.io.HTMLConverter;
import groove.lts.GTS;
import groove.lts.GraphTransition;
import groove.lts.RuleTransition;
import groove.util.Groove;

public class LTSJEdge
extends AJEdge<GTS, LTSJGraph, LTSJModel, LTSJVertex>
implements LTSJCell {
    private boolean visibleFlag;

    private LTSJEdge() {
    }

    @Override
    protected void initialise() {
        super.initialise();
        this.visibleFlag = true;
    }

    @Override
    public boolean isCompatible(Edge edge) {
        return super.isCompatible(edge) && this.isPartial() == ((GraphTransition)edge).isPartial();
    }

    @Override
    public void addEdge(Edge edge) {
        super.addEdge(edge);
        this.setLook(Look.TRANSIENT, this.isPartial());
        this.setLook(Look.ABSENT, this.isAbsent());
    }

    @Override
    public GraphTransition getEdge() {
        return (GraphTransition)super.getEdge();
    }

    @Override
    StringBuilder getEdgeKindDescription() {
        return new StringBuilder("transition");
    }

    @Override
    String getLabelDescription() {
        StringBuffer result = new StringBuffer(", generated by ");
        String[] displayedLabels = new String[this.getEdges().size()];
        int labelIndex = 0;
        for (Edge part : this.getEdges()) {
            RuleTransition trans = (RuleTransition)part;
            String description = ((LTSJGraph)this.getJGraph()).isShowAnchors() ? trans.getEvent().toString() : trans.getEvent().getRule().getFullName();
            displayedLabels[labelIndex] = HTMLConverter.STRONG_TAG.on(description, true);
            ++labelIndex;
        }
        if (displayedLabels.length == 1) {
            result.append(displayedLabels[0]);
        } else {
            result.append(Groove.toString(displayedLabels, "<br>- ", "", "<br>- "));
        }
        return result.toString();
    }

    final boolean isActive() {
        return this.getLooks().contains((Object)Look.ACTIVE);
    }

    final boolean isAbsent() {
        return this.getEdge().source().isAbsent() || this.getEdge().target().isAbsent();
    }

    final boolean isPartial() {
        boolean result = true;
        for (Edge trans : this.getEdges()) {
            if (((GraphTransition)trans).isPartial()) continue;
            result = false;
            break;
        }
        return result;
    }

    @Override
    public void setVisibleFlag(boolean visible) {
        this.visibleFlag = visible;
        this.setStale(VisualKey.VISIBLE);
    }

    @Override
    public boolean hasVisibleFlag() {
        return this.visibleFlag;
    }

    @Override
    public final boolean setActive(boolean active) {
        return this.setLook(Look.ACTIVE, active);
    }

    @Override
    protected Look getStructuralLook() {
        return Look.TRANS;
    }

    public static LTSJEdge newInstance() {
        return new LTSJEdge();
    }
}

