/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.jgraph;

import groove.graph.Edge;
import groove.graph.Element;
import groove.graph.GraphRole;
import groove.graph.Node;
import groove.gui.Simulator;
import groove.gui.jgraph.JCell;
import groove.gui.jgraph.JGraph;
import groove.gui.jgraph.JGraphFactory;
import groove.gui.jgraph.JGraphMode;
import groove.gui.jgraph.LTSJCell;
import groove.gui.jgraph.LTSJEdge;
import groove.gui.jgraph.LTSJModel;
import groove.gui.jgraph.LTSJVertex;
import groove.gui.layout.ForestLayouter;
import groove.gui.layout.Layouter;
import groove.gui.layout.SpringLayouter;
import groove.gui.menu.ModelCheckingMenu;
import groove.gui.menu.MyJMenu;
import groove.gui.menu.SetLayoutMenu;
import groove.lts.GTS;
import groove.lts.GraphNextState;
import groove.lts.GraphState;
import groove.lts.GraphTransition;
import groove.lts.RecipeTransition;
import groove.lts.RuleTransition;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenu;
import org.jgraph.graph.GraphModel;

public class LTSJGraph
extends JGraph<GTS>
implements Serializable {
    private boolean filtering = false;
    private GraphState activeState;
    private GraphTransition activeTransition;
    private final Simulator simulator;
    private final ScrollToCurrentAction scrollToCurrentAction = new ScrollToCurrentAction();

    public LTSJGraph(Simulator simulator) {
        super(simulator);
        this.simulator = simulator;
        this.setDoubleBuffered(false);
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.addOptionListener("Show state identities");
        this.addOptionListener("Show partial transitions");
    }

    @Override
    protected JGraph.RefreshListener getRefreshListener(String option) {
        JGraph.RefreshListener result = null;
        if (!"Show node identities".equals(option)) {
            result = super.getRefreshListener(option);
        }
        return result;
    }

    @Override
    public GraphRole getGraphRole() {
        return GraphRole.LTS;
    }

    @Override
    public void setModel(GraphModel model) {
        this.activeState = null;
        this.activeTransition = null;
        super.setModel(model);
    }

    public LTSJModel getModel() {
        return (LTSJModel)this.graphModel;
    }

    public boolean isShowStateIdentities() {
        return this.getOptionValue("Show state identities");
    }

    public boolean isShowPartialTransitions() {
        return this.getOptionValue("Show partial transitions");
    }

    public void scrollTo(Element nodeOrEdge) {
        JCell cell = this.getModel().getJCell(nodeOrEdge);
        if (cell != null) {
            this.scrollCellToVisible(cell);
        }
    }

    @Override
    public JMenu createPopupMenu(Point atPoint) {
        MyJMenu result = new MyJMenu("Popup");
        if (this.getMode() == JGraphMode.SELECT_MODE) {
            result.addSubmenu(this.createExploreMenu());
            result.addSubmenu(this.createGotoMenu());
            result.addSubmenu(super.createPopupMenu(atPoint));
        } else {
            result.addSubmenu(this.createGotoMenu());
            result.addSubmenu(this.createShowHideMenu());
            result.addSubmenu(this.createZoomMenu());
        }
        return result;
    }

    @Override
    public JMenu createExportMenu() {
        MyJMenu result = new MyJMenu();
        result.add(this.getActions().getSaveLTSAsAction());
        result.add(this.getActions().getSaveStateAction());
        result.addMenuItems(super.createExportMenu());
        return result;
    }

    public JMenu createExploreMenu() {
        JMenu result = new JMenu("Explore");
        result.add(this.getActions().getExplorationDialogAction());
        result.add(this.getActions().getApplyMatchAction());
        result.add(this.getActions().getExploreAction());
        result.addSeparator();
        result.add(this.createCheckerMenu());
        return result;
    }

    public JMenu createGotoMenu() {
        JMenu result = new JMenu("Go To");
        result.add(this.getActions().getGotoStartStateAction());
        result.add(this.getActions().getGotoFinalStateAction());
        result.add(this.getScrollToCurrentAction());
        return result;
    }

    @Override
    public SetLayoutMenu createSetLayoutMenu() {
        SetLayoutMenu result = new SetLayoutMenu(this, new MyForestLayouter());
        result.addLayoutItem(new SpringLayouter());
        return result;
    }

    protected final JMenu createCheckerMenu() {
        return new ModelCheckingMenu(this.simulator);
    }

    public GraphTransition getActiveTransition() {
        return this.activeTransition;
    }

    public GraphState getActiveState() {
        return this.activeState;
    }

    public void setActive(GraphState state, GraphTransition trans) {
        Element elem;
        LTSJVertex jCell;
        ArrayList<LTSJCell> activeCells = new ArrayList<LTSJCell>();
        ArrayList<LTSJCell> changedCells = new ArrayList<LTSJCell>();
        GraphTransition previousTrans = this.getActiveTransition();
        this.activeTransition = trans;
        if (previousTrans != null) {
            for (LTSJCell jCell2 : this.getTransitionCells(previousTrans)) {
                if (!jCell2.setActive(false)) continue;
                changedCells.add(jCell2);
            }
        }
        if (trans != null) {
            for (LTSJCell jCell2 : this.getTransitionCells(trans)) {
                activeCells.add(jCell2);
                if (!jCell2.setActive(true)) continue;
                changedCells.add(jCell2);
            }
        }
        GraphState previousState = this.activeState;
        this.activeState = state;
        if (previousState != null && (jCell = (LTSJVertex)this.getModel().getJCellForNode(previousState)) != null && jCell.setActive(false)) {
            changedCells.add(jCell);
        }
        if (state != null && this.getModel() != null && (jCell = (LTSJVertex)this.getModel().getJCellForNode(state)) != null) {
            if (jCell.setActive(true)) {
                changedCells.add(jCell);
            }
            activeCells.add(jCell);
        }
        if (!changedCells.isEmpty()) {
            this.setSelectionCells(activeCells.toArray());
            this.refreshCells(changedCells);
        }
        Element element = elem = state == null ? trans : state;
        if (elem != null) {
            this.scrollTo(elem);
        }
    }

    void reactivate() {
        LTSJCell activeCell;
        GraphTransition activeTrans;
        LTSJCell activeCell2;
        ArrayList<LTSJCell> activeCells = new ArrayList<LTSJCell>();
        GraphState activeState = this.getActiveState();
        if (activeState != null && (activeCell2 = (LTSJCell)((Object)this.getModel().getJCellForNode(activeState))) != null) {
            activeCell2.setActive(true);
            activeCells.add(activeCell2);
        }
        if ((activeTrans = this.getActiveTransition()) != null && (activeCell = (LTSJCell)this.getModel().getJCellForEdge(activeTrans)) != null) {
            activeCell.setActive(true);
            activeCells.add(activeCell);
        }
        if (!activeCells.isEmpty()) {
            this.setSelectionCells(activeCells.toArray());
            this.refreshCells(activeCells);
        }
    }

    private Collection<LTSJCell> getTransitionCells(GraphTransition trans) {
        ArrayList<LTSJCell> result = new ArrayList<LTSJCell>();
        LTSJCell jCell = (LTSJCell)this.getModel().getJCellForEdge(trans);
        if (jCell != null) {
            result.add(jCell);
        }
        if (trans instanceof RecipeTransition) {
            for (RuleTransition subTrans : ((RecipeTransition)trans).getSteps()) {
                jCell = (LTSJCell)this.getModel().getJCellForEdge(subTrans);
                if (jCell != null) {
                    result.add(jCell);
                }
                if ((jCell = (LTSJCell)((Object)this.getModel().getJCellForNode(subTrans.source()))) == null) continue;
                result.add(jCell);
            }
        }
        return result;
    }

    public Set<JCell<GTS>> findTraces(Collection<GraphState> states) {
        Set<RuleTransition> simulatorTrace = this.getSimulatorModel().getTrace();
        simulatorTrace.clear();
        HashSet<JCell<GTS>> result = new HashSet<JCell<GTS>>();
        LTSJModel model = this.getModel();
        Iterator<GraphState> iterator = states.iterator();
        while (iterator.hasNext()) {
            GraphState finalState;
            GraphState state = finalState = iterator.next();
            while (state instanceof GraphNextState) {
                result.add(model.getJCellForNode(state));
                result.add(model.getJCellForEdge((RuleTransition)((Object)state)));
                simulatorTrace.add((RuleTransition)((Object)state));
                state = ((GraphNextState)state).source();
            }
            result.add(model.getJCellForNode(state));
        }
        return result;
    }

    public void refreshFiltering() {
        if (this.isFiltering()) {
            Set<JCell<GTS>> trace = this.findTraces(this.getModel().getGraph().getResultStates());
            Object[] objectArray = this.getRoots();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                LTSJCell jCell = (LTSJCell)element;
                jCell.setVisibleFlag(trace.isEmpty() || trace.contains(jCell));
                ++n2;
            }
        } else {
            Object[] objectArray = this.getRoots();
            int n = objectArray.length;
            int n3 = 0;
            while (n3 < n) {
                Object element = objectArray[n3];
                LTSJCell jCell = (LTSJCell)element;
                jCell.setVisibleFlag(true);
                ++n3;
            }
        }
        this.refreshAllCells();
    }

    public void setFiltering(boolean filtering) {
        this.filtering = filtering;
    }

    private boolean isFiltering() {
        return this.filtering;
    }

    private Action getScrollToCurrentAction() {
        if (this.getActiveTransition() == null) {
            this.scrollToCurrentAction.setState(this.getSimulatorModel().getState());
        } else {
            this.scrollToCurrentAction.setTransition(this.getSimulatorModel().getTransition());
        }
        return this.scrollToCurrentAction;
    }

    @Override
    protected JGraphFactory<GTS> createFactory() {
        return new MyFactory();
    }

    private class MyFactory
    extends JGraphFactory<GTS> {
        public MyFactory() {
            super(LTSJGraph.this);
        }

        public LTSJVertex newJVertex(Node node) {
            assert (node instanceof GraphState);
            return LTSJVertex.newInstance();
        }

        public LTSJEdge newJEdge(Edge edge) {
            assert (edge instanceof GraphTransition);
            return LTSJEdge.newInstance();
        }

        public LTSJModel newModel() {
            return new LTSJModel((LTSJGraph)this.getJGraph());
        }
    }

    private class MyForestLayouter
    extends ForestLayouter {
        public MyForestLayouter() {
        }

        public MyForestLayouter(String name, JGraph<?> jgraph) {
            super(name, jgraph);
        }

        @Override
        protected Collection<?> getSuggestedRoots() {
            LTSJModel jModel = LTSJGraph.this.getModel();
            return Collections.singleton(jModel.getJCellForNode(jModel.getGraph().startState()));
        }

        @Override
        public Layouter newInstance(JGraph<?> jGraph) {
            return new MyForestLayouter(this.getName(), jGraph);
        }
    }

    public class ScrollToCurrentAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent evt) {
            if (LTSJGraph.this.getSimulatorModel().getState() == null) {
                LTSJGraph.this.scrollTo(LTSJGraph.this.getSimulatorModel().getTransition());
            } else {
                LTSJGraph.this.scrollTo(LTSJGraph.this.getSimulatorModel().getState());
            }
        }

        public void setTransition(GraphTransition edge) {
            this.putValue("Name", "Scroll to current transition");
        }

        public void setState(GraphState node) {
            this.putValue("Name", "Scroll to current state");
        }
    }
}

