/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.look;

import groove.gui.Options;
import groove.gui.look.Line;
import groove.gui.look.LineFormat;
import groove.io.HTMLConverter;
import java.awt.Color;
import java.awt.Font;

public class HTMLLineFormat
extends LineFormat<HTMLBuilder> {
    public static final HTMLConverter.HTMLTag fontTag;
    private static final HTMLLineFormat instance;

    static {
        Font font = Options.LABEL_FONT;
        String face = font.getFamily();
        int size = font.getSize() - 2;
        String argument = String.format("font-family:%s; font-size:%dpx", face, size);
        fontTag = HTMLConverter.createSpanTag(argument);
        instance = new HTMLLineFormat();
    }

    private HTMLLineFormat() {
    }

    @Override
    public HTMLBuilder applyColored(Line.ColorType type, Color color, HTMLBuilder subline) {
        HTMLConverter.HTMLTag colorTag = HTMLConverter.createColorTag(color);
        colorTag.on(subline.getResult());
        return subline;
    }

    @Override
    public HTMLBuilder applyStyled(Line.Style style, HTMLBuilder subline) {
        HTMLConverter.HTMLTag tag;
        switch (style) {
            case BOLD: {
                tag = HTMLConverter.STRONG_TAG;
                break;
            }
            case ITALIC: {
                tag = HTMLConverter.ITALIC_TAG;
                break;
            }
            case STRIKE: {
                tag = HTMLConverter.STRIKETHROUGH_TAG;
                break;
            }
            case SUPER: {
                tag = HTMLConverter.SUPER_TAG;
                break;
            }
            default: {
                assert (false);
                tag = null;
            }
        }
        tag.on(subline.getResult());
        return subline;
    }

    @Override
    public HTMLBuilder applyAtomic(String text) {
        HTMLBuilder result = this.createResult();
        StringBuilder content = result.getResult();
        content.append(text);
        HTMLConverter.toHtml(content);
        return result;
    }

    @Override
    protected HTMLBuilder createResult() {
        return new HTMLBuilder();
    }

    public static HTMLLineFormat instance() {
        return instance;
    }

    public static String toHtml(StringBuilder text, Color color) {
        if (text.length() > 0) {
            if (color != null && !color.equals(Color.BLACK)) {
                HTMLConverter.createColorTag(color).on(text);
            }
            return HTMLConverter.HTML_TAG.on(HTMLConverter.CENTER_TAG.on(fontTag.on(text))).toString();
        }
        return "";
    }

    static class HTMLBuilder
    implements LineFormat.Builder<HTMLBuilder> {
        private final StringBuilder content = new StringBuilder();

        HTMLBuilder() {
        }

        @Override
        public StringBuilder getResult() {
            return this.content;
        }

        @Override
        public boolean isEmpty() {
            return this.content.length() == 0;
        }

        @Override
        public void append(HTMLBuilder other) {
            this.content.append((CharSequence)other.content);
        }

        @Override
        public void appendLineBreak() {
            this.content.append(HTMLConverter.HTML_LINEBREAK);
        }

        public String toString() {
            return this.content.toString();
        }
    }
}

