/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.look;

import groove.gui.Options;
import java.util.HashMap;
import java.util.Map;
import javax.swing.KeyStroke;

public enum LineStyle {
    ORTHOGONAL(11, "Orthogonal", Options.ORTHOGONAL_LINE_STYLE_KEY),
    SPLINE(13, "Spline", Options.SPLINE_LINE_STYLE_KEY),
    BEZIER(12, "Bezier", Options.BEZIER_LINE_STYLE_KEY),
    MANHATTAN(14, "Manhattan", Options.MANHATTAN_LINE_STYLE_KEY);

    private final int code;
    private final String name;
    private final KeyStroke stroke;
    public static final LineStyle DEFAULT_VALUE;
    private static final Map<Integer, LineStyle> codeMap;

    static {
        DEFAULT_VALUE = ORTHOGONAL;
        codeMap = new HashMap<Integer, LineStyle>();
        LineStyle[] lineStyleArray = LineStyle.values();
        int n = lineStyleArray.length;
        int n2 = 0;
        while (n2 < n) {
            LineStyle style = lineStyleArray[n2];
            codeMap.put(style.getCode(), style);
            ++n2;
        }
    }

    private LineStyle(int code, String name, KeyStroke stroke) {
        this.code = code;
        this.name = name;
        this.stroke = stroke;
    }

    public int getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public KeyStroke getKey() {
        return this.stroke;
    }

    public boolean isDefault() {
        return this == DEFAULT_VALUE;
    }

    public static boolean isStyle(int code) {
        return codeMap.containsKey(code);
    }

    public static LineStyle getStyle(int code) {
        LineStyle result = codeMap.get(code);
        if (result == null) {
            throw new IllegalArgumentException(String.format("Unknown line style code %s", code));
        }
        return result;
    }
}

