/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.look;

import groove.gui.Options;
import groove.gui.look.EdgeEnd;
import groove.gui.look.LineStyle;
import groove.gui.look.VisualKey;
import groove.gui.look.VisualMap;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.Edge;
import org.jgraph.graph.EdgeView;
import org.jgraph.graph.GraphLayoutCache;

public class VisualAttributeMap
extends AttributeMap {
    private final VisualMap visuals;
    private final Set<VisualKey> changedKeys;
    private static final double IN_MULT_DIST = 900.0;
    private static final double OUT_MULT_DIST = 100.0;
    private static final double MULT_X = -11.0;
    private static final Point2D[] EXTRA_LABEL_POSITIONS = new Point2D[]{new Point2D.Double(900.0, -11.0), new Point2D.Double(100.0, -11.0)};
    private static final Map<Object, VisualKey> attrToVisualKeyMap;
    private static final Map<VisualKey, String> visualToAttrKeyMap;
    private static final Edge.Routing edgeRouting;

    static {
        HashMap<Object, VisualKey> a2v = new HashMap<Object, VisualKey>();
        EnumMap<VisualKey, String> v2a = new EnumMap<VisualKey, String>(VisualKey.class);
        VisualKey[] visualKeyArray = VisualKey.values();
        int n = visualKeyArray.length;
        int n2 = 0;
        while (n2 < n) {
            String aKey;
            VisualKey vKey = visualKeyArray[n2];
            switch (vKey) {
                case BACKGROUND: {
                    aKey = "backgroundColor";
                    break;
                }
                case COLOR: {
                    aKey = "foregroundColor";
                    break;
                }
                case DASH: {
                    aKey = "dashPattern";
                    break;
                }
                case EDGE_SOURCE_LABEL: {
                    aKey = "extraLabels";
                    break;
                }
                case EDGE_SOURCE_POS: {
                    aKey = "extraLabelPositions";
                    break;
                }
                case EDGE_SOURCE_SHAPE: {
                    aKey = "lineBegin";
                    break;
                }
                case EDGE_TARGET_LABEL: {
                    aKey = "extraLabels";
                    break;
                }
                case EDGE_TARGET_POS: {
                    aKey = "extraLabelPositions";
                    break;
                }
                case EDGE_TARGET_SHAPE: {
                    aKey = "lineEnd";
                    break;
                }
                case FONT: {
                    aKey = "font";
                    break;
                }
                case FOREGROUND: {
                    aKey = "foregroundColor";
                    break;
                }
                case INSET: {
                    aKey = "inset";
                    break;
                }
                case LABEL_POS: {
                    aKey = "labelposition";
                    break;
                }
                case LINE_STYLE: {
                    aKey = "lineStyle";
                    break;
                }
                case LINE_WIDTH: {
                    aKey = "linewidth";
                    break;
                }
                case OPAQUE: {
                    aKey = "opaque";
                    break;
                }
                case POINTS: {
                    aKey = "points";
                    break;
                }
                case NODE_POS: {
                    aKey = "bounds";
                    break;
                }
                case EMPHASIS: 
                case INNER_LINE: 
                case NODE_SHAPE: {
                    aKey = null;
                    break;
                }
                default: {
                    assert (vKey.getNature() == VisualKey.Nature.REFRESHABLE);
                    aKey = null;
                }
            }
            if (aKey != null) {
                a2v.put(aKey, vKey);
                v2a.put(vKey, aKey);
            }
            ++n2;
        }
        attrToVisualKeyMap = a2v;
        visualToAttrKeyMap = v2a;
        edgeRouting = new Edge.Routing(){

            public int getPreferredLineStyle(EdgeView edge) {
                return -1;
            }

            public List<?> route(GraphLayoutCache cache, EdgeView edge) {
                return null;
            }
        };
    }

    VisualAttributeMap(VisualMap visuals) {
        super.put((Object)"groupOpaque", (Object)true);
        super.put((Object)"autosize", (Object)true);
        super.put((Object)"editable", (Object)true);
        super.put((Object)"selectable", (Object)true);
        super.put((Object)"routing", (Object)edgeRouting);
        this.visuals = visuals;
        this.changedKeys = EnumSet.noneOf(VisualKey.class);
        this.setStale(visuals.getMap().keySet());
    }

    void setStale(VisualKey key) {
        if (VisualAttributeMap.getAttrKey(key) != null) {
            this.changedKeys.add(key);
        }
    }

    void setStale(Set<VisualKey> keys) {
        if (!keys.isEmpty()) {
            for (VisualKey key : keys) {
                this.setStale(key);
            }
        }
    }

    public synchronized Enumeration elements() {
        this.refreshIfRequired();
        return super.elements();
    }

    public synchronized Object get(Object key) {
        this.refreshIfRequired();
        return super.get(key);
    }

    public Set<Map.Entry<?, ?>> entrySet() {
        this.refreshIfRequired();
        return super.entrySet();
    }

    public Collection<?> values() {
        this.refreshIfRequired();
        return super.values();
    }

    public Object clone() {
        AttributeMap result = new AttributeMap();
        for (Map.Entry<?, ?> entry : this.entrySet()) {
            result.applyValue(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public synchronized int size() {
        this.refreshIfRequired();
        return super.size();
    }

    public synchronized boolean isEmpty() {
        this.refreshIfRequired();
        return super.isEmpty();
    }

    public synchronized Enumeration<?> keys() {
        this.refreshIfRequired();
        return super.keys();
    }

    public synchronized boolean contains(Object value) {
        this.refreshIfRequired();
        return super.contains(value);
    }

    public synchronized boolean containsKey(Object key) {
        this.refreshIfRequired();
        return super.containsKey(key);
    }

    public synchronized int hashCode() {
        this.refreshIfRequired();
        return super.hashCode();
    }

    public synchronized Object put(Object key, Object value) {
        Object result;
        this.refreshIfRequired();
        VisualKey vKey = VisualAttributeMap.getVisualKey(key);
        if (vKey != null && vKey.getNature() == VisualKey.Nature.CONTROLLED) {
            Object vValue;
            switch (vKey) {
                case EDGE_SOURCE_LABEL: {
                    assert (value instanceof Object[]) : String.format("Incorrect value %s", value);
                    Object[] vValues = (Object[])value;
                    assert (vValues.length == 2) : String.format("Incorrect value array", Arrays.toString(vValues));
                    vValue = vValues[0];
                    this.visuals.put(VisualKey.EDGE_TARGET_LABEL, vValues[1], false);
                    break;
                }
                case EDGE_SOURCE_POS: {
                    assert (value instanceof Object[]) : String.format("Incorrect value %s", value);
                    Object[] vValues = (Object[])value;
                    assert (vValues.length == 2) : String.format("Incorrect value array", Arrays.toString(vValues));
                    vValue = vValues[0];
                    this.visuals.put(VisualKey.EDGE_TARGET_POS, vValues[1], false);
                    break;
                }
                case EDGE_TARGET_LABEL: {
                    assert (value instanceof Object[]) : String.format("Incorrect value %s", value);
                    Object[] vValues = (Object[])value;
                    assert (vValues.length == 2) : String.format("Incorrect value array", Arrays.toString(vValues));
                    vValue = vValues[1];
                    this.visuals.put(VisualKey.EDGE_SOURCE_LABEL, vValues[0], false);
                    break;
                }
                case EDGE_TARGET_POS: {
                    assert (value instanceof Object[]) : String.format("Incorrect value %s", value);
                    Object[] vValues = (Object[])value;
                    assert (vValues.length == 2) : String.format("Incorrect value array", Arrays.toString(vValues));
                    vValue = vValues[1];
                    this.visuals.put(VisualKey.EDGE_SOURCE_POS, vValues[0], false);
                    break;
                }
                case LINE_STYLE: {
                    vValue = LineStyle.getStyle((Integer)value);
                    break;
                }
                case NODE_POS: {
                    Rectangle2D bounds = (Rectangle2D)value;
                    vValue = new Point2D.Double(bounds.getCenterX(), bounds.getCenterY());
                    break;
                }
                default: {
                    vValue = value;
                }
            }
            this.visuals.put(vKey, vValue, false);
            result = super.put(key, value);
        } else {
            result = super.get(key);
        }
        return result;
    }

    public synchronized Object remove(Object key) {
        this.refreshIfRequired();
        VisualKey vKey = VisualAttributeMap.getVisualKey(key);
        if (vKey != null) {
            if (vKey.getNature() == VisualKey.Nature.DERIVED) {
                throw new UnsupportedOperationException();
            }
            switch (vKey) {
                case EDGE_SOURCE_LABEL: {
                    this.visuals.remove(VisualKey.EDGE_TARGET_LABEL, false);
                    break;
                }
                case EDGE_SOURCE_POS: {
                    this.visuals.remove(VisualKey.EDGE_TARGET_POS, false);
                    break;
                }
                case EDGE_TARGET_LABEL: {
                    this.visuals.remove(VisualKey.EDGE_SOURCE_LABEL, false);
                    break;
                }
                case EDGE_TARGET_POS: {
                    this.visuals.remove(VisualKey.EDGE_SOURCE_POS, false);
                }
            }
            this.visuals.remove(vKey, false);
        }
        return super.remove(key);
    }

    public synchronized void clear() {
        throw new UnsupportedOperationException();
    }

    public AttributeMap applyMap(Map change) {
        return super.applyMap(change);
    }

    private void refreshIfRequired() {
        if (!this.changedKeys.isEmpty()) {
            for (VisualKey vKey : this.changedKeys) {
                this.putVisual(vKey, this.visuals.get(vKey));
            }
            this.changedKeys.clear();
        }
    }

    private void putVisual(VisualKey key, Object value) {
        switch (key) {
            case EDGE_SOURCE_LABEL: {
                if (value == null) {
                    super.remove((Object)"extraLabelPositions");
                    break;
                }
                value = new String[]{(String)value, this.visuals.getEdgeTargetLabel()};
                if (super.containsKey((Object)"extraLabelPositions")) break;
                super.put((Object)"extraLabelPositions", (Object)EXTRA_LABEL_POSITIONS);
                break;
            }
            case EDGE_SOURCE_POS: {
                value = new Point2D[]{(Point2D)value, this.visuals.getEdgeTargetPos()};
                break;
            }
            case EDGE_SOURCE_SHAPE: {
                EdgeEnd sourceShape = (EdgeEnd)((Object)value);
                value = sourceShape.getCode();
                super.put((Object)"beginSize", (Object)sourceShape.getSize());
                super.put((Object)"beginFill", (Object)sourceShape.isFilled());
                break;
            }
            case EDGE_TARGET_LABEL: {
                if (value == null) {
                    super.remove((Object)"extraLabelPositions");
                    break;
                }
                value = new String[]{this.visuals.getEdgeSourceLabel(), (String)value};
                if (super.containsKey((Object)"extraLabelPositions")) break;
                super.put((Object)"extraLabelPositions", (Object)EXTRA_LABEL_POSITIONS);
                break;
            }
            case EDGE_TARGET_POS: {
                value = new Point2D[]{this.visuals.getEdgeSourcePos(), (Point2D)value};
                break;
            }
            case EDGE_TARGET_SHAPE: {
                EdgeEnd targetShape = (EdgeEnd)((Object)value);
                value = targetShape.getCode();
                super.put((Object)"endSize", (Object)targetShape.getSize());
                super.put((Object)"endFill", (Object)targetShape.isFilled());
                break;
            }
            case FONT: {
                value = Options.LABEL_FONT.deriveFont((Integer)value);
                break;
            }
            case COLOR: 
            case FOREGROUND: {
                if (value == null) {
                    super.remove((Object)"linecolor");
                    break;
                }
                super.put((Object)"linecolor", value);
                break;
            }
            case LINE_STYLE: {
                value = ((LineStyle)((Object)value)).getCode();
                break;
            }
            case NODE_POS: {
                Rectangle2D b = (Rectangle2D)super.get((Object)"bounds");
                Dimension2D size = b == null ? (Dimension2D)VisualKey.NODE_SIZE.getDefaultValue() : new Dimension((int)b.getWidth(), (int)b.getHeight());
                Point2D pos = (Point2D)value;
                pos = new Point2D.Double(pos.getX() - size.getWidth() / 2.0, pos.getY() - size.getHeight() / 2.0);
                b = new Rectangle();
                b.setFrame(pos, size);
                value = b;
                break;
            }
            case POINTS: {
                value = new ArrayList((List)value);
            }
        }
        String attrKey = VisualAttributeMap.getAttrKey(key);
        if (attrKey != null) {
            if (value == null) {
                super.remove((Object)attrKey);
            } else {
                super.put((Object)attrKey, value);
            }
        }
    }

    public static VisualKey getVisualKey(Object key) {
        return attrToVisualKeyMap.get(key);
    }

    public static String getAttrKey(VisualKey key) {
        return visualToAttrKeyMap.get((Object)key);
    }
}

