/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.look;

import groove.gui.layout.JCellLayout;
import groove.gui.look.EdgeEnd;
import groove.gui.look.LineStyle;
import groove.gui.look.MultiLabel;
import groove.gui.look.NodeShape;
import groove.gui.look.Values;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public enum VisualKey {
    ADORNMENT(String.class, null, Nature.REFRESHABLE),
    BACKGROUND(Color.class, Values.DEFAULT_BACKGROUND, Nature.DERIVED),
    COLOR(Color.class, null, Nature.CONTROLLED),
    DASH(float[].class, Values.NO_DASH, Nature.DERIVED),
    EDGE_SOURCE_SHAPE(EdgeEnd.class, (Object)((Object)EdgeEnd.NONE), Nature.REFRESHABLE),
    EDGE_SOURCE_LABEL(String.class, null, Nature.REFRESHABLE),
    EDGE_SOURCE_POS(Point2D.class, JCellLayout.defaultLabelPosition, Nature.CONTROLLED),
    EDGE_TARGET_SHAPE(EdgeEnd.class, (Object)((Object)EdgeEnd.ARROW), Nature.REFRESHABLE),
    EDGE_TARGET_LABEL(String.class, null, Nature.REFRESHABLE),
    EDGE_TARGET_POS(Point2D.class, JCellLayout.defaultLabelPosition, Nature.CONTROLLED),
    ERROR(Boolean.class, false, Nature.REFRESHABLE),
    EMPHASIS(Boolean.class, false, Nature.CONTROLLED),
    FONT(Integer.class, 0, Nature.DERIVED),
    FOREGROUND(Color.class, Values.DEFAULT_FOREGROUND, Nature.DERIVED),
    INNER_LINE(Color.class, null, Nature.DERIVED),
    INSET(Integer.class, 0, Nature.DERIVED),
    LABEL(MultiLabel.class, new MultiLabel(), Nature.REFRESHABLE),
    LABEL_POS(Point2D.class, JCellLayout.defaultLabelPosition, Nature.CONTROLLED),
    LINE_STYLE(LineStyle.class, (Object)((Object)LineStyle.ORTHOGONAL), Nature.CONTROLLED),
    LINE_WIDTH(Float.class, Float.valueOf(1.0f), Nature.DERIVED),
    NODE_POS(Point2D.class, new Point2D.Double(10.0, 10.0), Nature.CONTROLLED),
    NODE_SHAPE(NodeShape.class, (Object)((Object)NodeShape.RECTANGLE), Nature.DERIVED),
    NODE_SIZE(Dimension2D.class, new Dimension(19, 19), Nature.REFRESHABLE),
    OPAQUE(Boolean.class, false, Nature.DERIVED),
    POINTS(List.class, Arrays.asList(new Point2D.Double(), new Point2D.Double()), Nature.CONTROLLED),
    VISIBLE(Boolean.class, true, Nature.REFRESHABLE);

    private final Class<?> type;
    private final Object defaultValue;
    private final Nature nature;
    private static final VisualKey[] REFRESHABLES;
    private static final VisualKey[] DERIVEDS;
    private static final VisualKey[] CONTROLLEDS;

    static {
        ArrayList<VisualKey> deriveds = new ArrayList<VisualKey>();
        ArrayList<VisualKey> refreshables = new ArrayList<VisualKey>();
        ArrayList<VisualKey> controlleds = new ArrayList<VisualKey>();
        VisualKey[] visualKeyArray = VisualKey.values();
        int n = visualKeyArray.length;
        int n2 = 0;
        while (n2 < n) {
            VisualKey key = visualKeyArray[n2];
            switch (key.getNature()) {
                case CONTROLLED: {
                    controlleds.add(key);
                    break;
                }
                case DERIVED: {
                    deriveds.add(key);
                    break;
                }
                case REFRESHABLE: {
                    refreshables.add(key);
                }
            }
            ++n2;
        }
        DERIVEDS = deriveds.toArray(new VisualKey[deriveds.size()]);
        REFRESHABLES = refreshables.toArray(new VisualKey[refreshables.size()]);
        CONTROLLEDS = controlleds.toArray(new VisualKey[controlleds.size()]);
    }

    private VisualKey(Class<?> type, Object defaultValue, Nature nature) {
        this.type = type;
        this.defaultValue = defaultValue;
        this.nature = nature;
        this.test(defaultValue);
    }

    public void test(Object value) throws IllegalArgumentException {
        boolean error;
        if (value == null) {
            error = this.type == Integer.class || this.type == Boolean.class;
        } else {
            boolean bl = error = !this.type.isAssignableFrom(value.getClass());
        }
        if (error) {
            throw new IllegalArgumentException(String.format("%s value %s should be of type %s", new Object[]{this, value, this.type}));
        }
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public Nature getNature() {
        return this.nature;
    }

    public static VisualKey[] refreshables() {
        return REFRESHABLES;
    }

    public static VisualKey[] deriveds() {
        return DERIVEDS;
    }

    public static VisualKey[] controlleds() {
        return CONTROLLEDS;
    }

    public static enum Nature {
        DERIVED,
        CONTROLLED,
        REFRESHABLE;

    }
}

