/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.tree;

import groove.grammar.model.GrammarModel;
import groove.grammar.model.ResourceKind;
import groove.gui.Simulator;
import groove.gui.SimulatorListener;
import groove.gui.SimulatorModel;
import groove.gui.action.ActionStore;
import groove.gui.display.ResourceDisplay;
import groove.gui.tree.DisplayTreeNode;
import groove.gui.tree.ResourceTreeNode;
import java.awt.Color;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public abstract class AbstractResourceTree
extends JTree
implements SimulatorListener {
    private final ResourceDisplay parentDisplay;
    private final ResourceKind resourceKind;
    private MouseListener mouseListener;
    private TreeSelectionListener selectionListener;
    private boolean listening;
    private Color enabledBackground;

    protected AbstractResourceTree(ResourceDisplay parentDisplay) {
        this.parentDisplay = parentDisplay;
        this.resourceKind = parentDisplay.getResourceKind();
    }

    void installListeners() {
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                AbstractResourceTree.this.repaint();
            }

            @Override
            public void focusGained(FocusEvent e) {
                AbstractResourceTree.this.repaint();
            }
        });
        this.addMouseListener(this.getMouseListener());
        this.activateListeners();
    }

    void activateListeners() {
        if (this.listening) {
            throw new IllegalStateException();
        }
        this.listening = true;
        this.addTreeSelectionListener(this.getSelectionListener());
        this.getSimulatorModel().addListener(this, SimulatorModel.Change.GRAMMAR, SimulatorModel.Change.GTS, SimulatorModel.Change.toChange(this.getResourceKind()));
    }

    void suspendListeners() {
        if (!this.listening) {
            throw new IllegalStateException();
        }
        this.listening = false;
        this.removeTreeSelectionListener(this.getSelectionListener());
        this.getSimulatorModel().removeListener(this, new SimulatorModel.Change[0]);
    }

    private TreeSelectionListener getSelectionListener() {
        if (this.selectionListener == null) {
            this.selectionListener = this.createSelectionListener();
        }
        return this.selectionListener;
    }

    TreeSelectionListener createSelectionListener() {
        return new MySelectionListener();
    }

    private MouseListener getMouseListener() {
        if (this.mouseListener == null) {
            this.mouseListener = this.createMouseListener();
        }
        return this.mouseListener;
    }

    abstract MouseListener createMouseListener();

    JPopupMenu createPopupMenu(TreeNode node) {
        JPopupMenu res = new JPopupMenu();
        res.setFocusable(false);
        res.add(this.getActions().getNewAction(this.getResourceKind()));
        if (node instanceof ResourceTreeNode) {
            res.add(this.getActions().getEditAction(this.getResourceKind()));
            res.addSeparator();
            res.add(this.getActions().getCopyAction(this.getResourceKind()));
            res.add(this.getActions().getDeleteAction(this.getResourceKind()));
            res.add(this.getActions().getRenameAction(this.getResourceKind()));
            if (this.getResourceKind().isEnableable()) {
                res.addSeparator();
                res.add(this.getActions().getEnableAction(this.getResourceKind()));
            }
        }
        return res;
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (enabled != this.isEnabled()) {
            if (!enabled) {
                this.enabledBackground = this.getBackground();
                this.setBackground(null);
            } else if (this.enabledBackground != null) {
                this.setBackground(this.enabledBackground);
            }
        }
        super.setEnabled(enabled);
    }

    public void dispose() {
        this.suspendListeners();
    }

    final GrammarModel getGrammar() {
        return this.getSimulatorModel().getGrammar();
    }

    final ResourceDisplay getParentDisplay() {
        return this.parentDisplay;
    }

    final Simulator getSimulator() {
        return this.parentDisplay.getSimulator();
    }

    final SimulatorModel getSimulatorModel() {
        return this.parentDisplay.getSimulatorModel();
    }

    final ActionStore getActions() {
        return this.parentDisplay.getActions();
    }

    final ResourceKind getResourceKind() {
        return this.resourceKind;
    }

    static class FolderTreeNode
    extends DisplayTreeNode {
        public FolderTreeNode(String name) {
            super(name, true);
        }
    }

    class MySelectionListener
    implements TreeSelectionListener {
        @Override
        public void valueChanged(TreeSelectionEvent evt) {
            ArrayList<TreeNode> selected = new ArrayList<TreeNode>();
            AbstractResourceTree.this.suspendListeners();
            TreePath[] paths = AbstractResourceTree.this.getSelectionPaths();
            int i = 0;
            while (paths != null && i < paths.length) {
                TreeNode node = (TreeNode)paths[i].getLastPathComponent();
                this.collectResources(node, selected);
                ++i;
            }
            this.setSelection(selected);
            AbstractResourceTree.this.activateListeners();
        }

        private void collectResources(TreeNode node, Collection<TreeNode> result) {
            if (node instanceof FolderTreeNode) {
                FolderTreeNode path = (FolderTreeNode)node;
                int i = 0;
                while (i < path.getChildCount()) {
                    this.collectResources(path.getChildAt(i), result);
                    ++i;
                }
            } else {
                result.add(node);
            }
        }

        void setSelection(Collection<TreeNode> selectedNodes) {
            ArrayList<String> selectedNames = new ArrayList<String>();
            for (TreeNode node : selectedNodes) {
                if (!(node instanceof ResourceTreeNode)) continue;
                selectedNames.add(((ResourceTreeNode)node).getName());
            }
            AbstractResourceTree.this.getSimulatorModel().doSelectSet(AbstractResourceTree.this.getResourceKind(), selectedNames);
        }
    }
}

