/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.tree;

import groove.graph.EdgeRole;
import groove.graph.Graph;
import groove.graph.Label;
import groove.gui.jgraph.JCell;
import groove.gui.look.VisualKey;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Observable;
import java.util.Set;

public class LabelFilter<G extends Graph>
extends Observable {
    private final Set<Entry> selected = new HashSet<Entry>();
    private final Map<Entry, Set<JCell<G>>> entryJCellMap = new HashMap<Entry, Set<JCell<G>>>();
    private final Map<JCell<G>, Set<Entry>> jCellEntryMap = new HashMap<JCell<G>, Set<Entry>>();
    private final Map<Label, LabelEntry> labelEntryMap = new HashMap<Label, LabelEntry>();
    private static VisualKey[] changedKeys = new VisualKey[]{VisualKey.VISIBLE, VisualKey.LABEL, VisualKey.NODE_SIZE};

    public void clearJCells() {
        for (Set<JCell<G>> jCellSet : this.entryJCellMap.values()) {
            jCellSet.clear();
        }
        this.jCellEntryMap.clear();
    }

    public Set<Entry> getEntries(JCell<G> jCell) {
        Set<Entry> result = this.jCellEntryMap.get(jCell);
        if (result == null) {
            this.addJCell(jCell);
            result = this.jCellEntryMap.get(jCell);
        }
        return result;
    }

    private Set<Entry> computeEntries(JCell<G> jCell) {
        HashSet<Entry> result = new HashSet<Entry>();
        for (Label key : jCell.getKeys()) {
            result.add(this.getEntry(key));
        }
        return result;
    }

    public boolean addJCell(JCell<G> jCell) {
        boolean result = false;
        if (this.jCellEntryMap.containsKey(jCell)) {
            result = this.modifyJCell(jCell);
        } else {
            Set<Entry> entries = this.computeEntries(jCell);
            this.jCellEntryMap.put(jCell, entries);
            for (Entry entry : entries) {
                result |= this.addEntry(entry);
                this.entryJCellMap.get(entry).add(jCell);
            }
        }
        return result;
    }

    public boolean removeJCell(JCell<G> jCell) {
        boolean result = false;
        Set<Entry> jCellEntries = this.jCellEntryMap.remove(jCell);
        if (jCellEntries != null) {
            for (Entry jCellEntry : jCellEntries) {
                this.entryJCellMap.get(jCellEntry).remove(jCell);
            }
        }
        return result;
    }

    public boolean modifyJCell(JCell<G> jCell) {
        assert (this.jCellEntryMap.containsKey(jCell));
        boolean result = false;
        Set<Entry> newEntrySet = this.computeEntries(jCell);
        Set<Entry> oldEntrySet = this.jCellEntryMap.put(jCell, newEntrySet);
        for (Entry oldEntry : oldEntrySet) {
            if (newEntrySet.contains(oldEntry)) continue;
            this.entryJCellMap.get(oldEntry).remove(jCell);
        }
        for (Entry newEntry : newEntrySet) {
            if (oldEntrySet.contains(newEntry)) continue;
            result |= this.addEntry(newEntry);
            this.entryJCellMap.get(newEntry).add(jCell);
        }
        return result;
    }

    public Set<JCell<G>> getJCells(Entry entry) {
        return this.entryJCellMap.get(entry);
    }

    public boolean hasJCells(Entry entry) {
        Set<JCell<G>> jCells = this.getJCells(entry);
        return jCells != null && !jCells.isEmpty();
    }

    public void clear() {
        this.selected.clear();
        this.entryJCellMap.clear();
        this.jCellEntryMap.clear();
        this.labelEntryMap.clear();
    }

    public boolean addEntry(Label key) {
        return this.addEntry(this.getEntry(key));
    }

    private boolean addEntry(Entry entry) {
        boolean result = false;
        Set<JCell<G>> cells = this.entryJCellMap.get(entry);
        if (cells == null) {
            this.entryJCellMap.put(entry, new HashSet());
            this.selected.add(entry);
            result = true;
        }
        return result;
    }

    public Set<Entry> getEntries() {
        return this.entryJCellMap.keySet();
    }

    public void setSelected(Entry label, boolean selected) {
        Set<JCell<G>> changedCells = this.getSelection(label, selected);
        this.notifyIfNonempty(changedCells);
    }

    public void setSelected(Collection<Entry> entries, boolean selected) {
        HashSet<JCell<G>> changedCells = new HashSet<JCell<G>>();
        for (Entry label : entries) {
            changedCells.addAll(this.getSelection(label, selected));
        }
        this.notifyIfNonempty(changedCells);
    }

    public void changeSelected(Entry entry) {
        Set<JCell<G>> changedCells = this.getSelection(entry, !this.isSelected(entry));
        this.notifyIfNonempty(changedCells);
    }

    public void changeSelected(Collection<Entry> entries) {
        HashSet<JCell<G>> changedCells = new HashSet<JCell<G>>();
        for (Entry entry : entries) {
            changedCells.addAll(this.getSelection(entry, !this.isSelected(entry)));
        }
        this.notifyIfNonempty(changedCells);
    }

    private Set<JCell<G>> getSelection(Entry entry, boolean selected) {
        assert (this.entryJCellMap.containsKey(entry)) : String.format("Label %s unknown in map %s", entry, this.entryJCellMap);
        Set<JCell<Object>> result = this.entryJCellMap.get(entry);
        if (result == null) {
            result = Collections.emptySet();
        } else if (selected) {
            this.selected.add(entry);
        } else {
            this.selected.remove(entry);
        }
        return result;
    }

    private void notifyIfNonempty(Set<JCell<G>> changedCells) {
        if (changedCells != null && !changedCells.isEmpty()) {
            for (JCell<G> jCell : changedCells) {
                jCell.setStale(changedKeys);
                for (JCell<G> c : jCell.getContext()) {
                    c.setStale(changedKeys);
                }
            }
            this.setChanged();
            this.notifyObservers(changedCells);
        }
    }

    public boolean isSelected(Entry entry) {
        return !this.entryJCellMap.containsKey(entry) || this.selected.contains(entry);
    }

    public boolean isSelected(Set<Entry> entries) {
        boolean result = false;
        for (Entry entry : entries) {
            if (!this.isSelected(entry)) continue;
            result = true;
            break;
        }
        return result;
    }

    public boolean isFiltered(JCell<G> jCell, boolean showUnfilteredEdges) {
        boolean hasUnfilteredElements = false;
        boolean hasFilteredNodeTypes = false;
        Set<Entry> entrySet = this.getEntries(jCell);
        for (Entry entry : entrySet) {
            if (this.isSelected(entry)) {
                hasUnfilteredElements = true;
                continue;
            }
            if (entry.getLabel().getRole() != EdgeRole.NODE_TYPE) continue;
            hasFilteredNodeTypes = true;
        }
        boolean result = hasFilteredNodeTypes && !showUnfilteredEdges ? true : (hasUnfilteredElements ? false : !entrySet.isEmpty());
        return result;
    }

    public Entry getEntry(Label key) {
        LabelEntry result = this.labelEntryMap.get(key);
        if (result == null) {
            result = this.createEntry(key);
            this.labelEntryMap.put(key, result);
        }
        return result;
    }

    private LabelEntry createEntry(Label label) {
        return new LabelEntry(label);
    }

    public static interface Entry
    extends Comparable<Entry> {
        public Label getLabel();
    }

    public static class LabelEntry
    implements Entry {
        private final Label label;

        public LabelEntry(Label label) {
            this.label = label;
        }

        @Override
        public Label getLabel() {
            return this.label;
        }

        @Override
        public int compareTo(Entry o) {
            assert (o instanceof LabelEntry);
            return this.getLabel().compareTo(o.getLabel());
        }

        public int hashCode() {
            return this.label.getRole().hashCode() ^ this.label.text().hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof LabelEntry)) {
                return false;
            }
            Label otherLabel = ((LabelEntry)obj).getLabel();
            if (this.getLabel().getRole() != otherLabel.getRole()) {
                return false;
            }
            return this.getLabel().text().equals(otherLabel.text());
        }

        public String toString() {
            return this.label.toString();
        }
    }
}

