/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.tree;

import groove.grammar.Recipe;
import groove.gui.Icons;
import groove.gui.tree.ActionTreeNode;
import groove.gui.tree.DisplayTreeNode;
import groove.gui.tree.RuleTreeNode;
import groove.io.HTMLConverter;
import javax.swing.Icon;

class RecipeTreeNode
extends DisplayTreeNode
implements ActionTreeNode {
    public RecipeTreeNode(Recipe recipe) {
        super(recipe, true);
    }

    public Recipe getRecipe() {
        return (Recipe)this.getUserObject();
    }

    @Override
    public Icon getIcon() {
        return Icons.RECIPE_LIST_ICON;
    }

    @Override
    public String getName() {
        return this.getRecipe().getFullName();
    }

    @Override
    public boolean isError() {
        return this.getRecipe().getBody() == null;
    }

    @Override
    public String toString() {
        return String.valueOf(this.getRecipe().getLastName()) + " (recipe)";
    }

    @Override
    public boolean isEnabled() {
        boolean result = false;
        int count = this.getChildCount();
        int i = 0;
        while (!result && i < count) {
            RuleTreeNode child = (RuleTreeNode)this.getChildAt(i);
            result = child.isEnabled();
            ++i;
        }
        return result;
    }

    @Override
    public String getTip() {
        StringBuilder result = new StringBuilder();
        result.append("Recipe ");
        result.append(HTMLConverter.STRONG_TAG.on(this.getName()));
        if (!this.isEnabled()) {
            result.append(HTMLConverter.HTML_LINEBREAK);
            result.append("Not active in this state");
        }
        HTMLConverter.HTML_TAG.on(result);
        return result.toString();
    }
}

