/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.tree;

import groove.grammar.Rule;
import groove.grammar.model.ResourceKind;
import groove.grammar.model.RuleModel;
import groove.gui.Icons;
import groove.gui.Options;
import groove.gui.Simulator;
import groove.gui.SimulatorListener;
import groove.gui.SimulatorModel;
import groove.gui.action.ActionStore;
import groove.gui.display.DisplayKind;
import groove.gui.display.ResourceDisplay;
import groove.gui.jgraph.JAttr;
import groove.gui.tree.DisplayTreeCellRenderer;
import groove.gui.tree.DisplayTreeNode;
import groove.gui.tree.MatchTreeNode;
import groove.gui.tree.RuleTreeNode;
import groove.io.HTMLConverter;
import groove.lts.GTS;
import groove.lts.GraphState;
import groove.lts.MatchResult;
import groove.lts.RuleTransition;
import groove.lts.StartGraphState;
import groove.transform.RuleEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class StateTree
extends JTree
implements SimulatorListener {
    private final Simulator simulator;
    private final DefaultMutableTreeNode topNode = new DefaultMutableTreeNode(null, true);
    private final DefaultTreeModel treeModel = new DefaultTreeModel(this.topNode);
    private GraphState[] states = new GraphState[0];
    private Queue<GraphState> expanded = new LinkedList<GraphState>();
    private boolean listening;
    private static final int RANGE_SIZE = 100;
    private static final int MAX_EXPANDED = 2;

    public StateTree(Simulator simulator) {
        this.simulator = simulator;
        this.setEnabled(false);
        this.setLargeModel(true);
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        this.setEnabled(false);
        this.setToggleClickCount(0);
        this.setModel(this.getModel());
        this.getSelectionModel().setSelectionMode(4);
        this.setCellRenderer(new DisplayTreeCellRenderer(this));
        this.installListeners();
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    @Override
    public DefaultTreeModel getModel() {
        return this.treeModel;
    }

    private DefaultMutableTreeNode getTopNode() {
        return this.topNode;
    }

    protected void installListeners() {
        this.getSimulatorModel().addListener(this, SimulatorModel.Change.GTS, SimulatorModel.Change.STATE, SimulatorModel.Change.MATCH);
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                StateTree.this.repaint();
            }

            @Override
            public void focusGained(FocusEvent e) {
                StateTree.this.repaint();
            }
        });
        this.addTreeWillExpandListener(new TreeWillExpandListener(){
            private boolean busy = false;

            @Override
            public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
                Object lastComponent = event.getPath().getLastPathComponent();
                if (!this.busy && lastComponent instanceof RangeTreeNode) {
                    this.busy = true;
                    StateTree.this.fill((RangeTreeNode)lastComponent);
                    this.busy = false;
                }
            }

            @Override
            public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
            }
        });
        this.addTreeSelectionListener(new StateSelectionListener());
        this.addMouseListener(new StateMouseListener());
        JMenuItem showAnchorsOptionItem = this.getOptions().getItem("Show anchors");
        if (showAnchorsOptionItem != null) {
            showAnchorsOptionItem.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (StateTree.this.suspendListening()) {
                        SimulatorModel model = StateTree.this.getSimulatorModel();
                        StateTree.this.refreshList(model.getGts(), model.getState());
                        StateTree.this.activateListening();
                    }
                }
            });
        }
        this.activateListening();
    }

    protected final boolean suspendListening() {
        boolean result = this.listening;
        if (result) {
            this.listening = false;
        }
        return result;
    }

    protected final void activateListening() {
        if (this.listening) {
            throw new IllegalStateException();
        }
        this.listening = true;
    }

    protected final boolean isListening() {
        return this.listening;
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (enabled != this.isEnabled()) {
            this.setBackground(enabled ? JAttr.STATE_BACKGROUND : null);
        }
        super.setEnabled(enabled);
    }

    private JPopupMenu createPopupMenu(TreeNode node) {
        JPopupMenu result = new JPopupMenu();
        if (node instanceof StateTreeNode) {
            result.add(this.getActions().getEditStateAction());
            result.add(this.getActions().getSaveStateAction());
            result.add(this.getActions().getExportStateAction());
        } else if (node instanceof MatchTreeNode) {
            result.add(this.getActions().getApplyMatchAction());
        }
        return result;
    }

    @Override
    public void update(SimulatorModel source, SimulatorModel oldModel, Set<SimulatorModel.Change> changes) {
        if (this.suspendListening()) {
            if (changes.contains((Object)SimulatorModel.Change.GTS)) {
                this.setEnabled(source.hasGts());
                this.refreshList(source.getGts(), oldModel.getState());
            }
            RuleModel ruleModel = (RuleModel)source.getResource(ResourceKind.RULE);
            this.refreshSelection(source.getState(), ruleModel, source.getMatch());
            this.activateListening();
        }
    }

    private void refreshList(GTS gts, GraphState previous) {
        if (gts == null) {
            this.getTopNode().removeAllChildren();
            this.getModel().reload();
            this.states = new GraphState[0];
        } else {
            StateTreeNode stateNode;
            if (previous != null && (stateNode = this.getStateNode(previous)) != null && this.isExpanded(this.createPath(stateNode))) {
                this.expanded.add(previous);
                if (this.expanded.size() > 2) {
                    this.expanded.poll();
                }
            }
            this.getTopNode().removeAllChildren();
            this.states = new GraphState[gts.nodeCount()];
            Iterator<? extends GraphState> iterator = gts.nodeSet().iterator();
            while (iterator.hasNext()) {
                GraphState state;
                this.states[state.getNumber()] = state = iterator.next();
            }
            if (this.hasRangeNodes()) {
                int i = 0;
                while (i < this.states.length) {
                    if (this.states[i] != null) {
                        RangeTreeNode rangeNode = new RangeTreeNode(i);
                        this.getTopNode().add(rangeNode);
                        rangeNode.add(this.createStateNode(this.states[i]));
                    }
                    i += 100;
                }
                this.getModel().reload();
                i = 0;
                while (i < this.getTopNode().getChildCount()) {
                    this.collapsePath(this.createPath((RangeTreeNode)this.getTopNode().getFirstChild()));
                    ++i;
                }
            } else {
                this.fill(this.getTopNode());
            }
        }
        this.setEnabled(gts != null);
    }

    private void fill(DefaultMutableTreeNode parent) {
        if (parent.getChildCount() <= 1) {
            parent.removeAllChildren();
            ArrayList<StateTreeNode> stateNodes = new ArrayList<StateTreeNode>(100);
            int lower = parent instanceof RangeTreeNode ? ((RangeTreeNode)parent).getLower() : 0;
            int upper = Math.min(this.states.length, lower + 100);
            int s = lower;
            while (s < upper) {
                GraphState state = this.states[s];
                if (state != null) {
                    StateTreeNode stateNode = this.createStateNode(state);
                    parent.add(stateNode);
                    stateNodes.add(stateNode);
                }
                ++s;
            }
            this.getModel().reload(parent);
            for (StateTreeNode stateNode : stateNodes) {
                this.setStateExpanded(stateNode);
            }
        }
    }

    private void setStateExpanded(StateTreeNode stateNode) {
        int i = 0;
        while (i < stateNode.getChildCount()) {
            this.expandPath(this.createPath((RuleTreeNode)stateNode.getChildAt(i)));
            ++i;
        }
        if (!stateNode.isExpanded()) {
            this.collapsePath(this.createPath(stateNode));
        }
    }

    private StateTreeNode createStateNode(GraphState state) {
        boolean isExpanded = this.expanded.contains(state);
        StateTreeNode result = new StateTreeNode(state, isExpanded);
        TreeMap<Rule, TreeSet<MatchResult>> matchMap = new TreeMap<Rule, TreeSet<MatchResult>>();
        ArrayList<MatchResult> matches = new ArrayList<MatchResult>();
        for (RuleTransition trans : state.getRuleTransitions()) {
            matches.add(trans.getKey());
        }
        matches.addAll(state.getMatches());
        for (MatchResult match : matches) {
            Rule rule = match.getRule();
            TreeSet<MatchResult> ruleMatches = (TreeSet<MatchResult>)matchMap.get(rule);
            if (ruleMatches == null) {
                ruleMatches = new TreeSet<MatchResult>(MatchResult.COMPARATOR);
                matchMap.put(rule, ruleMatches);
            }
            ruleMatches.add(match);
        }
        boolean anchored = this.getOptions().isSelected("Show anchors");
        for (Map.Entry matchEntry : matchMap.entrySet()) {
            Rule rule = (Rule)matchEntry.getKey();
            RuleTreeNode ruleNode = new RuleTreeNode(this.getRuleDisplay(), rule.getFullName());
            result.add(ruleNode);
            int count = 0;
            for (MatchResult trans : (Set)matchEntry.getValue()) {
                MatchTreeNode transNode = new MatchTreeNode(this.getSimulatorModel(), state, trans, ++count, anchored);
                ruleNode.add(transNode);
            }
        }
        return result;
    }

    private void refreshSelection(GraphState state, RuleModel ruleModel, MatchResult match) {
        StateTreeNode stateNode;
        if (state != null && (stateNode = this.getStateNode(state)) != null) {
            TreePath statePath = this.createPath(stateNode);
            this.expandPath(statePath);
            TreePath selectPath = statePath;
            if (match != null) {
                int i = 0;
                block0: while (i < stateNode.getChildCount()) {
                    RuleTreeNode ruleNode = (RuleTreeNode)stateNode.getChildAt(i);
                    if (ruleNode.getRule().equals(ruleModel)) {
                        RuleEvent event = match.getEvent();
                        int m = 0;
                        while (m < ruleNode.getChildCount()) {
                            MatchTreeNode matchNode = (MatchTreeNode)ruleNode.getChildAt(m);
                            if (matchNode.getMatch().getEvent().equals(event)) {
                                selectPath = this.createPath(matchNode);
                                break block0;
                            }
                            ++m;
                        }
                        break;
                    }
                    ++i;
                }
            }
            this.setSelectionPath(selectPath);
            if (stateNode.getChildCount() > 0) {
                RuleTreeNode ruleNode = (RuleTreeNode)stateNode.getLastChild();
                MatchTreeNode transNode = (MatchTreeNode)ruleNode.getLastChild();
                this.scrollPathToVisible(this.createPath(transNode));
            }
            this.scrollPathToVisible(statePath);
        }
    }

    private TreePath createPath(DefaultMutableTreeNode node) {
        return new TreePath(node.getPath());
    }

    private StateTreeNode getStateNode(GraphState state) {
        StateTreeNode result = null;
        int nr = state.getNumber();
        if (this.hasRangeNodes()) {
            RangeTreeNode rangeNode = (RangeTreeNode)this.find(this.getTopNode(), nr);
            if (rangeNode != null) {
                this.fill(rangeNode);
                result = (StateTreeNode)this.find(rangeNode, nr);
            }
        } else {
            result = (StateTreeNode)this.find(this.getTopNode(), nr);
        }
        return result;
    }

    private NumberedTreeNode find(TreeNode parent, int number) {
        NumberedTreeNode result = null;
        int lower = 0;
        int upper = parent.getChildCount() - 1;
        boolean found = false;
        while (!found && lower <= upper) {
            int mid = (lower + upper) / 2;
            result = (NumberedTreeNode)parent.getChildAt(mid);
            int resultNumber = result.getNumber();
            if (result.contains(number)) {
                found = true;
                continue;
            }
            if (resultNumber < number) {
                lower = mid + 1;
                continue;
            }
            if (resultNumber <= number) continue;
            upper = mid - 1;
        }
        return found ? result : null;
    }

    private boolean hasRangeNodes() {
        return this.states.length >= 100;
    }

    private final SimulatorModel getSimulatorModel() {
        return this.simulator.getModel();
    }

    private final ActionStore getActions() {
        return this.simulator.getActions();
    }

    private final ResourceDisplay getRuleDisplay() {
        return (ResourceDisplay)this.simulator.getDisplaysPanel().getDisplay(DisplayKind.RULE);
    }

    private final Options getOptions() {
        return this.simulator.getOptions();
    }

    private static abstract class NumberedTreeNode
    extends DisplayTreeNode {
        protected NumberedTreeNode(Object userObject) {
            super(userObject, true);
        }

        public abstract int getNumber();

        public abstract boolean contains(int var1);
    }

    private class RangeTreeNode
    extends NumberedTreeNode {
        public RangeTreeNode(int lower) {
            super(lower);
        }

        public int getLower() {
            return (Integer)this.getUserObject();
        }

        public int getUpper() {
            return Math.min(this.getLower() + 100, StateTree.this.states.length) - 1;
        }

        @Override
        public int getNumber() {
            return this.getLower();
        }

        @Override
        public String getText() {
            return "[" + this.getLower() + ".." + this.getUpper() + "]";
        }

        @Override
        public boolean contains(int number) {
            return this.getLower() <= number && this.getUpper() >= number;
        }
    }

    private class StateMouseListener
    extends MouseAdapter {
        private StateMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent evt) {
            TreePath path = StateTree.this.getPathForLocation(evt.getX(), evt.getY());
            if (path != null && evt.getButton() == 3 && !StateTree.this.isRowSelected(StateTree.this.getRowForPath(path))) {
                StateTree.this.setSelectionPath(path);
            }
            this.maybeShowPopup(evt);
        }

        @Override
        public void mouseReleased(MouseEvent evt) {
            this.maybeShowPopup(evt);
        }

        @Override
        public void mouseClicked(MouseEvent evt) {
            if (evt.getButton() != 1) {
                return;
            }
            TreePath path = StateTree.this.getSelectionPath();
            if (path == null) {
                return;
            }
            Object node = path.getLastPathComponent();
            switch (evt.getClickCount()) {
                case 1: {
                    DisplayKind toDisplay = null;
                    if (node instanceof RuleTreeNode) {
                        toDisplay = DisplayKind.RULE;
                    } else if (StateTree.this.getSimulatorModel().getDisplay() != DisplayKind.LTS) {
                        toDisplay = DisplayKind.STATE;
                    }
                    if (toDisplay == null) break;
                    StateTree.this.getSimulatorModel().setDisplay(toDisplay);
                    break;
                }
                case 2: {
                    StateTree.this.getActions().getApplyMatchAction().execute();
                }
            }
        }

        private void maybeShowPopup(MouseEvent evt) {
            if (evt.isPopupTrigger()) {
                TreePath selectedPath = StateTree.this.getPathForLocation(evt.getX(), evt.getY());
                TreeNode selectedNode = selectedPath == null ? null : (TreeNode)selectedPath.getLastPathComponent();
                StateTree.this.requestFocus();
                StateTree.this.createPopupMenu(selectedNode).show(evt.getComponent(), evt.getX(), evt.getY());
            }
        }
    }

    private class StateSelectionListener
    implements TreeSelectionListener {
        private StateSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent evt) {
            if (StateTree.this.suspendListening()) {
                TreePath[] paths = StateTree.this.getSelectionPaths();
                if (paths != null && paths.length == 1) {
                    StateTreeNode stateNode;
                    GraphState selectedState = null;
                    MatchResult selectedMatch = null;
                    Object selectedNode = paths[0].getLastPathComponent();
                    if (selectedNode instanceof MatchTreeNode) {
                        selectedMatch = ((MatchTreeNode)selectedNode).getMatch();
                        selectedState = ((MatchTreeNode)selectedNode).getSource();
                    } else if (selectedNode instanceof StateTreeNode) {
                        selectedState = ((StateTreeNode)selectedNode).getState();
                    } else if (selectedNode instanceof RuleTreeNode) {
                        Object parentNode = paths[0].getPathComponent(paths[0].getPathCount() - 2);
                        selectedState = ((StateTreeNode)parentNode).getState();
                    }
                    if (selectedState != null && (stateNode = StateTree.this.getStateNode(selectedState)) != null) {
                        StateTree.this.expandPath(StateTree.this.createPath(stateNode));
                        StateTree.this.getSimulatorModel().setMatch(selectedState, selectedMatch);
                    }
                }
                StateTree.this.getSimulatorModel().doSelectSet(ResourceKind.RULE, this.getSelectedRules());
                StateTree.this.activateListening();
            }
        }

        private Set<String> getSelectedRules() {
            HashSet<String> result = new HashSet<String>();
            int[] selectedRows = StateTree.this.getSelectionRows();
            if (selectedRows != null) {
                int[] nArray = selectedRows;
                int n = selectedRows.length;
                int n2 = 0;
                while (n2 < n) {
                    int selectedRow = nArray[n2];
                    Object[] nodes = StateTree.this.getPathForRow(selectedRow).getPath();
                    int i = nodes.length - 1;
                    while (i >= 0) {
                        if (nodes[i] instanceof RuleTreeNode) {
                            result.add(((RuleTreeNode)nodes[i]).getRule().getFullName());
                        }
                        --i;
                    }
                    ++n2;
                }
            }
            return result;
        }
    }

    static class StateTreeNode
    extends NumberedTreeNode {
        private final boolean expanded;

        public StateTreeNode(GraphState state, boolean expanded) {
            super(state);
            this.expanded = expanded;
        }

        @Override
        public int getNumber() {
            return this.getState().getNumber();
        }

        @Override
        public boolean contains(int number) {
            return this.getNumber() == number;
        }

        public GraphState getState() {
            return (GraphState)this.getUserObject();
        }

        public boolean isExpanded() {
            return this.expanded;
        }

        @Override
        public String getText() {
            return HTMLConverter.HTML_TAG.on("State " + HTMLConverter.ITALIC_TAG.on(this.getState().toString()));
        }

        @Override
        public Icon getIcon() {
            GraphState state = this.getState();
            if (state instanceof StartGraphState) {
                return Icons.STATE_START_ICON;
            }
            if (state.getGTS().isResult(state)) {
                return Icons.STATE_RESULT_ICON;
            }
            if (state.getGTS().isFinal(state)) {
                return Icons.STATE_FINAL_ICON;
            }
            if (state.isClosed()) {
                return Icons.STATE_CLOSED_ICON;
            }
            return Icons.STATE_OPEN_ICON;
        }
    }
}

