/*
 * Decompiled with CFR 0.152.
 */
package groove.io;

import groove.graph.GraphRole;
import groove.io.CompositeExtensionFilter;
import groove.io.ExtensionFilter;
import groove.io.SimpleExtensionFilter;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum FileType {
    GXL(".gxl", "GXL files"),
    RULE(".gpr", "Groove production rules"),
    STATE(".gst", "Groove state graphs"),
    TYPE(".gty", "Groove type graphs"),
    GRAMMAR(".gps", "Groove production systems"),
    LAYOUT(".gl", "Groove old layout files"),
    CONTROL(".gcp", "Groove control files"),
    PROPERTY(".properties", "Groove property files"),
    LOG(".log", "Log files"),
    TEXT(".txt", "Simple text files"),
    PROLOG1(".pro", "Prolog files"),
    PROLOG2(".pl", "Prolog files"),
    CONFIG(".xml", "Configuration files"),
    GROOVY(".groovy", "Groovy files"),
    ZIP(".zip", "ZIP files"),
    JAR(".jar", "JAR files"),
    AUT(".aut", "CADP .aut files"),
    COL(".col", "DIMACS graph format"),
    EPS(".eps", "EPS image files"),
    FSM(".fsm", "FSM layout files"),
    JPG(".jpg", "JPEG image files"),
    PNG(".png", "PNG image files"),
    TIKZ(".tikz", "LaTeX Tikz files"),
    KTH(".kth", "Simple KTH files"),
    PDF(".pdf", "Adobe PDF documents");

    public static final EnumSet<FileType> importNative;
    private static final Map<EnumSet<FileType>, String> compositeDescriptions;
    public static final EnumSet<FileType> graphs;
    public static final EnumSet<FileType> grammars;
    public static final EnumSet<FileType> prolog;
    public static final EnumSet<FileType> hosts;
    public static final EnumSet<FileType> layoutless;
    private final String extension;
    private final String description;
    private static final Map<FileType, ExtensionFilter> simpleFilterMap;
    private static final Map<EnumSet<FileType>, ExtensionFilter> compositeFilterMap;
    public static final ExtensionFilter GXL_FILTER;
    public static final ExtensionFilter RULE_FILTER;
    public static final ExtensionFilter STATE_FILTER;
    public static final ExtensionFilter TYPE_FILTER;
    public static final ExtensionFilter GRAMMAR_FILTER;
    public static final ExtensionFilter LAYOUT_FILTER;
    public static final ExtensionFilter CONTROL_FILTER;
    public static final ExtensionFilter PROPERTIES_FILTER;
    public static final ExtensionFilter CONFIGURATION_FILTER;
    public static final ExtensionFilter LOG_FILTER;
    public static final ExtensionFilter TEXT_FILTER;
    public static final ExtensionFilter PROLOG1_FILTER;
    public static final ExtensionFilter PROLOG2_FILTER;
    public static final ExtensionFilter GROOVY_FILTER;
    public static final ExtensionFilter ZIP_FILTER;
    public static final ExtensionFilter JAR_FILTER;
    public static final ExtensionFilter AUT_FILTER;
    public static final ExtensionFilter COL_FILTER;
    public static final ExtensionFilter EPS_FILTER;
    public static final ExtensionFilter FSM_FILTER;
    public static final ExtensionFilter JPG_FILTER;
    public static final ExtensionFilter PNG_FILTER;
    public static final ExtensionFilter TIKZ_FILTER;
    public static final ExtensionFilter KTH_FILTER;
    public static final ExtensionFilter PDF_FILTER;
    public static final ExtensionFilter GRAPHS_FILTER;
    public static final ExtensionFilter GRAMMARS_FILTER;
    public static final ExtensionFilter PROLOG_FILTER;
    public static final ExtensionFilter HOSTS_FILTER;

    static {
        importNative = EnumSet.of(RULE, STATE, TYPE, CONTROL);
        compositeDescriptions = new HashMap<EnumSet<FileType>, String>();
        graphs = EnumSet.of(STATE, RULE, TYPE, GXL);
        compositeDescriptions.put(graphs, String.format("Graph files (*%s, *%s, *%s, *%s)", STATE.getExtension(), RULE.getExtension(), TYPE.getExtension(), GXL.getExtension()));
        grammars = EnumSet.of(GRAMMAR, ZIP, JAR);
        compositeDescriptions.put(grammars, String.format("Grammar files (*%s, *%s, *%s)", GRAMMAR.getExtension(), ZIP.getExtension(), JAR.getExtension()));
        prolog = EnumSet.of(PROLOG1, PROLOG2);
        compositeDescriptions.put(prolog, String.format("Prolog files (*%s, *%s)", PROLOG1.getExtension(), PROLOG2.getExtension()));
        hosts = EnumSet.of(STATE, GXL);
        compositeDescriptions.put(hosts, String.format("Host graphs (*%s, *%s)", STATE.getExtension(), GXL.getExtension()));
        layoutless = EnumSet.of(STATE, AUT, COL, FSM);
        simpleFilterMap = new HashMap<FileType, ExtensionFilter>();
        compositeFilterMap = new HashMap<EnumSet<FileType>, ExtensionFilter>();
        GXL_FILTER = FileType.createFilter(GXL, true);
        RULE_FILTER = FileType.createFilter(RULE, true);
        STATE_FILTER = FileType.createFilter(STATE, true);
        TYPE_FILTER = FileType.createFilter(TYPE, true);
        GRAMMAR_FILTER = FileType.createFilter(GRAMMAR, true);
        LAYOUT_FILTER = FileType.createFilter(LAYOUT, true);
        CONTROL_FILTER = FileType.createFilter(CONTROL, true);
        PROPERTIES_FILTER = FileType.createFilter(PROPERTY, true);
        CONFIGURATION_FILTER = FileType.createFilter(CONFIG, false);
        LOG_FILTER = FileType.createFilter(LOG, true);
        TEXT_FILTER = FileType.createFilter(TEXT, true);
        PROLOG1_FILTER = FileType.createFilter(PROLOG1, true);
        PROLOG2_FILTER = FileType.createFilter(PROLOG2, true);
        GROOVY_FILTER = FileType.createFilter(GROOVY, true);
        ZIP_FILTER = FileType.createFilter(ZIP, true);
        JAR_FILTER = FileType.createFilter(JAR, true);
        AUT_FILTER = FileType.createFilter(AUT, true);
        COL_FILTER = FileType.createFilter(COL, true);
        EPS_FILTER = FileType.createFilter(EPS, true);
        FSM_FILTER = FileType.createFilter(FSM, true);
        JPG_FILTER = FileType.createFilter(JPG, true);
        PNG_FILTER = FileType.createFilter(PNG, true);
        TIKZ_FILTER = FileType.createFilter(TIKZ, true);
        KTH_FILTER = FileType.createFilter(KTH, true);
        PDF_FILTER = FileType.createFilter(PDF, true);
        GRAPHS_FILTER = FileType.createFilter(graphs, true);
        GRAMMARS_FILTER = FileType.createFilter(grammars, true);
        PROLOG_FILTER = FileType.createFilter(prolog, true);
        HOSTS_FILTER = FileType.createFilter(hosts, true);
    }

    private static String getDescription(EnumSet<FileType> fileTypes) {
        return compositeDescriptions.get(fileTypes);
    }

    private FileType(String extension, String description) {
        this.extension = extension;
        this.description = description;
    }

    public String getExtension() {
        return this.extension;
    }

    public String getExtensionName() {
        return this.extension.substring(1);
    }

    public String getDescription() {
        return this.description;
    }

    private static ExtensionFilter createFilter(FileType fileType, boolean acceptDir) {
        SimpleExtensionFilter result = new SimpleExtensionFilter(fileType.getDescription(), fileType.getExtension(), acceptDir);
        simpleFilterMap.put(fileType, result);
        return result;
    }

    private static ExtensionFilter createFilter(EnumSet<FileType> fileTypes, boolean acceptDir) {
        CompositeExtensionFilter result = new CompositeExtensionFilter(fileTypes, FileType.getDescription(fileTypes), acceptDir);
        compositeFilterMap.put(fileTypes, result);
        return result;
    }

    public static ExtensionFilter getFilter(FileType fileTypes) {
        return simpleFilterMap.get((Object)fileTypes);
    }

    public static ExtensionFilter getFilter(GraphRole role) {
        switch (role) {
            case HOST: {
                return STATE_FILTER;
            }
            case RULE: {
                return RULE_FILTER;
            }
            case TYPE: {
                return TYPE_FILTER;
            }
            case LTS: {
                return GXL_FILTER;
            }
        }
        return null;
    }

    public static ExtensionFilter getFilter(EnumSet<FileType> fileTypes) {
        return compositeFilterMap.get(fileTypes);
    }
}

