/*
 * Decompiled with CFR 0.152.
 */
package groove.io.conceptual;

import groove.io.conceptual.Name;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;

public class Id
implements Serializable {
    public static final Id ROOT;
    private Id m_namespace;
    private Name m_name;
    private Map<Name, Id> m_subIds = new HashMap<Name, Id>();
    private int m_depth;
    private int m_hashCode = 0;

    static {
        Id.ROOT.m_namespace = ROOT = new Id();
    }

    private Id(Id namespace, Name name) {
        this.m_namespace = namespace;
        this.m_name = name;
        this.m_depth = namespace.m_depth + 1;
    }

    private Id() {
        this.m_name = null;
        this.m_namespace = null;
        this.m_depth = 0;
    }

    public static Id getId(Id namespace, Name name) {
        if (namespace == null || name == null) {
            return null;
        }
        if (namespace.m_subIds.containsKey(name)) {
            return namespace.m_subIds.get(name);
        }
        Id newId = new Id(namespace, name);
        namespace.m_subIds.put(name, newId);
        return newId;
    }

    public String toString() {
        if (this == ROOT) {
            return "";
        }
        return String.valueOf(this.m_namespace == ROOT ? "" : String.valueOf(this.m_namespace.toString()) + ".") + this.m_name.toString();
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof Id)) {
            return false;
        }
        if (this == ROOT || o == ROOT) {
            return this == o;
        }
        Id other = (Id)o;
        return other.m_name.equals(this.m_name) && other.m_namespace.equals(this.m_namespace);
    }

    public Name getName() {
        return this.m_name;
    }

    public Id getNamespace() {
        return this.m_namespace;
    }

    public Id getCommonPart(Id other) {
        Id curThis = this;
        Id curOther = other;
        while (curThis.m_depth > curOther.m_depth) {
            curThis = curThis.getNamespace();
        }
        while (curOther.m_depth > curThis.m_depth) {
            curOther = curOther.getNamespace();
        }
        while (curThis != curOther) {
            curThis = curThis.getNamespace();
            curOther = curOther.getNamespace();
        }
        return curThis;
    }

    public Id removePrefix(Id prefix) {
        Id newId = this;
        Stack<Name> namestack = new Stack<Name>();
        while (newId.m_depth > prefix.m_depth) {
            namestack.push(newId.getName());
            newId = newId.getNamespace();
        }
        boolean isMatch = true;
        while (isMatch && newId.m_depth > 0) {
            isMatch = newId.getName() == prefix.getName();
            newId = newId.getNamespace();
            prefix = prefix.getNamespace();
        }
        if (!isMatch) {
            return this;
        }
        newId = ROOT;
        while (!namestack.isEmpty()) {
            newId = Id.getId(newId, (Name)namestack.pop());
        }
        return newId;
    }

    public int hashCode() {
        if (this.m_hashCode == 0) {
            this.m_hashCode = this.toString().hashCode();
        }
        return this.m_hashCode;
    }

    public static Id getIdFromString(String idString) {
        String[] parts = idString.split("\\.");
        Id resultId = ROOT;
        String[] stringArray = parts;
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            resultId = Id.getId(resultId, Name.getName(part));
            ++n2;
        }
        return resultId;
    }
}

