/*
 * Decompiled with CFR 0.152.
 */
package groove.io.conceptual.lang.graphviz;

import com.alexmerz.graphviz.objects.Graph;
import com.alexmerz.graphviz.objects.Id;
import groove.io.conceptual.Timer;
import groove.io.conceptual.lang.ExportException;
import groove.io.conceptual.lang.ExportableResource;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class GraphvizResource
extends ExportableResource {
    private Map<String, Graph> m_typeGraphs = new HashMap<String, Graph>();
    private Map<String, Graph> m_instanceGraphs = new HashMap<String, Graph>();
    private File m_typeFile;
    private File m_instanceFile;

    public GraphvizResource(File typeTarget, File instanceTarget) {
        this.m_typeFile = typeTarget;
        this.m_instanceFile = instanceTarget;
    }

    public Graph getTypeGraph(String name) {
        if (this.m_typeGraphs.containsKey(name)) {
            return this.m_typeGraphs.get(name);
        }
        Graph g = new Graph();
        g.setId(new Id());
        g.getId().setId("\"" + name + "\"");
        g.setType(2);
        g.addGenericNodeAttribute("shape", "box");
        this.m_typeGraphs.put(name, g);
        return g;
    }

    public Graph getInstanceGraph(String name) {
        if (this.m_instanceGraphs.containsKey(name)) {
            return this.m_instanceGraphs.get(name);
        }
        Graph g = new Graph();
        g.setId(new Id());
        g.getId().setId("\"" + name + "\"");
        g.setType(2);
        g.addGenericNodeAttribute("shape", "box");
        this.m_instanceGraphs.put(name, g);
        return g;
    }

    @Override
    public boolean export() throws ExportException {
        int timer;
        BufferedWriter out;
        for (Map.Entry<String, Graph> entry : this.m_typeGraphs.entrySet()) {
            try {
                out = new BufferedWriter(new FileWriter(this.m_typeFile));
                timer = Timer.start("Save DOT");
                out.write(entry.getValue().toString());
                Timer.stop(timer);
                out.close();
            }
            catch (IOException e) {
                throw new ExportException(e);
            }
        }
        if (this.m_instanceFile != null) {
            for (Map.Entry<String, Graph> entry : this.m_instanceGraphs.entrySet()) {
                try {
                    out = new BufferedWriter(new FileWriter(this.m_instanceFile));
                    timer = Timer.start("Save DOT");
                    out.write(entry.getValue().toString());
                    Timer.stop(timer);
                    out.close();
                }
                catch (IOException e) {
                    throw new ExportException(e);
                }
            }
        }
        return true;
    }
}

