/*
 * Decompiled with CFR 0.152.
 */
package groove.io.conceptual.lang.groove;

import groove.grammar.aspect.AspectGraph;
import groove.grammar.model.ResourceKind;
import groove.graph.GraphRole;
import groove.gui.Simulator;
import groove.gui.SimulatorModel;
import groove.gui.display.DisplayKind;
import groove.gui.jgraph.AspectJGraph;
import groove.gui.jgraph.AspectJModel;
import groove.gui.layout.Layouter;
import groove.io.conceptual.Timer;
import groove.io.conceptual.configuration.Config;
import groove.io.conceptual.graph.AbsGraph;
import groove.io.conceptual.lang.ExportException;
import groove.io.conceptual.lang.ExportableResource;
import groove.io.conceptual.lang.groove.GrammarGraph;
import groove.io.conceptual.lang.groove.GrooveUtil;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jgraph.graph.GraphModel;

public class GrooveResource
extends ExportableResource {
    protected Config m_cfg;
    protected SimulatorModel m_simModel;
    protected Simulator m_sim;
    protected Layouter m_layouter;
    protected String m_namespace;
    protected Map<GraphRole, HashMap<String, GrammarGraph>> m_graphs = new HashMap<GraphRole, HashMap<String, GrammarGraph>>();

    public GrooveResource(Config cfg, SimulatorModel simModel, String namespace) {
        this.m_cfg = cfg;
        this.m_simModel = simModel;
        this.m_namespace = namespace;
        GraphRole[] graphRoleArray = GraphRole.values();
        int n = graphRoleArray.length;
        int n2 = 0;
        while (n2 < n) {
            GraphRole role = graphRoleArray[n2];
            this.m_graphs.put(role, new HashMap());
            ++n2;
        }
    }

    public void setLayouter(Simulator sim, Layouter layouter) {
        this.m_sim = sim;
        this.m_layouter = layouter;
    }

    public void count() {
        int constraintCount = 0;
        for (GraphRole role : this.m_graphs.keySet()) {
            for (GrammarGraph graph : this.m_graphs.get((Object)role).values()) {
                AbsGraph absGraph = graph.getGraph();
                int nodes = absGraph.getNodes().size();
                int edges = absGraph.getEdges().size();
                if (graph.getGraphName().startsWith("constraint") || graph.getGraphName().startsWith("Default")) {
                    ++constraintCount;
                    continue;
                }
                System.out.println("Graph " + graph.getGraphName() + ", nodes: " + nodes + ", edges: " + edges);
            }
        }
        System.out.println("#constraintCount: " + constraintCount);
    }

    public Map<GraphRole, HashMap<String, GrammarGraph>> getGraphs() {
        return this.m_graphs;
    }

    @Override
    public boolean export() throws ExportException {
        int timer = Timer.start("Groove save");
        for (GraphRole role : this.m_graphs.keySet()) {
            for (GrammarGraph graph : this.m_graphs.get((Object)role).values()) {
                AbsGraph absGraph = graph.getGraph();
                String safeName = GrooveUtil.getSafeResource(String.valueOf(this.m_namespace) + "." + graph.getGraphName());
                AspectGraph aspectGraph = absGraph.toAspectGraph(safeName, graph.getGraphRole());
                try {
                    switch (graph.getGraphRole()) {
                        case TYPE: {
                            this.m_simModel.getGrammar().getStore().putGraphs(ResourceKind.TYPE, Collections.singleton(aspectGraph), false);
                            break;
                        }
                        case HOST: {
                            this.m_simModel.getGrammar().getStore().putGraphs(ResourceKind.HOST, Collections.singleton(aspectGraph), false);
                            break;
                        }
                        case RULE: {
                            this.m_simModel.getGrammar().getStore().putGraphs(ResourceKind.RULE, Collections.singleton(aspectGraph), false);
                        }
                    }
                    this.m_simModel.doRefreshGrammar();
                    if (this.m_layouter == null) continue;
                    AspectJGraph jGraph = new AspectJGraph(this.m_sim, DisplayKind.TYPE, false);
                    AspectJModel model = jGraph.newModel();
                    model.loadGraph(aspectGraph);
                    try {
                        jGraph.setModel((GraphModel)model);
                        this.m_layouter.newInstance(jGraph).start();
                    }
                    catch (Exception exception) {}
                }
                catch (IOException e) {
                    throw new ExportException(e);
                }
            }
        }
        Timer.stop(timer);
        return true;
    }

    public void delete() throws ExportException {
        for (GraphRole role : this.m_graphs.keySet()) {
            for (GrammarGraph graph : this.m_graphs.get((Object)role).values()) {
                String safeName = GrooveUtil.getSafeResource(String.valueOf(this.m_namespace) + "." + graph.getGraphName());
                try {
                    switch (graph.getGraphRole()) {
                        case TYPE: {
                            this.m_simModel.doDelete(ResourceKind.TYPE, Collections.singleton(safeName));
                            break;
                        }
                        case HOST: {
                            this.m_simModel.doDelete(ResourceKind.HOST, Collections.singleton(safeName));
                            break;
                        }
                        case RULE: {
                            this.m_simModel.doDelete(ResourceKind.RULE, Collections.singleton(safeName));
                        }
                    }
                }
                catch (IOException e) {
                    throw new ExportException(e);
                }
            }
        }
    }

    public Config getConfig() {
        return this.m_cfg;
    }

    public boolean hasGraph(String name, GraphRole graphRole) {
        return this.m_graphs.get((Object)graphRole).containsKey(name);
    }

    public GrammarGraph getGraph(String name, GraphRole graphRole) {
        if (this.m_graphs.containsKey(name)) {
            GrammarGraph resultGraph = this.m_graphs.get((Object)graphRole).get(name);
            if (resultGraph.getGraphRole() != graphRole) {
                return null;
            }
            return resultGraph;
        }
        GrammarGraph newGraph = new GrammarGraph(name, graphRole);
        this.m_graphs.get((Object)graphRole).put(name, newGraph);
        return newGraph;
    }
}

