/*
 * Decompiled with CFR 0.152.
 */
package groove.io.conceptual.lang.groove;

import groove.grammar.aspect.AspectGraph;
import groove.grammar.model.ResourceKind;
import groove.graph.GraphRole;
import groove.gui.Simulator;
import groove.gui.display.DisplayKind;
import groove.gui.jgraph.AspectJGraph;
import groove.gui.jgraph.AspectJModel;
import groove.io.conceptual.configuration.Config;
import groove.io.conceptual.graph.AbsGraph;
import groove.io.conceptual.lang.ExportException;
import groove.io.conceptual.lang.groove.GrammarGraph;
import groove.io.conceptual.lang.groove.GrooveResource;
import groove.io.conceptual.lang.groove.GrooveUtil;
import groove.util.Pair;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import javax.swing.ProgressMonitor;
import javax.swing.SwingWorker;
import org.jgraph.graph.GraphModel;

public class GrooveResourceThreaded
extends GrooveResource {
    private int progress = 0;

    public GrooveResourceThreaded(Config cfg, Simulator sim, String namespace) {
        super(cfg, sim.getModel(), namespace);
        this.m_sim = sim;
    }

    @Override
    public boolean export() throws ExportException {
        this.worker();
        return false;
    }

    private void worker() {
        int max = 0;
        this.progress = 0;
        for (GraphRole role : this.m_graphs.keySet()) {
            max += ((HashMap)this.m_graphs.get((Object)role)).size();
        }
        ProgressMonitor progressMonitor = new ProgressMonitor(this.m_sim.getFrame(), "Importing graphs", "", 0, max);
        SwingWorker<Boolean, Pair<AspectGraph, ResourceKind>> sw = new SwingWorker<Boolean, Pair<AspectGraph, ResourceKind>>(progressMonitor){
            private ProgressMonitor dlg;
            {
                this.dlg = progressMonitor;
            }

            @Override
            protected Boolean doInBackground() throws Exception {
                for (GraphRole role : GrooveResourceThreaded.this.m_graphs.keySet()) {
                    for (GrammarGraph graph : ((HashMap)GrooveResourceThreaded.this.m_graphs.get((Object)role)).values()) {
                        if (this.dlg.isCanceled() || this.isCancelled()) {
                            return false;
                        }
                        AbsGraph absGraph = graph.getGraph();
                        String safeName = GrooveUtil.getSafeResource(String.valueOf(GrooveResourceThreaded.this.m_namespace) + "." + graph.getGraphName());
                        AspectGraph aspectGraph = absGraph.toAspectGraph(safeName, graph.getGraphRole());
                        ResourceKind kind = null;
                        switch (graph.getGraphRole()) {
                            case TYPE: {
                                kind = ResourceKind.TYPE;
                                break;
                            }
                            case HOST: {
                                kind = ResourceKind.HOST;
                                break;
                            }
                            case RULE: {
                                kind = ResourceKind.RULE;
                            }
                        }
                        this.publish(new Pair<AspectGraph, ResourceKind>(aspectGraph, kind));
                        Thread.sleep(100L);
                    }
                }
                return true;
            }

            @Override
            protected void done() {
                this.dlg.close();
            }

            @Override
            protected void process(List<Pair<AspectGraph, ResourceKind>> chunks) {
                for (Pair<AspectGraph, ResourceKind> chunk : chunks) {
                    this.importGraph(chunk);
                    GrooveResourceThreaded grooveResourceThreaded = GrooveResourceThreaded.this;
                    grooveResourceThreaded.progress = grooveResourceThreaded.progress + 1;
                    int percent = GrooveResourceThreaded.this.progress * 100 / this.dlg.getMaximum();
                    String message = String.format("Graph %d of %d (%d%%).\n", GrooveResourceThreaded.this.progress, this.dlg.getMaximum(), percent);
                    this.dlg.setNote(message);
                    this.dlg.setProgress(GrooveResourceThreaded.this.progress);
                    GrooveResourceThreaded.this.m_sim.getFrame().validate();
                    GrooveResourceThreaded.this.m_sim.getFrame().repaint();
                }
            }

            private void importGraph(Pair<AspectGraph, ResourceKind> chunk) {
                try {
                    GrooveResourceThreaded.this.m_simModel.doAddGraph(chunk.two(), chunk.one(), false);
                    if (GrooveResourceThreaded.this.m_layouter != null) {
                        AspectJGraph jGraph = new AspectJGraph(GrooveResourceThreaded.this.m_sim, DisplayKind.TYPE, false);
                        AspectJModel model = jGraph.newModel();
                        model.loadGraph(chunk.one());
                        try {
                            jGraph.setModel((GraphModel)model);
                            GrooveResourceThreaded.this.m_layouter.newInstance(jGraph).start();
                        }
                        catch (Exception exception) {}
                    }
                }
                catch (IOException iOException) {}
            }
        };
        sw.execute();
    }
}

