/*
 * Decompiled with CFR 0.152.
 */
package groove.io.conceptual.lang.groove;

import groove.algebra.Constant;
import groove.grammar.aspect.AspectNode;
import groove.grammar.aspect.GraphConverter;
import groove.grammar.host.HostEdge;
import groove.grammar.host.HostEdgeSet;
import groove.grammar.host.HostEdgeStore;
import groove.grammar.host.HostGraph;
import groove.grammar.host.HostNode;
import groove.grammar.host.HostNodeSet;
import groove.grammar.host.ValueNode;
import groove.graph.EdgeRole;
import groove.io.conceptual.Field;
import groove.io.conceptual.Id;
import groove.io.conceptual.InstanceModel;
import groove.io.conceptual.Name;
import groove.io.conceptual.Timer;
import groove.io.conceptual.TypeModel;
import groove.io.conceptual.configuration.Config;
import groove.io.conceptual.configuration.schema.EnumModeType;
import groove.io.conceptual.configuration.schema.OrderType;
import groove.io.conceptual.lang.InstanceImporter;
import groove.io.conceptual.lang.Message;
import groove.io.conceptual.lang.groove.GraphNodeTypes;
import groove.io.conceptual.type.Class;
import groove.io.conceptual.type.Container;
import groove.io.conceptual.type.CustomDataType;
import groove.io.conceptual.type.DataType;
import groove.io.conceptual.type.Enum;
import groove.io.conceptual.type.IntType;
import groove.io.conceptual.type.RealType;
import groove.io.conceptual.type.StringType;
import groove.io.conceptual.type.Tuple;
import groove.io.conceptual.type.Type;
import groove.io.conceptual.value.ContainerValue;
import groove.io.conceptual.value.CustomDataValue;
import groove.io.conceptual.value.EnumValue;
import groove.io.conceptual.value.IntValue;
import groove.io.conceptual.value.RealValue;
import groove.io.conceptual.value.StringValue;
import groove.io.conceptual.value.TupleValue;
import groove.io.conceptual.value.Value;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;

public class GrooveToInstance
extends InstanceImporter {
    private GraphNodeTypes m_types;
    private Config m_cfg;
    private TypeModel m_typeModel;
    private Map<HostNode, groove.io.conceptual.value.Object> m_objectNodes = new HashMap<HostNode, groove.io.conceptual.value.Object>();
    private Map<HostNode, Value> m_nodeValues = new HashMap<HostNode, Value>();
    private HostEdgeStore<HostNode> m_nodeEdges = new HostEdgeStore();
    private int m_nodeCounter = 1;

    public GrooveToInstance(HostGraph hostGraph, GraphNodeTypes types, Config cfg, TypeModel typeModel) {
        this.m_types = types;
        this.m_cfg = cfg;
        this.m_typeModel = typeModel;
        int timer = Timer.start("GROOVE to IM");
        this.buildInstanceModel(hostGraph);
        Timer.stop(timer);
    }

    private void buildInstanceModel(HostGraph hostGraph) {
        InstanceModel instanceModel = new InstanceModel(this.m_typeModel, hostGraph.getName());
        this.m_cfg.setTypeModel(this.m_typeModel);
        for (HostNode n : hostGraph.nodeSet()) {
            this.m_nodeEdges.addKey(n);
        }
        for (HostEdge e : hostGraph.edgeSet()) {
            ((HostEdgeSet)this.m_nodeEdges.get(e.source())).add(e);
        }
        HostNodeSet unvisitedNodes = new HostNodeSet(hostGraph.nodeSet());
        GraphConverter.HostToAspectMap map = GraphConverter.toAspectMap(hostGraph);
        for (HostNode hostNode : hostGraph.nodeSet()) {
            AspectNode aspectNode = (AspectNode)map.getNode(hostNode);
            Type t = this.getNodeType(hostNode);
            if (!(t instanceof Class)) continue;
            unvisitedNodes.remove(hostNode);
            groove.io.conceptual.value.Object nodeObj = new groove.io.conceptual.value.Object((Class)t, Name.getName(this.getNodeName(aspectNode)));
            this.m_objectNodes.put(hostNode, nodeObj);
            instanceModel.addObject(nodeObj);
        }
        for (Map.Entry entry : this.m_objectNodes.entrySet()) {
            for (Field field : ((Class)((groove.io.conceptual.value.Object)entry.getValue()).getType()).getAllFields()) {
                String fieldName = field.getName().toString();
                Value fieldValue = null;
                fieldValue = field.getType() instanceof Container ? (!this.m_cfg.useIntermediate(field) ? this.getFieldContainerValue((HostNode)entry.getKey(), fieldName, (Container)field.getType()) : this.getContainerValue((HostNode)entry.getKey(), fieldName)) : this.getNodeValue(this.getEdgeNode((HostNode)entry.getKey(), fieldName));
                if (fieldValue != null) {
                    ((groove.io.conceptual.value.Object)entry.getValue()).setFieldValue(field, fieldValue);
                    continue;
                }
                this.addMessage(new Message("Cannot obtain value for field " + field.getName(), Message.MessageType.WARNING));
            }
        }
        this.addInstanceModel(instanceModel);
    }

    private Type getNodeType(HostNode node) {
        String label = node.getType().label().text();
        return this.m_types.getType(label);
    }

    private String getNodeName(AspectNode node) {
        if (this.m_cfg.getConfig().getInstanceModel().getObjects().isUseIdentifier() && node.getId() != null) {
            return node.getId().getContentString();
        }
        return "node" + this.m_nodeCounter++;
    }

    private int getNodeIndex(HostNode node) {
        OrderType orderType = this.m_cfg.getConfig().getTypeModel().getFields().getContainers().getOrdering().getType();
        if (orderType == OrderType.INDEX) {
            String indexName = this.m_cfg.getStrings().getIndexEdge();
            HostNode indexNode = this.getEdgeNode(node, indexName);
            if (indexNode == null) {
                return Integer.MIN_VALUE;
            }
            ValueNode valNode = (ValueNode)indexNode;
            Constant c = (Constant)valNode.getValue();
            Integer value = Integer.parseInt(c.getSymbol());
            return value;
        }
        if (orderType == OrderType.EDGE) {
            String nextName = this.m_cfg.getStrings().getNextEdge();
            HostNode nextNode = this.getEdgeNode(node, nextName);
            if (nextNode == null) {
                return Integer.MAX_VALUE;
            }
            return this.getNodeIndex(nextNode) - 1;
        }
        return Integer.MIN_VALUE;
    }

    private Value getNodeValue(HostNode node) {
        if (this.m_types.getModelType(node.getType().label().text()) == GraphNodeTypes.ModelType.TypeIntermediate) {
            String valueEdge = this.m_cfg.getStrings().getValueEdge();
            Value resultValue = this.getNodeValue(this.getEdgeNode(node, valueEdge));
            this.m_nodeValues.put(node, resultValue);
            return resultValue;
        }
        Type nodeType = this.getNodeType(node);
        if (nodeType == null) {
            return null;
        }
        Value resultValue = null;
        if (nodeType instanceof Class) {
            resultValue = this.m_objectNodes.get(node);
        } else if (nodeType instanceof Enum) {
            Enum e = (Enum)nodeType;
            if (this.m_cfg.getConfig().getTypeModel().getEnumMode() == EnumModeType.NODE) {
                Id id = this.m_cfg.nameToId(node.getType().label().text());
                EnumValue ev = new EnumValue(e, id.getName());
                resultValue = ev;
            } else {
                HostEdgeSet edges = (HostEdgeSet)this.m_nodeEdges.get(node);
                for (HostEdge enumEdge : edges) {
                    if (enumEdge.getType().getRole() != EdgeRole.FLAG) continue;
                    EnumValue ev = new EnumValue(e, Name.getName(enumEdge.label().text()));
                    resultValue = ev;
                    break;
                }
            }
        } else if (nodeType instanceof CustomDataType) {
            CustomDataType cdt = (CustomDataType)nodeType;
            String dataValueName = this.m_cfg.getStrings().getDataValue();
            HostNode valueNode = this.getEdgeNode(node, dataValueName);
            String valueString = ((ValueNode)valueNode).getValue().toString();
            CustomDataValue dv = new CustomDataValue(cdt, valueString);
            resultValue = dv;
        } else if (nodeType instanceof Container) {
            Container ct = (Container)nodeType;
            ContainerValue cv = new ContainerValue(ct);
            String valueEdge = this.m_cfg.getStrings().getValueEdge();
            TreeMap<Integer, Value> containerValues = new TreeMap<Integer, Value>();
            for (HostEdge e : (HostEdgeSet)this.m_nodeEdges.get(node)) {
                if (!e.label().text().equals(valueEdge)) continue;
                Value subVal = this.getNodeValue(e.target());
                int index = 0;
                if (ct.getContainerType() == Container.Kind.ORD || ct.getContainerType() == Container.Kind.SEQ) {
                    index = this.getNodeIndex(e.target());
                }
                containerValues.put(index, subVal);
            }
            for (Value subVal : containerValues.values()) {
                cv.addValue(subVal);
            }
            resultValue = cv;
        } else if (nodeType instanceof Tuple) {
            Tuple tup = (Tuple)nodeType;
            TupleValue tv = new TupleValue(tup);
            int i = 0;
            while (i < tup.getTypes().size()) {
                Value subVal;
                HostNode subValNode = this.getEdgeNode(node, "_" + (i + 1));
                if (this.getNodeType(subValNode) instanceof Container) {
                    subVal = this.getContainerValue(node, "_" + (i + 1));
                    tv.setValue(i + 1, subVal);
                } else {
                    subVal = this.getNodeValue(subValNode);
                    tv.setValue(i + 1, subVal);
                }
                ++i;
            }
            resultValue = tv;
        } else if (nodeType instanceof DataType) {
            ValueNode valNode = (ValueNode)node;
            Constant c = (Constant)valNode.getValue();
            resultValue = ((DataType)nodeType).valueFromString(c.getSymbol());
        } else if (nodeType instanceof IntType) {
            ValueNode valNode = (ValueNode)node;
            Constant c = (Constant)valNode.getValue();
            Integer value = Integer.parseInt(c.getSymbol());
            resultValue = new IntValue(value);
        } else if (nodeType instanceof RealType) {
            ValueNode valNode = (ValueNode)node;
            Constant c = (Constant)valNode.getValue();
            Float value = Float.valueOf(Float.parseFloat(c.getSymbol()));
            resultValue = new RealValue(value.floatValue());
        } else if (nodeType instanceof StringType) {
            ValueNode valNode = (ValueNode)node;
            Constant c = (Constant)valNode.getValue();
            String value = c.getSymbol();
            resultValue = new StringValue(value.substring(1, value.length() - 1));
        }
        this.m_nodeValues.put(node, resultValue);
        return resultValue;
    }

    private HostNode getEdgeNode(HostNode node, String edge) {
        HostEdgeSet nodeEdges = (HostEdgeSet)this.m_nodeEdges.get(node);
        for (HostEdge e : nodeEdges) {
            if (!e.label().text().equals(edge)) continue;
            return e.target();
        }
        return null;
    }

    private ContainerValue getFieldContainerValue(HostNode fieldNode, String fieldName, Container containerType) {
        HashSet<HostEdge> nodeEdges = new HashSet<HostEdge>();
        for (HostEdge e : (HostEdgeSet)this.m_nodeEdges.get(fieldNode)) {
            if (!e.label().text().equals(fieldName)) continue;
            nodeEdges.add(e);
        }
        if (nodeEdges.size() == 0) {
            return null;
        }
        TreeMap<Integer, Value> containerValues = new TreeMap<Integer, Value>();
        for (HostEdge e : nodeEdges) {
            Value subVal = this.getNodeValue(e.target());
            int index = 0;
            if (containerType.getContainerType() == Container.Kind.ORD || containerType.getContainerType() == Container.Kind.SEQ) {
                index = this.getNodeIndex(e.target());
            }
            containerValues.put(index, subVal);
        }
        ContainerValue cv = new ContainerValue(containerType);
        for (Value subVal : containerValues.values()) {
            cv.addValue(subVal);
        }
        return cv;
    }

    private Value getContainerValue(HostNode node, String edgeName) {
        HashSet<HostEdge> nodeEdges = new HashSet<HostEdge>();
        for (HostEdge e : (HostEdgeSet)this.m_nodeEdges.get(node)) {
            if (!e.label().text().equals(edgeName)) continue;
            nodeEdges.add(e);
        }
        if (nodeEdges.size() == 0) {
            return null;
        }
        Type nextType = this.getNodeType(((HostEdge)nodeEdges.iterator().next()).target());
        if (!(nextType instanceof Container)) {
            if (nodeEdges.size() == 1) {
                return this.getNodeValue(((HostEdge)nodeEdges.iterator().next()).target());
            }
            nextType = new Container(Container.Kind.SET, nextType);
        }
        ContainerValue cv = new ContainerValue((Container)nextType);
        String valueName = this.m_cfg.getStrings().getValueEdge();
        TreeMap<Integer, Value> containerValues = new TreeMap<Integer, Value>();
        for (HostEdge e : nodeEdges) {
            Type checkType = this.getNodeType(e.target());
            if (!nextType.equals(checkType)) {
                this.addMessage(new Message("Invalid container value, type " + nextType + " does not correspond with type " + checkType));
                return null;
            }
            Value subVal = this.getContainerValue(e.target(), valueName);
            int index = 0;
            if (((Container)nextType).getContainerType() == Container.Kind.ORD || ((Container)nextType).getContainerType() == Container.Kind.SEQ) {
                index = this.getNodeIndex(e.target());
            }
            containerValues.put(index, subVal);
        }
        for (Value subVal : containerValues.values()) {
            cv.addValue(subVal);
        }
        return cv;
    }
}

