/*
 * Decompiled with CFR 0.152.
 */
package groove.io.conceptual.lang.groove;

import groove.graph.GraphRole;
import groove.io.conceptual.Acceptor;
import groove.io.conceptual.Field;
import groove.io.conceptual.TypeModel;
import groove.io.conceptual.configuration.Config;
import groove.io.conceptual.configuration.schema.NullableType;
import groove.io.conceptual.graph.AbsEdge;
import groove.io.conceptual.graph.AbsNode;
import groove.io.conceptual.lang.ExportableResource;
import groove.io.conceptual.lang.TypeExporter;
import groove.io.conceptual.lang.groove.GrammarGraph;
import groove.io.conceptual.lang.groove.GrooveResource;
import groove.io.conceptual.lang.groove.GrooveUtil;
import groove.io.conceptual.type.Class;
import groove.io.conceptual.type.Container;
import groove.io.conceptual.type.CustomDataType;
import groove.io.conceptual.type.DataType;
import groove.io.conceptual.type.Enum;
import groove.io.conceptual.type.Tuple;
import groove.io.external.PortException;
import java.util.HashMap;
import java.util.Map;

public class MetaToGroove
extends TypeExporter<AbsNode> {
    private GrooveResource m_grooveResource;
    private Config m_cfg;
    private GrammarGraph m_currentGraph;
    private Map<MetaType, AbsNode> m_metaNodes = new HashMap<MetaType, AbsNode>();

    public MetaToGroove(GrooveResource grooveResource) {
        this.m_grooveResource = grooveResource;
        this.m_cfg = this.m_grooveResource.getConfig();
    }

    @Override
    public void addTypeModel(TypeModel typeModel) throws PortException {
        if (this.m_cfg.getConfig().getTypeModel().isMetaSchema()) {
            this.m_currentGraph = this.m_grooveResource.getGraph(String.valueOf(GrooveUtil.getSafeId(typeModel.getName())) + "_meta", GraphRole.TYPE);
            this.setupMetaModel();
            this.visitTypeModel(typeModel, this.m_cfg);
        }
    }

    @Override
    public ExportableResource getResource() {
        return this.m_grooveResource;
    }

    @Override
    protected void setElement(Acceptor o, AbsNode n) {
        super.setElement(o, n);
        if (n != null) {
            this.m_currentGraph.m_nodes.put(o, n);
        }
    }

    private AbsNode getMetaNode(MetaType type) {
        if (this.m_metaNodes.containsKey((Object)type)) {
            return this.m_metaNodes.get((Object)type);
        }
        String name = "";
        switch (type) {
            case Type: {
                name = this.m_cfg.getStrings().getMetaType();
                break;
            }
            case Class: {
                name = this.m_cfg.getStrings().getMetaClass();
                break;
            }
            case ClassNullable: {
                name = this.m_cfg.getStrings().getMetaClassNullable();
                break;
            }
            case Enum: {
                name = this.m_cfg.getStrings().getMetaEnum();
                break;
            }
            case DataType: {
                name = this.m_cfg.getStrings().getMetaDataType();
                break;
            }
            case Tuple: {
                name = this.m_cfg.getStrings().getMetaTuple();
                break;
            }
            case ContainerSet: {
                name = this.m_cfg.getStrings().getMetaContainerSet();
                break;
            }
            case ContainerBag: {
                name = this.m_cfg.getStrings().getMetaContainerBag();
                break;
            }
            case ContainerSeq: {
                name = this.m_cfg.getStrings().getMetaContainerSeq();
                break;
            }
            case ContainerOrd: {
                name = this.m_cfg.getStrings().getMetaContainerOrd();
                break;
            }
            case Intermediate: {
                name = this.m_cfg.getStrings().getMetaIntermediate();
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        AbsNode metaNode = new AbsNode("type:" + name);
        this.m_metaNodes.put(type, metaNode);
        return metaNode;
    }

    private void setupMetaModel() {
        AbsNode typeNode = this.getMetaNode(MetaType.Type);
        AbsNode classNode = this.getMetaNode(MetaType.Class);
        AbsNode classNullableNode = this.getMetaNode(MetaType.ClassNullable);
        AbsNode enumNode = this.getMetaNode(MetaType.Enum);
        AbsNode dataNode = this.getMetaNode(MetaType.DataType);
        AbsNode tupleNode = this.getMetaNode(MetaType.Tuple);
        AbsNode intermediateNode = this.getMetaNode(MetaType.Intermediate);
        AbsNode containerNodeSet = this.getMetaNode(MetaType.ContainerSet);
        AbsNode containerNodeBag = this.getMetaNode(MetaType.ContainerBag);
        AbsNode containerNodeSeq = this.getMetaNode(MetaType.ContainerSeq);
        AbsNode containerNodeOrd = this.getMetaNode(MetaType.ContainerOrd);
        new AbsEdge(classNode, typeNode, "sub:");
        new AbsEdge(classNullableNode, typeNode, "sub:");
        new AbsEdge(enumNode, typeNode, "sub:");
        new AbsEdge(dataNode, typeNode, "sub:");
        new AbsEdge(tupleNode, typeNode, "sub:");
        new AbsEdge(intermediateNode, typeNode, "sub:");
        new AbsEdge(containerNodeSet, intermediateNode, "sub:");
        new AbsEdge(containerNodeBag, intermediateNode, "sub:");
        new AbsEdge(containerNodeSeq, intermediateNode, "sub:");
        new AbsEdge(containerNodeOrd, intermediateNode, "sub:");
    }

    @Override
    public void visit(Class c, Object param) {
        if (this.hasElement(c)) {
            return;
        }
        if (this.m_cfg.getConfig().getGlobal().getNullable() == NullableType.NONE && !c.isProper()) {
            AbsNode classNode = (AbsNode)this.getElement(c.getProperClass());
            if (!this.hasElement(c)) {
                this.setElement((Acceptor)c, classNode);
            }
            return;
        }
        AbsNode classNode = new AbsNode(this.m_cfg.getName(c));
        this.setElement((Acceptor)c, classNode);
        AbsNode classMetaNode = this.getMetaNode(c.isProper() ? MetaType.Class : MetaType.ClassNullable);
        new AbsEdge(classNode, classMetaNode, "sub:");
        for (Field f : c.getFields()) {
            this.getElement(f, null, true);
        }
        if (c.isProper()) {
            if (this.m_cfg.getConfig().getGlobal().getNullable() == NullableType.ALL) {
                this.getElement(c.getNullableClass());
            }
        } else {
            this.getElement(c.getProperClass());
        }
    }

    @Override
    public void visit(Field field, Object param) {
        if (this.hasElement(field)) {
            return;
        }
        if (!(field.getType() instanceof DataType) || field.getType() instanceof CustomDataType) {
            AbsNode fieldTypeNode = (AbsNode)this.getElement(field.getType(), this.m_cfg.getName(field));
            if (fieldTypeNode == null) {
                assert (field.getType() instanceof Container);
                return;
            }
            if (this.m_cfg.useIntermediate(field) && !(field.getType() instanceof Container)) {
                AbsNode interNode = new AbsNode(this.m_cfg.getName(field));
                this.setElement((Acceptor)field, interNode);
                AbsNode fieldMetaNode = this.getMetaNode(MetaType.Intermediate);
                new AbsEdge(interNode, fieldMetaNode, "sub:");
            } else {
                this.setElement((Acceptor)field, fieldTypeNode);
            }
        }
    }

    @Override
    public void visit(DataType dt, Object param) {
        if (this.hasElement(dt)) {
            return;
        }
        if (dt instanceof CustomDataType) {
            AbsNode dataNode = new AbsNode(this.m_cfg.getName(dt));
            this.setElement((Acceptor)dt, dataNode);
            AbsNode dataMetaNode = this.getMetaNode(MetaType.DataType);
            new AbsEdge(dataNode, dataMetaNode, "sub:");
        }
    }

    @Override
    public void visit(Enum e, Object param) {
        if (this.hasElement(e)) {
            return;
        }
        AbsNode enumNode = new AbsNode(this.m_cfg.getName(e), "abs:");
        this.setElement((Acceptor)e, enumNode);
        AbsNode enumMetaNode = this.getMetaNode(MetaType.Enum);
        new AbsEdge(enumNode, enumMetaNode, "sub:");
    }

    @Override
    public void visit(Container c, Object param) {
        if (this.hasElement(c)) {
            return;
        }
        if (param == null || !(param instanceof String)) {
            throw new IllegalArgumentException("Container visitor requires String argument");
        }
        String containerId = (String)param;
        if (c.getType() instanceof Container) {
            this.getElement(c.getType(), this.m_cfg.getContainerName(containerId, (Container)c.getType()));
        }
        if (!this.m_cfg.useIntermediate(c)) {
            this.setElement((Acceptor)c, null);
            return;
        }
        AbsNode containerNode = new AbsNode(String.valueOf(containerId) + this.m_cfg.getContainerPostfix(c));
        this.setElement((Acceptor)c, containerNode);
        AbsNode orderedNode = null;
        switch (c.getContainerType()) {
            case SET: {
                orderedNode = this.getMetaNode(MetaType.ContainerSet);
                break;
            }
            case BAG: {
                orderedNode = this.getMetaNode(MetaType.ContainerBag);
                break;
            }
            case SEQ: {
                orderedNode = this.getMetaNode(MetaType.ContainerSeq);
                break;
            }
            case ORD: {
                orderedNode = this.getMetaNode(MetaType.ContainerOrd);
            }
        }
        new AbsEdge(containerNode, orderedNode, "sub:");
    }

    @Override
    public void visit(Tuple tuple, Object param) {
        if (this.hasElement(tuple)) {
            return;
        }
        AbsNode tupleNode = new AbsNode(this.m_cfg.getName(tuple));
        this.setElement((Acceptor)tuple, tupleNode);
        AbsNode tupleMetaNode = this.getMetaNode(MetaType.Tuple);
        new AbsEdge(tupleNode, tupleMetaNode, "sub:");
    }

    private static enum MetaType {
        Class,
        ClassNullable,
        Enum,
        Intermediate,
        Type,
        ContainerSet,
        ContainerBag,
        ContainerSeq,
        ContainerOrd,
        DataType,
        Tuple;

    }
}

