/*
 * Decompiled with CFR 0.152.
 */
package groove.io.conceptual.lang.gxl;

import de.gupro.gxl.gxl_1_0.AttrType;
import de.gupro.gxl.gxl_1_0.EdgeType;
import de.gupro.gxl.gxl_1_0.GraphType;
import de.gupro.gxl.gxl_1_0.GxlType;
import de.gupro.gxl.gxl_1_0.NodeType;
import de.gupro.gxl.gxl_1_0.TypedElementType;
import groove.io.conceptual.Field;
import groove.io.conceptual.Id;
import groove.io.conceptual.InstanceModel;
import groove.io.conceptual.Name;
import groove.io.conceptual.Timer;
import groove.io.conceptual.TypeModel;
import groove.io.conceptual.lang.ImportException;
import groove.io.conceptual.lang.InstanceImporter;
import groove.io.conceptual.lang.gxl.GxlToType;
import groove.io.conceptual.lang.gxl.GxlUtil;
import groove.io.conceptual.type.Class;
import groove.io.conceptual.type.Container;
import groove.io.conceptual.value.ContainerValue;
import groove.io.conceptual.value.Value;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;

public class GxlToInstance
extends InstanceImporter {
    private Map<String, GraphType> m_instanceGraphs = new HashMap<String, GraphType>();
    private GxlToType m_gxlToType;
    private Map<NodeType, groove.io.conceptual.value.Object> m_nodeValues = new HashMap<NodeType, groove.io.conceptual.value.Object>();
    private Map<EdgeType, groove.io.conceptual.value.Object> m_edgeValues = new HashMap<EdgeType, groove.io.conceptual.value.Object>();

    public GxlToInstance(GxlToType gxlToType, String instanceModel) throws ImportException {
        this.m_gxlToType = gxlToType;
        try {
            FileInputStream in = new FileInputStream(instanceModel);
            try {
                int timer = Timer.cont("Load GXL");
                JAXBElement doc = (JAXBElement)GxlUtil.g_unmarshaller.unmarshal((InputStream)in);
                in.close();
                for (GraphType g : ((GxlType)doc.getValue()).getGraph()) {
                    String type = GxlUtil.getElemType((TypedElementType)g);
                    if ("gxl-1.0".equals(type)) continue;
                    this.m_instanceGraphs.put(g.getId(), g);
                }
                Timer.stop(timer);
            }
            finally {
                in.close();
            }
        }
        catch (JAXBException e) {
            throw new ImportException(e);
        }
        catch (FileNotFoundException e) {
            throw new ImportException(e);
        }
        catch (IOException e) {
            throw new ImportException(e);
        }
        int timer = Timer.start("GXL to IM");
        for (String model : this.m_instanceGraphs.keySet()) {
            this.getInstanceModel(model);
        }
        Timer.stop(timer);
    }

    @Override
    public InstanceModel getInstanceModel(String modelName) {
        InstanceModel result = super.getInstanceModel(modelName);
        if (result != null) {
            return result;
        }
        if (this.m_instanceGraphs.containsKey(modelName)) {
            String type = GxlUtil.getElemType((TypedElementType)this.m_instanceGraphs.get(modelName));
            TypeModel mm = this.m_gxlToType.getTypeModel(type);
            if (mm == null) {
                return null;
            }
            InstanceModel m = new InstanceModel(mm, modelName);
            this.visitGraph(m, this.m_instanceGraphs.get(modelName));
            this.addInstanceModel(m);
            return m;
        }
        return null;
    }

    private void visitGraph(InstanceModel m, GraphType graph) {
        Map<NodeType, GxlUtil.NodeWrapper> nodes = GxlUtil.wrapGraph(graph);
        String type = GxlUtil.getElemType((TypedElementType)graph);
        Id graphId = this.m_gxlToType.getGraphId(type);
        for (Map.Entry<NodeType, GxlUtil.NodeWrapper> entry : nodes.entrySet()) {
            GxlUtil.NodeWrapper node = entry.getValue();
            if (node.getNode().getGraph().isEmpty()) {
                groove.io.conceptual.value.Object cmObject = this.visitObject(m, node, graphId);
                m.addObject(cmObject);
                continue;
            }
            for (GraphType subGraph : node.getNode().getGraph()) {
                this.visitGraph(m, subGraph);
            }
        }
    }

    private groove.io.conceptual.value.Object visitObject(InstanceModel m, GxlUtil.NodeWrapper nodeWrapper, Id graphId) {
        NodeType node = nodeWrapper.getNode();
        if (this.m_nodeValues.containsKey(node)) {
            groove.io.conceptual.value.Object val = this.m_nodeValues.get(node);
            return val;
        }
        String type = GxlUtil.getElemType((TypedElementType)node);
        Name name = Name.getName(node.getId());
        Class cmClass = (Class)this.m_gxlToType.getIdType(type);
        if (cmClass == null) {
            return null;
        }
        groove.io.conceptual.value.Object o = new groove.io.conceptual.value.Object(cmClass, name);
        this.m_nodeValues.put(node, o);
        List attrs = node.getAttr();
        for (AttrType attr : attrs) {
            String attrName = attr.getName();
            Field f = cmClass.getFieldSuper(Name.getName(attrName));
            assert (f != null);
            Value v = GxlUtil.getTypedAttrValue(attr, f.getType());
            assert (v != null);
            o.setFieldValue(f, v);
        }
        HashMap<String, Value> currentValues = new HashMap<String, Value>();
        nodeWrapper.sortEdges();
        for (GxlUtil.EdgeWrapper ew : nodeWrapper.getEdges()) {
            String edgeType = GxlUtil.getElemType((TypedElementType)ew.getEdge());
            if (this.m_gxlToType.isComplex(edgeType)) {
                this.visitEdge(m, ew, graphId);
                continue;
            }
            groove.io.conceptual.value.Object oTarget = this.visitObject(m, ew.getTarget(), graphId);
            String refName = GxlUtil.getElemType((TypedElementType)ew.getEdge());
            Field f = this.m_gxlToType.getIdField(refName);
            assert (f != null);
            Value v = null;
            if (currentValues.containsKey(refName)) {
                v = (Value)currentValues.get(refName);
            } else {
                v = f.getType() instanceof Container ? new ContainerValue((Container)f.getType()) : oTarget;
                currentValues.put(refName, v);
            }
            if (f.getType() instanceof Container) {
                ContainerValue cv = (ContainerValue)v;
                cv.addValue(oTarget);
            }
            o.setFieldValue(f, v);
        }
        return o;
    }

    private groove.io.conceptual.value.Object visitEdge(InstanceModel m, GxlUtil.EdgeWrapper edgeWrapper, Id graphId) {
        ContainerValue cv;
        EdgeType edge = edgeWrapper.getEdge();
        if (this.m_edgeValues.containsKey(edge)) {
            groove.io.conceptual.value.Object val = this.m_edgeValues.get(edge);
            return val;
        }
        String type = GxlUtil.getElemType((TypedElementType)edge);
        Name name = Name.getName(edge.getId());
        Class cmClass = (Class)this.m_gxlToType.getIdType(type);
        groove.io.conceptual.value.Object o = new groove.io.conceptual.value.Object(cmClass, name);
        groove.io.conceptual.value.Object oSource = null;
        groove.io.conceptual.value.Object oTarget = null;
        if (edgeWrapper.connectsNodes()) {
            oSource = this.visitObject(m, edgeWrapper.getSource(), graphId);
            oTarget = this.visitObject(m, edgeWrapper.getTarget(), graphId);
        } else {
            oSource = this.visitEdge(m, edgeWrapper.getSourceEdge(), graphId);
            oTarget = this.visitEdge(m, edgeWrapper.getTargetEdge(), graphId);
        }
        Field fieldFrom = cmClass.getField(Name.getName("from"));
        Field fieldTo = cmClass.getField(Name.getName("to"));
        assert (fieldFrom != null && fieldTo != null);
        if (fieldFrom.getType() instanceof Container) {
            cv = new ContainerValue((Container)fieldFrom.getType());
            o.setFieldValue(fieldFrom, cv);
            cv.addValue(oSource);
        } else {
            o.setFieldValue(fieldFrom, oSource);
        }
        if (fieldTo.getType() instanceof Container) {
            cv = new ContainerValue((Container)fieldTo.getType());
            o.setFieldValue(fieldTo, cv);
            cv.addValue(oTarget);
        } else {
            o.setFieldValue(fieldTo, oTarget);
        }
        List attrs = edge.getAttr();
        for (AttrType attr : attrs) {
            String attrName = attr.getName();
            Field f = cmClass.getFieldSuper(Name.getName(attrName));
            assert (f != null);
            Value v = GxlUtil.getTypedAttrValue(attr, f.getType());
            assert (v != null);
            o.setFieldValue(f, v);
        }
        for (GxlUtil.EdgeWrapper ew : edgeWrapper.getEdges()) {
            this.visitEdge(m, ew, graphId);
        }
        m.addObject(o);
        this.m_edgeValues.put(edge, o);
        return o;
    }
}

