/*
 * Decompiled with CFR 0.152.
 */
package groove.io.conceptual.type;

import groove.io.conceptual.Field;
import groove.io.conceptual.Id;
import groove.io.conceptual.Identifiable;
import groove.io.conceptual.Name;
import groove.io.conceptual.Visitor;
import groove.io.conceptual.type.Type;
import groove.io.conceptual.value.Object;
import groove.io.conceptual.value.Value;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class Class
extends Type
implements Identifiable {
    private Id m_id;
    private Map<Name, Field> m_fields = new HashMap<Name, Field>();
    private List<Class> m_superClasses = new ArrayList<Class>();
    private boolean m_proper;
    private Class m_nullableClass;
    private Class m_properClass;

    private Class(Id name, Class proper) {
        this.m_id = name;
        this.m_proper = false;
        this.m_nullableClass = this;
        this.m_properClass = proper;
    }

    public Class(Id name) {
        this.m_id = name;
        this.m_proper = true;
        this.m_properClass = this;
        this.m_nullableClass = new Class(name, this);
    }

    @Override
    public boolean isComplex() {
        return false;
    }

    @Override
    public String typeString() {
        return "Class";
    }

    @Override
    public String toString() {
        if (this.m_proper) {
            return String.valueOf(this.m_id.toString()) + "<Proper>";
        }
        return String.valueOf(this.m_id.toString()) + "<Nullable>";
    }

    public void addSuperClass(Class c) {
        if (!this.m_proper) {
            this.m_properClass.addSuperClass(c);
            return;
        }
        assert (c.isProper());
        if (c == this) {
            return;
        }
        if (!this.m_superClasses.contains(c)) {
            this.m_superClasses.add(c);
        }
    }

    public Field addField(Field f) {
        if (!this.m_proper) {
            return this.m_properClass.addField(f);
        }
        if (!this.m_fields.containsKey(f.getName())) {
            this.m_fields.put(f.getName(), f);
            f.setDefiningClass(this);
        }
        return f;
    }

    public Field getField(Name name) {
        if (!this.m_proper) {
            return this.m_properClass.getField(name);
        }
        if (this.m_fields.containsKey(name)) {
            return this.m_fields.get(name);
        }
        return null;
    }

    public Field getFieldSuper(Name name) {
        if (!this.m_proper) {
            return this.m_properClass.getFieldSuper(name);
        }
        if (this.m_fields.containsKey(name)) {
            return this.m_fields.get(name);
        }
        for (Class c : this.m_superClasses) {
            Field f = c.getFieldSuper(name);
            if (f == null) continue;
            return f;
        }
        return null;
    }

    public Collection<Field> getFields() {
        if (!this.m_proper) {
            return this.m_properClass.getFields();
        }
        return this.m_fields.values();
    }

    public Collection<Field> getAllFields() {
        if (!this.m_proper) {
            return this.m_properClass.getAllFields();
        }
        HashSet<Field> fields = new HashSet<Field>(this.m_fields.values());
        for (Class sup : this.m_superClasses) {
            fields.addAll(sup.getAllFields());
        }
        return fields;
    }

    public Collection<Class> getSuperClasses() {
        if (!this.m_proper) {
            return this.m_properClass.getSuperClasses();
        }
        return this.m_superClasses;
    }

    public Collection<Class> getAllSuperClasses() {
        if (!this.m_proper) {
            return this.m_properClass.getAllSuperClasses();
        }
        HashSet<Class> superClasses = new HashSet<Class>(this.m_superClasses);
        superClasses.add(this);
        for (Class sup : this.m_superClasses) {
            superClasses.addAll(sup.getAllSuperClasses());
        }
        return superClasses;
    }

    @Override
    public Id getId() {
        return this.m_id;
    }

    @Override
    public boolean doVisit(Visitor v, java.lang.Object param) {
        v.visit(this, param);
        return true;
    }

    public Class getProperClass() {
        return this.m_properClass;
    }

    public Class getNullableClass() {
        return this.m_nullableClass;
    }

    public boolean isProper() {
        return this.m_proper;
    }

    @Override
    public boolean acceptValue(Value v) {
        if (v == null) {
            return !this.m_proper;
        }
        if (!(v instanceof Object)) {
            return false;
        }
        Class objClass = (Class)v.getType();
        return objClass.getAllSuperClasses().contains(this.getProperClass());
    }
}

