/*
 * Decompiled with CFR 0.152.
 */
package groove.io.conceptual.value;

import groove.io.conceptual.Field;
import groove.io.conceptual.Name;
import groove.io.conceptual.Visitor;
import groove.io.conceptual.type.Class;
import groove.io.conceptual.type.Container;
import groove.io.conceptual.value.ContainerValue;
import groove.io.conceptual.value.Value;
import java.util.HashMap;
import java.util.Map;

public class Object
extends Value {
    private Name m_name;
    private Map<Field, Value> m_fieldValues = new HashMap<Field, Value>();
    public static final Object NIL = new Object(Name.getName("Nil"));

    private Object(Name name) {
        super(null);
        this.m_name = name;
    }

    public Object(Class type, Name name) {
        super(type);
        this.m_name = name;
        for (Field f : type.getFields()) {
            Value v = null;
            if (f.getType() instanceof Container) {
                v = new ContainerValue((Container)f.getType());
            } else if (f.getType() instanceof Class) {
                v = NIL;
            }
            if (v == null) continue;
            this.m_fieldValues.put(f, v);
        }
    }

    public void setFieldValue(Field field, Value fieldValue) {
        if (field.getType() instanceof Container && ((Container)field.getType()).getContainerType() == Container.Kind.SET && !(fieldValue instanceof ContainerValue)) {
            ContainerValue cv = new ContainerValue((Container)field.getType());
            cv.addValue(fieldValue);
            fieldValue = cv;
        }
        assert (field.getType().acceptValue(fieldValue));
        this.m_fieldValues.put(field, fieldValue);
    }

    public String getName() {
        if (this.m_name == null) {
            return null;
        }
        return this.m_name.toString();
    }

    public String toString() {
        String result = String.valueOf(this.toShortString()) + "\n";
        for (Map.Entry<Field, Value> fieldEntry : this.m_fieldValues.entrySet()) {
            String valString = "null";
            if (fieldEntry.getValue() instanceof Object) {
                valString = ((Object)fieldEntry.getValue()).toShortString();
            } else if (fieldEntry.getValue() != null) {
                valString = fieldEntry.getValue().toString();
            }
            result = String.valueOf(result) + fieldEntry.getKey() + ": " + valString + "\n";
        }
        return result;
    }

    public String toShortString() {
        return String.valueOf(this.getName()) + "(" + this.getType() + ")";
    }

    @Override
    public boolean doVisit(Visitor v, java.lang.Object param) {
        v.visit(this, param);
        return true;
    }

    @Override
    public Map<Field, Value> getValue() {
        return this.m_fieldValues;
    }
}

