/*
 * Decompiled with CFR 0.152.
 */
package groove.io.ecore2groove;

import groove.graph.EdgeRole;
import groove.graph.GraphRole;
import groove.graph.plain.PlainGraph;
import groove.graph.plain.PlainLabel;
import groove.graph.plain.PlainNode;
import groove.io.ecore2groove.GraphLabels;
import groove.io.ecore2groove.ModelHandler;
import groove.io.ecore2groove.Triple;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.Vector;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;

public class InstanceGraphRep {
    private final ModelHandler mh;
    private final PlainGraph ig;
    private Map<EObject, PlainNode> iClassToNodeMap = new HashMap<EObject, PlainNode>();
    private Map<Triple<EObject, EStructuralFeature, EObject>, Stack<PlainNode>> iReferenceToNodeMap = new HashMap<Triple<EObject, EStructuralFeature, EObject>, Stack<PlainNode>>();
    private Set<EObject> iClassReferencesDone = new HashSet<EObject>();

    public InstanceGraphRep(String name, ModelHandler m) {
        this.mh = m;
        this.ig = new PlainGraph(name);
        this.ig.setRole(GraphRole.HOST);
        this.addClasses(this.mh.getiClasses());
        this.addStructuralFeatures(this.mh.getiClasses());
    }

    private void addClasses(Vector<EObject> iClasses) {
        for (EObject iClass : iClasses) {
            String labelText = GraphLabels.getLabel((EClassifier)iClass.eClass());
            PlainNode node = (PlainNode)this.ig.addNode();
            this.ig.addEdge(node, labelText, node);
            if (iClass.eContainingFeature() == null) {
                this.ig.addEdge(node, "flag:root", node);
            }
            this.iClassToNodeMap.put(iClass, node);
        }
    }

    private void addStructuralFeatures(Vector<EObject> iClasses) {
        for (EObject iClass : iClasses) {
            for (EStructuralFeature feature : iClass.eClass().getEAllStructuralFeatures()) {
                PlainNode last;
                PlainNode previous;
                boolean ordered;
                EList targets;
                if (feature.eClass().getName().equals("EReference")) {
                    if (iClass.eGet(feature) == null) continue;
                    if (feature.isMany()) {
                        targets = (EList)iClass.eGet(feature, true);
                        ordered = feature.isOrdered();
                        previous = null;
                        last = null;
                        for (EObject target : targets) {
                            if (!this.iClassToNodeMap.containsKey(target)) continue;
                            last = this.addReference(iClass, feature, target);
                            this.addOpposite(iClass, feature, target);
                            if (ordered && previous != null) {
                                this.ig.addEdge(previous, "next", last);
                            }
                            previous = last;
                        }
                        continue;
                    }
                    EObject target = (EObject)iClass.eGet(feature, true);
                    if (!this.iClassToNodeMap.containsKey(target)) continue;
                    this.addReference(iClass, feature, target);
                    this.addOpposite(iClass, feature, target);
                    continue;
                }
                if (!feature.eClass().getName().equals("EAttribute") || iClass.eGet(feature) == null) continue;
                if (feature.isMany()) {
                    targets = (EList)iClass.eGet(feature, true);
                    ordered = feature.isOrdered();
                    previous = null;
                    last = null;
                    for (Object iTarget : targets) {
                        last = this.addAttribute(iClass, feature, iTarget);
                        if (ordered && previous != null) {
                            PlainLabel label = PlainLabel.createLabel("next");
                            this.ig.addEdge(previous, label, last);
                        }
                        previous = last;
                    }
                    continue;
                }
                Object iTarget = iClass.eGet(feature, true);
                this.addAttribute(iClass, feature, iTarget);
            }
            this.iClassReferencesDone.add(iClass);
        }
    }

    private void addOpposite(EObject iClass, EStructuralFeature feature, EObject target) {
        EReference oppositeRef = ((EReference)feature).getEOpposite();
        if (oppositeRef != null) {
            if (oppositeRef.isMany()) {
                EList opposites = (EList)target.eGet((EStructuralFeature)oppositeRef);
                for (EObject opposite : opposites) {
                    if (!opposite.equals(iClass) || !this.iReferenceToNodeMap.containsKey(Triple.create(target, oppositeRef, opposite)) || this.iReferenceToNodeMap.get(Triple.create(target, oppositeRef, opposite)).isEmpty()) continue;
                    Stack<PlainNode> nodeStack1 = this.iReferenceToNodeMap.get(Triple.create(opposite, feature, target));
                    PlainNode node1 = nodeStack1.pop();
                    Stack<PlainNode> nodeStack2 = this.iReferenceToNodeMap.get(Triple.create(target, oppositeRef, opposite));
                    PlainNode node2 = nodeStack2.pop();
                    this.ig.addEdge(node1, "opposite", node2);
                    this.ig.addEdge(node2, "opposite", node1);
                }
            } else {
                EReference opposite = ((EReference)feature).getEOpposite();
                if (opposite.equals(iClass) && this.iReferenceToNodeMap.containsKey(Triple.create(target, oppositeRef, opposite)) && !this.iReferenceToNodeMap.get(Triple.create(target, oppositeRef, opposite)).isEmpty()) {
                    Stack<PlainNode> nodeStack1 = this.iReferenceToNodeMap.get(Triple.create(opposite, feature, target));
                    PlainNode node1 = nodeStack1.pop();
                    Stack<PlainNode> nodeStack2 = this.iReferenceToNodeMap.get(Triple.create(target, oppositeRef, opposite));
                    PlainNode node2 = nodeStack2.pop();
                    this.ig.addEdge(node1, "opposite", node2);
                    this.ig.addEdge(node2, "opposite", node1);
                }
            }
        }
    }

    private PlainNode addAttribute(EObject source, EStructuralFeature feature, Object target) {
        String attributeLabel = GraphLabels.getLabel(feature);
        EDataType attributeType = ((EAttribute)feature).getEAttributeType();
        String datatypeLabel = GraphLabels.getLabel(attributeType, target);
        PlainNode attributeNode = (PlainNode)this.ig.addNode();
        this.ig.addEdge(attributeNode, attributeLabel, attributeNode);
        PlainNode sourceNode = this.iClassToNodeMap.get(source);
        this.ig.addEdge(sourceNode, feature.getName(), attributeNode);
        if (!datatypeLabel.isEmpty()) {
            PlainNode datatypeNode = (PlainNode)this.ig.addNode();
            this.ig.addEdge(datatypeNode, datatypeLabel, datatypeNode);
            this.ig.addEdge(attributeNode, "val", datatypeNode);
            if (attributeType.eClass().getName().equals("EEnum")) {
                String flagLabel = String.valueOf(EdgeRole.FLAG.getPrefix()) + target.toString();
                this.ig.addEdge(datatypeNode, flagLabel, datatypeNode);
            }
        }
        return attributeNode;
    }

    private PlainNode addReference(EObject source, EStructuralFeature feature, EObject target) {
        String labelText = GraphLabels.getLabel(feature);
        PlainNode node = (PlainNode)this.ig.addNode();
        this.ig.addEdge(node, labelText, node);
        if (((EReference)feature).isContainment()) {
            PlainLabel contLabel = PlainLabel.createLabel("flag:containment");
            this.ig.addEdge(node, contLabel, node);
        }
        PlainNode sourceNode = this.iClassToNodeMap.get(source);
        this.ig.addEdge(sourceNode, feature.getName(), node);
        PlainNode targetNode = this.iClassToNodeMap.get(target);
        this.ig.addEdge(node, "val", targetNode);
        Stack<PlainNode> nodeStack = this.iReferenceToNodeMap.get(Triple.create(source, feature, target));
        if (nodeStack != null) {
            nodeStack.push(node);
        } else {
            nodeStack = new Stack();
            nodeStack.push(node);
            this.iReferenceToNodeMap.put(Triple.create(source, feature, target), nodeStack);
        }
        return node;
    }

    public PlainGraph getInstanceGraph() {
        return this.ig;
    }
}

