/*
 * Decompiled with CFR 0.152.
 */
package groove.io.external;

import groove.io.FileType;
import groove.io.external.FormatFilter;
import groove.io.external.FormatPorter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class Format {
    private final FormatPorter formatter;
    private final List<String> extensions;
    private final String description;
    private FormatFilter filter;

    public Format(FormatPorter formatter, String description, String ... extensions) {
        this.formatter = formatter;
        this.extensions = Arrays.asList(extensions);
        this.description = description;
    }

    public Format(FormatPorter formatter, FileType ... types) {
        this.formatter = formatter;
        ArrayList<String> exts = new ArrayList<String>();
        FileType[] fileTypeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            FileType type = fileTypeArray[n2];
            exts.add(type.getExtension());
            ++n2;
        }
        this.extensions = exts;
        this.description = types[0].getDescription();
    }

    public FormatPorter getFormatter() {
        return this.formatter;
    }

    public List<String> getExtensions() {
        return this.extensions;
    }

    public String getDescription() {
        Iterator<String> it = this.extensions.iterator();
        StringBuilder exts = new StringBuilder("*" + it.next());
        while (it.hasNext()) {
            exts.append(";*");
            exts.append(it.next());
        }
        return String.valueOf(this.description) + " (" + exts.toString() + ")";
    }

    public String stripExtension(String fileName) {
        for (String ext : this.extensions) {
            if (!fileName.endsWith(ext)) continue;
            fileName = fileName.substring(0, fileName.length() - ext.length());
            break;
        }
        return fileName;
    }

    public FormatFilter getFilter() {
        if (this.filter == null) {
            this.filter = new FormatFilter(this);
        }
        return this.filter;
    }
}

