/*
 * Decompiled with CFR 0.152.
 */
package groove.io.external.format;

import groove.grammar.aspect.AspectGraph;
import groove.grammar.model.GrammarModel;
import groove.grammar.model.ResourceKind;
import groove.graph.Edge;
import groove.graph.Graph;
import groove.graph.GraphRole;
import groove.graph.Node;
import groove.graph.plain.PlainGraph;
import groove.graph.plain.PlainNode;
import groove.io.FileType;
import groove.io.external.AbstractFormatExporter;
import groove.io.external.Exporter;
import groove.io.external.Format;
import groove.io.external.FormatImporter;
import groove.io.external.FormatPorter;
import groove.io.external.PortException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class AutPorter
extends AbstractFormatExporter
implements FormatImporter {
    private final List<Format> formats;
    private static final String ROOT_LABEL = "$ROOT$";
    private static final AutPorter instance = new AutPorter();

    private AutPorter() {
        Format autFormat = new Format((FormatPorter)this, FileType.AUT);
        this.formats = Arrays.asList(autFormat);
    }

    @Override
    public FormatPorter.Kind getFormatKind() {
        return FormatPorter.Kind.GRAPH;
    }

    @Override
    public Collection<? extends Format> getSupportedFormats() {
        return this.formats;
    }

    @Override
    public Set<FormatImporter.Resource> doImport(File file, Format format, GrammarModel grammar) throws PortException {
        Set<FormatImporter.Resource> resources;
        try {
            FileInputStream stream = new FileInputStream(file);
            resources = this.doImport(format.stripExtension(file.getName()), stream, format, grammar);
            stream.close();
        }
        catch (IOException e) {
            throw new PortException(e);
        }
        return resources;
    }

    @Override
    public Set<FormatImporter.Resource> doImport(String name, InputStream stream, Format format, GrammarModel grammar) throws PortException {
        HashMap<String, PlainNode> result = new HashMap<String, PlainNode>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        int linenr = 0;
        try {
            PlainGraph graph = new PlainGraph(name);
            String line = reader.readLine();
            ++linenr;
            int rootStart = line.indexOf(40) + 1;
            int edgeCountStart = line.indexOf(44) + 1;
            int root = Integer.parseInt(line.substring(rootStart, edgeCountStart - 1).trim());
            PlainNode rootNode = (PlainNode)graph.addNode(root);
            result.put("" + root, rootNode);
            graph.addEdge(rootNode, ROOT_LABEL, rootNode);
            line = reader.readLine();
            while (line != null) {
                ++linenr;
                if (line.trim().length() > 0) {
                    int sourceStart = line.indexOf(40) + 1;
                    int labelStart = line.indexOf(44) + 1;
                    int targetStart = line.lastIndexOf(44) + 1;
                    int source = Integer.parseInt(line.substring(sourceStart, labelStart - 1).trim());
                    String label = line.substring(labelStart, targetStart - 1);
                    int target = Integer.parseInt(line.substring(targetStart, line.lastIndexOf(41)).trim());
                    PlainNode sourceNode = (PlainNode)graph.addNode(source);
                    PlainNode targetNode = (PlainNode)graph.addNode(target);
                    result.put("" + source, sourceNode);
                    result.put("" + target, targetNode);
                    graph.addEdge(sourceNode, label, targetNode);
                }
                line = reader.readLine();
            }
            graph.setRole(GraphRole.HOST);
            AspectGraph agraph = AspectGraph.newInstance(graph);
            Set<FormatImporter.Resource> set = Collections.singleton(new FormatImporter.Resource(ResourceKind.HOST, name, agraph));
            return set;
        }
        catch (Exception e) {
            throw new PortException(String.format("Format error in line %d: %s", linenr, e.getMessage()));
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException e) {
                throw new PortException(e);
            }
        }
    }

    @Override
    public void doExport(File file, Format format, Exporter.Exportable exportable) throws PortException {
        Graph graph = exportable.getGraph();
        try {
            PrintWriter writer = new PrintWriter(file);
            this.save(graph, writer);
            writer.close();
        }
        catch (FileNotFoundException e) {
            throw new PortException(e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void save(Graph graph, PrintWriter writer) {
        int nodeCount = graph.nodeCount();
        BitSet nodeList = new BitSet(nodeCount);
        HashMap<Node, Integer> nodeNrMap = new HashMap<Node, Integer>();
        HashSet<Node> restNodes = new HashSet<Node>();
        for (Node node : graph.nodeSet()) {
            int nodeNr = node.getNumber();
            if (nodeNr >= 0 && nodeNr < nodeCount) {
                nodeList.set(nodeNr);
                nodeNrMap.put(node, nodeNr);
                continue;
            }
            restNodes.add(node);
        }
        int n = -1;
        for (Node node : restNodes) {
            void var7_14;
            while (nodeList.get((int)(++var7_14))) {
            }
            nodeNrMap.put(node, (int)var7_14);
        }
        writer.printf("des (%d, %d, %d)%n", 0, graph.edgeCount(), graph.nodeCount());
        for (Edge edge : graph.edgeSet()) {
            String format = edge.label().text().indexOf(44) >= 0 ? "(%d,\"%s\",%d)%n" : "(%d,%s,%d)%n";
            writer.printf(format, nodeNrMap.get(edge.source()), edge.label(), nodeNrMap.get(edge.target()));
        }
    }

    public static final AutPorter getInstance() {
        return instance;
    }
}

