/*
 * Decompiled with CFR 0.152.
 */
package groove.io.external.format;

import groove.algebra.Algebra;
import groove.algebra.AlgebraFamily;
import groove.grammar.aspect.AspectGraph;
import groove.grammar.aspect.GraphConverter;
import groove.grammar.host.DefaultHostGraph;
import groove.grammar.host.HostGraph;
import groove.grammar.host.HostNode;
import groove.grammar.host.ValueNode;
import groove.grammar.model.GrammarModel;
import groove.grammar.model.ResourceKind;
import groove.grammar.type.TypeLabel;
import groove.graph.EdgeRole;
import groove.gui.Simulator;
import groove.io.FileType;
import groove.io.external.Format;
import groove.io.external.FormatImporter;
import groove.io.external.FormatPorter;
import groove.io.external.PortException;
import java.awt.Frame;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class ColImporter
implements FormatImporter {
    private final List<Format> formats = Arrays.asList(new Format((FormatPorter)this, FileType.COL));
    private Frame parent;
    private static final ColImporter instance = new ColImporter();
    private static final TypeLabel LABEL = TypeLabel.createBinaryLabel("n");

    private ColImporter() {
    }

    @Override
    public FormatPorter.Kind getFormatKind() {
        return FormatPorter.Kind.RESOURCE;
    }

    @Override
    public Collection<? extends Format> getSupportedFormats() {
        return this.formats;
    }

    @Override
    public Set<FormatImporter.Resource> doImport(File file, Format format, GrammarModel grammar) throws PortException {
        Set<FormatImporter.Resource> resources;
        try {
            FileInputStream stream = new FileInputStream(file);
            resources = this.doImport(format.stripExtension(file.getName()), stream, format, grammar);
            stream.close();
        }
        catch (IOException e) {
            throw new PortException(e);
        }
        return resources;
    }

    @Override
    public Set<FormatImporter.Resource> doImport(String name, InputStream stream, Format format, GrammarModel grammar) throws PortException {
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
            DefaultHostGraph graph = new DefaultHostGraph(name);
            Algebra<?> intAlgebra = AlgebraFamily.getInstance().getAlgebraFor("0");
            TypeLabel valueLabel = TypeLabel.createBinaryLabel("value");
            String nextLine = reader.readLine();
            while (nextLine != null) {
                String[] fragments = nextLine.split(" ");
                if (fragments[0].equals("n")) {
                    HostNode node = this.addNode(graph, fragments[1]);
                    ValueNode valueNode = graph.addNode(intAlgebra, intAlgebra.getValueFromSymbol(fragments[2]));
                    graph.addEdge(node, valueLabel, valueNode);
                } else if (fragments[0].equals("e")) {
                    HostNode source = this.addNode(graph, fragments[1]);
                    HostNode target = this.addNode(graph, fragments[2]);
                    graph.addEdge(source, LABEL, target);
                }
                nextLine = reader.readLine();
            }
            AspectGraph aGraph = GraphConverter.toAspect(graph);
            FormatImporter.Resource res = new FormatImporter.Resource(ResourceKind.HOST, name, aGraph);
            reader.close();
            return Collections.singleton(res);
        }
        catch (IOException e) {
            throw new PortException(e);
        }
    }

    private HostNode addNode(HostGraph result, String id) {
        HostNode node = result.getFactory().createNode(Integer.parseInt(id));
        result.addEdge(node, TypeLabel.createLabel(EdgeRole.FLAG, "i" + id), node);
        return node;
    }

    protected Frame getParent() {
        return this.parent;
    }

    @Override
    public void setSimulator(Simulator simulator) {
        this.parent = simulator.getFrame();
    }

    public static final ColImporter getInstance() {
        return instance;
    }
}

