/*
 * Decompiled with CFR 0.152.
 */
package groove.io.external.format;

import groove.grammar.model.GrammarModel;
import groove.io.conceptual.InstanceModel;
import groove.io.conceptual.TypeModel;
import groove.io.conceptual.lang.ExportableResource;
import groove.io.conceptual.lang.ImportException;
import groove.io.conceptual.lang.graphviz.GraphvizResource;
import groove.io.conceptual.lang.graphviz.GraphvizToInstance;
import groove.io.conceptual.lang.graphviz.InstanceToGraphviz;
import groove.io.conceptual.lang.graphviz.TypeToGraphviz;
import groove.io.external.ConceptualPorter;
import groove.io.external.FormatPorter;
import groove.io.external.PortException;
import groove.util.Pair;
import java.io.File;

public class DotPorter
extends ConceptualPorter {
    private static final DotPorter instance = new DotPorter();

    private DotPorter() {
        super("Graphviz DOT", ".viz");
    }

    @Override
    public FormatPorter.Kind getFormatKind() {
        return FormatPorter.Kind.RESOURCE;
    }

    @Override
    protected Pair<TypeModel, InstanceModel> importInstanceModel(File file, GrammarModel grammar) throws ImportException {
        GraphvizToInstance gtg = new GraphvizToInstance(file.getAbsolutePath());
        InstanceModel im = gtg.getInstanceModel("DOT");
        return Pair.newPair(im.getTypeModel(), im);
    }

    @Override
    protected Pair<TypeModel, InstanceModel> importTypeModel(File file, GrammarModel grammar) throws ImportException {
        return null;
    }

    @Override
    protected ExportableResource getResource(File file, boolean isHost, TypeModel tm, InstanceModel im) throws PortException {
        GraphvizResource result = new GraphvizResource(file, file);
        TypeToGraphviz ttg = new TypeToGraphviz(result);
        ttg.addTypeModel(tm);
        if (isHost) {
            InstanceToGraphviz itg = new InstanceToGraphviz(ttg);
            itg.addInstanceModel(im);
        }
        return result;
    }

    public static final DotPorter getInstance() {
        return instance;
    }
}

