/*
 * Decompiled with CFR 0.152.
 */
package groove.io.external.format;

import groove.grammar.aspect.AspectGraph;
import groove.grammar.model.GrammarModel;
import groove.grammar.model.GraphBasedModel;
import groove.grammar.model.ResourceKind;
import groove.grammar.model.ResourceModel;
import groove.grammar.model.TextBasedModel;
import groove.graph.Graph;
import groove.io.FileType;
import groove.io.Util;
import groove.io.external.AbstractFormatExporter;
import groove.io.external.Exporter;
import groove.io.external.Format;
import groove.io.external.FormatImporter;
import groove.io.external.FormatPorter;
import groove.io.external.PortException;
import groove.io.graph.AttrGraph;
import groove.io.graph.GxlIO;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class NativePorter
extends AbstractFormatExporter
implements FormatImporter {
    private final List<ResourceFormat> formats = new ArrayList<ResourceFormat>();
    private static final NativePorter instance = new NativePorter();

    private NativePorter() {
        this.addFormat(ResourceKind.TYPE, FileType.TYPE);
        this.addFormat(ResourceKind.HOST, FileType.STATE, FileType.GXL);
        this.addFormat(ResourceKind.RULE, FileType.RULE);
        this.addFormat(ResourceKind.CONTROL, FileType.CONTROL);
        this.addFormat(ResourceKind.PROLOG, FileType.PROLOG1, FileType.PROLOG2);
        this.addFormat(ResourceKind.GROOVY, FileType.GROOVY);
        this.addFormat(ResourceKind.CONFIG, FileType.CONFIG);
    }

    private void addFormat(ResourceKind kind, FileType ... fileTypes) {
        this.formats.add(new ResourceFormat(this, kind, fileTypes));
    }

    @Override
    public FormatPorter.Kind getFormatKind() {
        return FormatPorter.Kind.RESOURCE;
    }

    @Override
    public Collection<? extends Format> getSupportedFormats() {
        return this.formats;
    }

    @Override
    public Set<FormatImporter.Resource> doImport(File file, Format format, GrammarModel grammar) throws PortException {
        FormatImporter.Resource result;
        ResourceKind kind = ((ResourceFormat)format).getKind();
        try {
            String name = format.stripExtension(file.getName());
            if (kind.isGraphBased()) {
                AttrGraph xmlGraph = GxlIO.getInstance().loadGraph(file);
                xmlGraph.setRole(kind.getGraphRole());
                xmlGraph.setName(name);
                result = new FormatImporter.Resource(kind, name, xmlGraph.toAspectGraph());
            } else {
                String program = Util.readFileToString(file);
                result = new FormatImporter.Resource(kind, name, program);
            }
        }
        catch (IOException e) {
            throw new PortException(e);
        }
        return Collections.singleton(result);
    }

    @Override
    public Set<FormatImporter.Resource> doImport(String name, InputStream stream, Format format, GrammarModel grammar) throws PortException {
        FormatImporter.Resource result;
        ResourceKind kind = ((ResourceFormat)format).getKind();
        if (kind.isGraphBased()) {
            throw new PortException("Cannot import from stream");
        }
        try {
            String resource = Util.readInputStreamToString(stream);
            result = new FormatImporter.Resource(kind, name, resource);
        }
        catch (IOException e) {
            throw new PortException(e);
        }
        return Collections.singleton(result);
    }

    @Override
    public void doExport(File file, Format format, Exporter.Exportable exportable) throws PortException {
        ResourceModel<?> model = exportable.getModel();
        ResourceKind kind = model.getKind();
        if (kind.isGraphBased()) {
            GraphBasedModel graphModel = (GraphBasedModel)model;
            AspectGraph graph = graphModel.getSource();
            try {
                GxlIO.getInstance().saveGraph((Graph)graph.toPlainGraph(), file);
            }
            catch (IOException e) {
                throw new PortException(e);
            }
        }
        TextBasedModel textModel = (TextBasedModel)model;
        FileWriter writer = null;
        try {
            try {
                writer = new FileWriter(file);
                writer.write(textModel.getSource());
            }
            catch (IOException e) {
                throw new PortException(e);
            }
        }
        finally {
            try {
                if (writer != null) {
                    ((Writer)writer).close();
                }
            }
            catch (IOException e) {
                throw new PortException(e);
            }
        }
    }

    public static final NativePorter getInstance() {
        return instance;
    }

    public class ResourceFormat
    extends Format {
        private final ResourceKind kind;

        protected ResourceFormat(FormatPorter formatter, ResourceKind kind, FileType ... types) {
            super(formatter, types);
            this.kind = kind;
        }

        public ResourceKind getKind() {
            return this.kind;
        }
    }
}

