/*
 * Decompiled with CFR 0.152.
 */
package groove.io.external.format;

import groove.gui.jgraph.JGraph;
import groove.io.FileType;
import groove.io.external.AbstractFormatExporter;
import groove.io.external.Exporter;
import groove.io.external.Format;
import groove.io.external.FormatPorter;
import groove.io.external.PortException;
import groove.io.external.util.GraphToTikz;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Collections;

public final class TikzExporter
extends AbstractFormatExporter {
    private static final TikzExporter instance = new TikzExporter();
    private static Format tikzformat;

    public static final TikzExporter getInstance() {
        return instance;
    }

    private TikzExporter() {
        tikzformat = new Format((FormatPorter)this, FileType.TIKZ);
    }

    @Override
    public FormatPorter.Kind getFormatKind() {
        return FormatPorter.Kind.JGRAPH;
    }

    @Override
    public Collection<? extends Format> getSupportedFormats() {
        return Collections.singletonList(tikzformat);
    }

    @Override
    public void doExport(File file, Format format, Exporter.Exportable exportable) throws PortException {
        JGraph<?> jGraph = exportable.getJGraph();
        try {
            PrintWriter writer = new PrintWriter(new FileWriter(file));
            GraphToTikz.export(jGraph, writer);
            writer.close();
        }
        catch (IOException e) {
            throw new PortException(e);
        }
    }
}

