/*
 * Decompiled with CFR 0.152.
 */
package groove.io.external.format;

import groove.gui.jgraph.JGraph;
import groove.io.FileType;
import groove.io.external.AbstractFormatExporter;
import groove.io.external.Exporter;
import groove.io.external.Format;
import groove.io.external.FormatPorter;
import groove.io.external.PortException;
import groove.io.external.util.GraphToVector;
import java.io.File;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public class VectorExporter
extends AbstractFormatExporter {
    private final Map<Format, GraphToVector> formats = new LinkedHashMap<Format, GraphToVector>();
    private static final VectorExporter instance = new VectorExporter();

    private VectorExporter() {
        Format pdfformat = new Format((FormatPorter)this, FileType.PDF);
        GraphToVector pdfObject = this.getGraphToVector("groove.io.external.util.GraphToPDF");
        if (pdfObject != null) {
            this.formats.put(pdfformat, pdfObject);
        }
        Format epsformat = new Format((FormatPorter)this, FileType.EPS);
        GraphToVector epsObject = this.getGraphToVector("groove.io.external.util.GraphToEPS");
        if (epsObject != null) {
            this.formats.put(epsformat, epsObject);
        }
    }

    @Override
    public FormatPorter.Kind getFormatKind() {
        return FormatPorter.Kind.JGRAPH;
    }

    private GraphToVector getGraphToVector(String vectorClassName) {
        GraphToVector result = null;
        try {
            Class<?> cls = Class.forName(vectorClassName);
            result = (GraphToVector)cls.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {}
        return result;
    }

    @Override
    public Collection<? extends Format> getSupportedFormats() {
        return this.formats.keySet();
    }

    @Override
    public void doExport(File file, Format format, Exporter.Exportable exportable) throws PortException {
        JGraph<?> jGraph = exportable.getJGraph();
        this.formats.get(format).renderGraph(jGraph, file);
    }

    public static final VectorExporter getInstance() {
        return instance;
    }
}

