/*
 * Decompiled with CFR 0.152.
 */
package groove.io.graph;

import groove.abstraction.Multiplicity;
import groove.abstraction.neigh.EdgeMultDir;
import groove.abstraction.neigh.equiv.EquivClass;
import groove.abstraction.neigh.equiv.NodeEquivClass;
import groove.abstraction.neigh.shape.EdgeSignature;
import groove.abstraction.neigh.shape.Shape;
import groove.abstraction.neigh.shape.ShapeEdge;
import groove.abstraction.neigh.shape.ShapeFactory;
import groove.abstraction.neigh.shape.ShapeNode;
import groove.abstraction.pattern.shape.PatternEdge;
import groove.abstraction.pattern.shape.PatternFactory;
import groove.abstraction.pattern.shape.PatternNode;
import groove.abstraction.pattern.shape.PatternShape;
import groove.grammar.aspect.AspectEdge;
import groove.grammar.aspect.AspectGraph;
import groove.grammar.aspect.AspectNode;
import groove.grammar.host.HostEdge;
import groove.grammar.host.HostNode;
import groove.grammar.type.TypeGraph;
import groove.graph.AElementMap;
import groove.graph.Edge;
import groove.graph.ElementFactory;
import groove.graph.GGraph;
import groove.graph.GraphInfo;
import groove.graph.GraphRole;
import groove.graph.Node;
import groove.graph.NodeSetEdgeSetGraph;
import groove.graph.plain.PlainGraph;
import groove.graph.plain.PlainLabel;
import groove.io.graph.AttrEdge;
import groove.io.graph.AttrFactory;
import groove.io.graph.AttrNode;
import groove.io.graph.AttrTuple;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class AttrGraph
extends NodeSetEdgeSetGraph<AttrNode, AttrEdge> {
    private final Map<String, AttrNode> nodeMap = new LinkedHashMap<String, AttrNode>();
    private GraphRole role;
    private final List<AttrTuple> tuples = new ArrayList<AttrTuple>();
    private static final String NODE_MULT_ATTR_NAME = "nmult";
    private static final String EDGE_OUT_MULT_ATTR_NAME = "omult";
    private static final String EDGE_IN_MULT_ATTR_NAME = "imult";
    private static final String EDGE_MULT_ATTR_NAME = "emult";

    public AttrGraph(String name) {
        super(name);
    }

    @Override
    public AttrGraph clone() {
        AttrGraph result = this.newGraph(this.getName());
        for (AttrNode node : this.nodeSet()) {
            result.addNode(node.clone());
        }
        for (AttrEdge edge : this.edgeSet()) {
            result.addEdge(edge.clone());
        }
        return result;
    }

    @Override
    public AttrGraph newGraph(String name) {
        return new AttrGraph(name);
    }

    @Override
    public ElementFactory<AttrNode, AttrEdge> getFactory() {
        return AttrFactory.instance();
    }

    @Override
    public boolean addNode(AttrNode node) {
        boolean result = super.addNode(node);
        if (result) {
            this.nodeMap.put(node.toString(), node);
        }
        return result;
    }

    public AttrNode addNode(String id) {
        AttrNode node;
        assert (!this.hasNode(id));
        boolean digitFound = false;
        int nodeNr = 0;
        int unit = 1;
        int charIx = id.length() - 1;
        while (charIx >= 0 && Character.isDigit(id.charAt(charIx))) {
            nodeNr += unit * (id.charAt(charIx) - 48);
            unit *= 10;
            digitFound = true;
            --charIx;
        }
        if (charIx >= 0 && id.charAt(charIx) == '-') {
            nodeNr = -nodeNr;
        }
        AttrNode result = null;
        if (digitFound && this.addNode(node = (AttrNode)this.createNode(nodeNr))) {
            result = node;
        }
        if (result == null) {
            result = (AttrNode)this.addNode();
        }
        this.nodeMap.put(id, result);
        return result;
    }

    public boolean hasNode(String id) {
        return this.nodeMap.containsKey(id);
    }

    public AttrNode getNode(String id) {
        return this.nodeMap.get(id);
    }

    public AttrEdge getEdge(AttrNode source, String text, AttrNode target) {
        AttrEdge result = null;
        for (AttrEdge edge : this.outEdgeSet(source)) {
            if (!((PlainLabel)edge.label()).text().equals(text) || !((AttrNode)edge.target()).equals(target)) continue;
            result = edge;
            break;
        }
        return result;
    }

    public Map<String, AttrNode> getNodeMap() {
        return Collections.unmodifiableMap(this.nodeMap);
    }

    @Override
    public GraphRole getRole() {
        return this.role;
    }

    public void setRole(GraphRole role) {
        this.testFixed(false);
        this.role = role;
    }

    public void addTuple(List<String> nodeIds) {
        ArrayList<AttrNode> nodes = new ArrayList<AttrNode>(nodeIds.size());
        for (String id : nodeIds) {
            AttrNode node = this.getNode(id);
            assert (node != null) : String.format("Unknown node id %s", id);
            nodes.add(node);
        }
        this.tuples.add(new AttrTuple(nodes));
    }

    public void addTuple(AttrTuple tuple) {
        this.tuples.add(tuple);
    }

    public List<AttrTuple> getTuples() {
        return Collections.unmodifiableList(this.tuples);
    }

    public <N extends Node, E extends Edge, G extends GGraph<N, E>> void copyTo(G target) {
        AttrToGraphMap<N, E> map = new AttrToGraphMap<N, E>(target.getFactory());
        for (AttrNode node : this.nodeSet()) {
            N nodeImage = target.addNode(node.getNumber());
            map.putNode(node, nodeImage);
        }
        for (AttrEdge edge : this.edgeSet()) {
            Object edgeImage = map.mapEdge(edge);
            target.addEdge(edgeImage);
        }
        GraphInfo.transfer(this, target, map);
    }

    public PlainGraph toPlainGraph() {
        PlainGraph result = new PlainGraph(this.getName());
        result.setRole(this.getRole());
        this.copyTo(result);
        result.setFixed();
        return result;
    }

    public AspectGraph toAspectGraph() {
        return AspectGraph.newInstance(this);
    }

    public Shape toShape(TypeGraph typeGraph) {
        ShapeFactory shapeFactory = ShapeFactory.newInstance(typeGraph.getFactory());
        Shape result = new Shape(this.getName(), shapeFactory);
        AttrToShapeMap map = new AttrToShapeMap(shapeFactory);
        for (AttrNode node : this.nodeSet()) {
            ShapeNode nodeImage = shapeFactory.createNode(node.getNumber());
            result.addNode(nodeImage);
            map.putNode(node, nodeImage);
            String nodeMultStr = node.getAttribute(NODE_MULT_ATTR_NAME);
            Multiplicity nodeMult = this.getMultiplicity(nodeMultStr, Multiplicity.MultKind.NODE_MULT);
            result.setNodeMult(nodeImage, nodeMult);
        }
        for (AttrTuple tuple : this.getTuples()) {
            NodeEquivClass<ShapeNode> ec = new NodeEquivClass<ShapeNode>(shapeFactory);
            for (AttrNode node : tuple.getNodes()) {
                ShapeNode nodeImage = map.getNode(node);
                ec.add(nodeImage);
            }
            result.getEquivRelation().add((EquivClass<ShapeNode>)ec);
        }
        for (AttrEdge edge : this.edgeSet()) {
            ShapeEdge edgeImage = map.mapEdge(edge);
            result.addEdge(edgeImage);
            EdgeMultDir[] edgeMultDirArray = EdgeMultDir.values();
            int n = edgeMultDirArray.length;
            int n2 = 0;
            while (n2 < n) {
                EdgeMultDir direction = edgeMultDirArray[n2];
                String attrName = direction == EdgeMultDir.OUTGOING ? EDGE_OUT_MULT_ATTR_NAME : EDGE_IN_MULT_ATTR_NAME;
                String multStr = edge.getAttribute(attrName);
                if (multStr != null) {
                    Multiplicity mult = this.getMultiplicity(multStr, Multiplicity.MultKind.EDGE_MULT);
                    EdgeSignature es = result.getEdgeSignature(edgeImage, direction);
                    result.setEdgeSigMult(es, mult);
                }
                ++n2;
            }
        }
        GraphInfo.transfer(this, result, map);
        return result;
    }

    public PatternShape toPattern(groove.abstraction.pattern.shape.TypeGraph typeGraph) {
        PatternShape result = new PatternShape(this.getName(), typeGraph);
        AttrToPatternMap map = new AttrToPatternMap(result.getFactory());
        for (AttrNode node : this.nodeSet()) {
            PatternNode nodeImage = (PatternNode)result.addNode(node.getNumber());
            result.addNode(nodeImage);
            map.putNode(node, nodeImage);
            String nodeMultStr = node.getAttribute(NODE_MULT_ATTR_NAME);
            Multiplicity nodeMult = this.getMultiplicity(nodeMultStr, Multiplicity.MultKind.NODE_MULT);
            result.setMult(nodeImage, nodeMult);
        }
        for (AttrEdge edge : this.edgeSet()) {
            PatternEdge edgeImage = (PatternEdge)map.mapEdge(edge);
            result.addEdge(edgeImage);
            String multStr = edge.getAttribute(EDGE_MULT_ATTR_NAME);
            Multiplicity mult = this.getMultiplicity(multStr, Multiplicity.MultKind.EDGE_MULT);
            result.setMult(edgeImage, mult);
        }
        GraphInfo.transfer(this, result, map);
        return result;
    }

    private Multiplicity getMultiplicity(String multStr, Multiplicity.MultKind kind) {
        String[] parts = multStr.split(" ");
        int lowerBound = Integer.parseInt(parts[0]);
        int upperBound = "w".equals(parts[1]) ? Integer.MAX_VALUE : Integer.parseInt(parts[1]);
        return Multiplicity.getMultiplicity(lowerBound, upperBound, kind);
    }

    public static AttrGraph newInstance(AspectGraph graph) {
        AttrGraph result = new AttrGraph(graph.getName());
        result.setRole(graph.getRole());
        AspectToAttrMap elementMap = new AspectToAttrMap();
        for (AspectNode node : graph.nodeSet()) {
            AttrNode nodeImage = (AttrNode)result.addNode(node.getNumber());
            elementMap.putNode(node, nodeImage);
            for (PlainLabel label : node.getPlainLabels()) {
                result.addEdge(nodeImage, label, nodeImage);
            }
        }
        for (AspectEdge edge : graph.edgeSet()) {
            result.addEdgeContext((AttrEdge)elementMap.mapEdge(edge));
        }
        GraphInfo.transfer(graph, result, elementMap);
        result.setFixed();
        return result;
    }

    public static AttrGraph newInstance(Shape shape) {
        AttrGraph result = new AttrGraph(shape.getName());
        result.setRole(GraphRole.HOST);
        ShapeToAttrMap map = new ShapeToAttrMap();
        for (ShapeNode shapeNode : shape.nodeSet()) {
            AttrNode nodeImage = (AttrNode)result.addNode(shapeNode.getNumber());
            map.putNode(shapeNode, nodeImage);
            Multiplicity nodeMult = shape.getNodeMult(shapeNode);
            nodeImage.setAttribute(NODE_MULT_ATTR_NAME, nodeMult.toSerialString());
        }
        for (EquivClass equivClass : shape.getEquivRelation()) {
            result.addTuple(map.mapTuple(equivClass));
        }
        for (ShapeEdge shapeEdge : shape.edgeSet()) {
            AttrEdge edgeImage = (AttrEdge)map.mapEdge(shapeEdge);
            result.addEdge(edgeImage);
            EdgeMultDir[] edgeMultDirArray = EdgeMultDir.values();
            int n = edgeMultDirArray.length;
            int n2 = 0;
            while (n2 < n) {
                EdgeMultDir direction = edgeMultDirArray[n2];
                Multiplicity edgeMult = shape.getEdgeMult(shapeEdge, direction);
                String attrName = direction == EdgeMultDir.OUTGOING ? EDGE_OUT_MULT_ATTR_NAME : EDGE_IN_MULT_ATTR_NAME;
                edgeImage.setAttribute(attrName, edgeMult.toSerialString());
                ++n2;
            }
        }
        GraphInfo.transfer(shape, result, map);
        result.setFixed();
        return result;
    }

    public static AttrGraph newInstance(PatternShape shape) {
        AttrGraph result = new AttrGraph(shape.getName());
        result.setRole(GraphRole.HOST);
        PatternToXmlMap map = new PatternToXmlMap();
        for (PatternNode node : shape.nodeSet()) {
            AttrNode nodeImage = (AttrNode)result.addNode(node.getNumber());
            map.putNode(node, nodeImage);
            Multiplicity nodeMult = shape.getMult(node);
            nodeImage.setAttribute(NODE_MULT_ATTR_NAME, nodeMult.toSerialString());
        }
        for (PatternEdge edge : shape.edgeSet()) {
            AttrEdge edgeImage = (AttrEdge)map.mapEdge(edge);
            result.addEdge(edgeImage);
            Multiplicity edgeMult = shape.getMult(edge);
            edgeImage.setAttribute(EDGE_MULT_ATTR_NAME, edgeMult.toSerialString());
        }
        GraphInfo.transfer(shape, result, map);
        result.setFixed();
        return result;
    }

    private static class AspectToAttrMap
    extends AElementMap<AspectNode, AspectEdge, AttrNode, AttrEdge> {
        public AspectToAttrMap() {
            super(AttrFactory.instance());
        }

        @Override
        public AttrEdge createImage(AspectEdge key) {
            AttrNode imageSource = (AttrNode)this.getNode((Node)key.source());
            if (imageSource == null) {
                return null;
            }
            AttrNode imageTarget = (AttrNode)this.getNode((Node)key.target());
            if (imageTarget == null) {
                return null;
            }
            return (AttrEdge)this.getFactory().createEdge(imageSource, key.getPlainLabel(), imageTarget);
        }
    }

    private static class AttrToGraphMap<N extends Node, E extends Edge>
    extends AElementMap<AttrNode, AttrEdge, N, E> {
        public AttrToGraphMap(ElementFactory<N, E> factory) {
            super(factory);
        }
    }

    private static class AttrToPatternMap
    extends AttrToGraphMap<PatternNode, PatternEdge> {
        public AttrToPatternMap(PatternFactory factory) {
            super(factory);
        }
    }

    private static class AttrToShapeMap
    extends AttrToGraphMap<HostNode, HostEdge> {
        public AttrToShapeMap(ShapeFactory factory) {
            super(factory);
        }

        @Override
        public ShapeNode getNode(Node key) {
            return (ShapeNode)super.getNode(key);
        }

        @Override
        public ShapeEdge mapEdge(AttrEdge key) {
            return (ShapeEdge)super.mapEdge(key);
        }
    }

    private static class PatternToXmlMap
    extends AElementMap<PatternNode, PatternEdge, AttrNode, AttrEdge> {
        public PatternToXmlMap() {
            super(AttrFactory.instance());
        }
    }

    private static class ShapeToAttrMap
    extends AElementMap<HostNode, HostEdge, AttrNode, AttrEdge> {
        public ShapeToAttrMap() {
            super(AttrFactory.instance());
        }

        public AttrTuple mapTuple(Collection<ShapeNode> nodes) {
            ArrayList<AttrNode> result = new ArrayList<AttrNode>(nodes.size());
            for (ShapeNode sn : nodes) {
                result.add((AttrNode)this.getNode(sn));
            }
            return new AttrTuple(result);
        }
    }
}

