/*
 * Decompiled with CFR 0.152.
 */
package groove.io.graph;

import de.gupro.gxl.gxl_1_0.AttrType;
import de.gupro.gxl.gxl_1_0.EdgeType;
import de.gupro.gxl.gxl_1_0.EdgemodeType;
import de.gupro.gxl.gxl_1_0.GraphElementType;
import de.gupro.gxl.gxl_1_0.GraphType;
import de.gupro.gxl.gxl_1_0.GxlType;
import de.gupro.gxl.gxl_1_0.NodeType;
import de.gupro.gxl.gxl_1_0.ObjectFactory;
import de.gupro.gxl.gxl_1_0.RelType;
import de.gupro.gxl.gxl_1_0.RelendType;
import de.gupro.gxl.gxl_1_0.TypedElementType;
import groove.grammar.aspect.AspectKind;
import groove.grammar.host.ValueNode;
import groove.grammar.model.FormatErrorSet;
import groove.grammar.model.FormatException;
import groove.grammar.type.TypeEdge;
import groove.grammar.type.TypeGraph;
import groove.grammar.type.TypeLabel;
import groove.grammar.type.TypeNode;
import groove.graph.Edge;
import groove.graph.Graph;
import groove.graph.GraphInfo;
import groove.graph.GraphProperties;
import groove.graph.GraphRole;
import groove.graph.Node;
import groove.gui.layout.JEdgeLayout;
import groove.gui.layout.JVertexLayout;
import groove.gui.layout.LayoutMap;
import groove.gui.look.LineStyle;
import groove.io.ExtensionFilter;
import groove.io.FileType;
import groove.io.graph.AttrEdge;
import groove.io.graph.AttrGraph;
import groove.io.graph.AttrNode;
import groove.io.graph.AttrTuple;
import groove.io.graph.GraphIO;
import groove.io.graph.LayoutIO;
import groove.io.graph.PriorityFileName;
import groove.util.Groove;
import groove.util.Version;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;

public class GxlIO
implements GraphIO {
    private final JAXBContext context;
    private final Marshaller marshaller;
    private final Unmarshaller unmarshaller;
    private final ObjectFactory factory;
    private static final GxlIO INSTANCE = new GxlIO();
    private static final String LABEL_ATTR_NAME = "label";
    private static final String LAYOUT_ATTR_NAME = "layout";
    private static final String ABSTRACT_PREFIX = AspectKind.ABSTRACT.getAspect().toString();
    private static final String SUBTYPE_PREFIX = AspectKind.SUBTYPE.getAspect().toString();

    private GxlIO() {
        try {
            this.context = JAXBContext.newInstance((String)GxlType.class.getPackage().getName());
            this.unmarshaller = this.context.createUnmarshaller();
            this.marshaller = this.context.createMarshaller();
            this.marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        }
        catch (JAXBException jAXBException) {
            throw new IllegalStateException();
        }
        this.factory = new ObjectFactory();
    }

    @Override
    public void deleteGraph(File file) {
        this.deleteFile(file);
        this.deleteFile(this.toLayoutFile(file));
    }

    private void deleteFile(File file) {
        if (file.exists() && file.canWrite()) {
            file.delete();
        }
    }

    private File toLayoutFile(File graphFile) {
        return new File(FileType.LAYOUT_FILTER.addExtension(graphFile.toString()));
    }

    @Override
    public void saveGraph(Graph graph, File file) throws IOException {
        File parent = file.getParentFile();
        if (parent != null && !parent.exists()) {
            parent.mkdirs();
        }
        FileOutputStream out = new FileOutputStream(file);
        try {
            this.saveGraph(graph, out);
        }
        finally {
            out.close();
        }
        this.deleteFile(this.toLayoutFile(file));
    }

    @Override
    public void saveGraph(Graph graph, OutputStream out) throws IOException {
        GraphType gxlGraph = this.graphToGxl(graph);
        try {
            GxlType document = new GxlType();
            document.getGraph().add(gxlGraph);
            this.marshaller.marshal((Object)this.factory.createGxl(document), out);
            out.close();
        }
        catch (JAXBException e) {
            throw new IOException(e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private GraphType graphToGxl(Graph graph) {
        EdgeType gxlEdge;
        GraphType gxlGraph = this.factory.createGraphType();
        gxlGraph.setEdgeids(Boolean.valueOf(false));
        gxlGraph.setEdgemode(EdgemodeType.DIRECTED);
        gxlGraph.setId(graph.getName());
        gxlGraph.setRole(graph.getRole().toString());
        List nodesEdges = gxlGraph.getNodeOrEdgeOrRel();
        HashMap<Node, NodeType> nodeMap = new HashMap<Node, NodeType>();
        HashMap<Edge, EdgeType> edgeMap = new HashMap<Edge, EdgeType>();
        LayoutMap layoutMap = GraphInfo.getLayoutMap(graph);
        for (Node node : graph.nodeSet()) {
            NodeType gxlNode = this.factory.createNodeType();
            gxlNode.setId("n" + node.getNumber());
            if (layoutMap != null) {
                this.storeNodeLayout(layoutMap, node, gxlNode);
            }
            nodeMap.put(node, gxlNode);
            nodesEdges.add(gxlNode);
            if (node instanceof ValueNode) {
                gxlEdge = this.createGxlEdge(nodeMap, node, ((ValueNode)node).toString(), node);
                nodesEdges.add(gxlEdge);
            }
            if (!(node instanceof AttrNode)) continue;
            this.saveAttributes((TypedElementType)gxlNode, ((AttrNode)node).getAttributes());
        }
        for (Edge edge : graph.edgeSet()) {
            Object prefixedLabel = edge.label().text();
            if (edge.label() instanceof TypeLabel) {
                prefixedLabel = String.valueOf(edge.getRole().getPrefix()) + (String)prefixedLabel;
            }
            if (edge instanceof TypeEdge && ((TypeEdge)edge).isAbstract()) {
                prefixedLabel = String.valueOf(ABSTRACT_PREFIX) + (String)prefixedLabel;
            }
            gxlEdge = this.createGxlEdge(nodeMap, edge.source(), (String)prefixedLabel, edge.target());
            edgeMap.put(edge, gxlEdge);
            nodesEdges.add(gxlEdge);
            if (layoutMap != null) {
                this.storeEdgeLayout(layoutMap, edge, gxlEdge);
            }
            if (!(edge instanceof AttrEdge)) continue;
            this.saveAttributes((TypedElementType)gxlEdge, ((AttrEdge)edge).getAttributes());
        }
        if (graph instanceof AttrGraph) {
            boolean bl = false;
            for (AttrTuple tuple : ((AttrGraph)graph).getTuples()) {
                void var7_12;
                RelType gxlRel = this.factory.createRelType();
                gxlRel.setId("ec" + (int)var7_12);
                ++var7_12;
                for (AttrNode node : tuple.getNodes()) {
                    RelendType relEnd = this.factory.createRelendType();
                    relEnd.setId(node.toString());
                    gxlRel.getRelend().add(relEnd);
                }
                nodesEdges.add(gxlRel);
            }
        }
        if (graph instanceof TypeGraph) {
            TypeGraph typeGraph = (TypeGraph)graph;
            Map<TypeNode, Set<TypeNode>> subtypeMap = typeGraph.getDirectSubtypeMap();
            for (Map.Entry<TypeNode, Set<TypeNode>> subtypeEntry : subtypeMap.entrySet()) {
                for (TypeNode subtype : subtypeEntry.getValue()) {
                    TypeNode supertype = subtypeEntry.getKey();
                    nodesEdges.add(this.createGxlEdge(nodeMap, subtype, SUBTYPE_PREFIX, supertype));
                }
            }
        }
        if (graph.hasInfo()) {
            gxlGraph.setId(graph.getName());
            gxlGraph.setRole(graph.getRole().toString());
            GraphProperties graphProperties = GraphInfo.getProperties(graph);
            for (Map.Entry<Object, Object> entry : graphProperties.entrySet()) {
                this.storeAttribute((TypedElementType)gxlGraph, (String)entry.getKey(), (String)entry.getValue());
            }
            this.storeAttribute((TypedElementType)gxlGraph, GraphProperties.Key.VERSION.getName(), "curly");
        }
        return gxlGraph;
    }

    private void storeNodeLayout(LayoutMap map, Node node, NodeType gxl) {
        JVertexLayout layout = map.nodeMap().get(node);
        if (layout != null) {
            Rectangle bounds = Groove.toRectangle(layout.getBounds());
            String value = String.valueOf(bounds.x) + " " + bounds.y + " " + bounds.width + " " + bounds.height;
            this.storeAttribute((TypedElementType)gxl, LAYOUT_ATTR_NAME, value);
        }
    }

    private void storeEdgeLayout(LayoutMap map, Edge edge, EdgeType gxl) {
        JEdgeLayout layout = map.edgeMap().get(edge);
        if (layout != null) {
            String value = String.valueOf(this.toString(layout.getLabelPosition())) + " " + this.toString(layout.getPoints()) + " " + layout.getLineStyle().getCode();
            this.storeAttribute((TypedElementType)gxl, LAYOUT_ATTR_NAME, value);
        }
    }

    private String toString(Point2D point) {
        return String.valueOf((int)point.getX()) + " " + (int)point.getY();
    }

    private String toString(List<Point2D> points) {
        boolean first = true;
        StringBuilder result = new StringBuilder();
        for (Point2D point : points) {
            if (!first) {
                result.append(" ");
            } else {
                first = false;
            }
            result.append(this.toString(point));
        }
        return result.toString();
    }

    private void saveAttributes(TypedElementType gxlElem, Map<String, String> attrs) {
        for (Map.Entry<String, String> e : attrs.entrySet()) {
            this.storeAttribute(gxlElem, e.getKey(), e.getValue());
        }
    }

    private void storeAttribute(TypedElementType gxlElem, String key, String value) {
        AttrType nodeMultAttr = this.factory.createAttrType();
        nodeMultAttr.setName(key);
        nodeMultAttr.setString(value);
        gxlElem.getAttr().add(nodeMultAttr);
    }

    private EdgeType createGxlEdge(Map<Node, NodeType> nodeMap, Node source, String labelText, Node target) {
        EdgeType result = this.factory.createEdgeType();
        result.setFrom((Object)nodeMap.get(source));
        result.setTo((Object)nodeMap.get(target));
        this.storeAttribute((TypedElementType)result, LABEL_ATTR_NAME, labelText);
        return result;
    }

    @Override
    public AttrGraph loadGraph(File file) throws IOException {
        File layoutFile;
        AttrGraph result;
        try {
            FileInputStream in = new FileInputStream(file);
            result = this.loadGraph(in);
        }
        catch (FormatException exc) {
            throw new IOException(String.format("Format error while loading '%s':\n%s", file, exc.getMessage()), exc);
        }
        catch (IOException exc) {
            throw new IOException(String.format("Error while loading '%s':\n%s", file, exc.getMessage()), exc);
        }
        result.setName(ExtensionFilter.getPureName(file));
        PriorityFileName priorityName = new PriorityFileName(file);
        if (priorityName.hasPriority()) {
            GraphInfo.setPriority(result, priorityName.getPriority());
        }
        if ((layoutFile = this.toLayoutFile(file)).exists()) {
            try {
                FileInputStream in = new FileInputStream(layoutFile);
                LayoutIO.getInstance().loadLayout(result, in);
            }
            catch (IOException iOException) {}
        }
        return result;
    }

    @Override
    public AttrGraph loadGraph(InputStream in) throws IOException, FormatException {
        try {
            GraphType gxlGraph = this.unmarshal(in);
            AttrGraph graph = this.gxlToGraph(gxlGraph);
            String version = GraphInfo.getVersion(graph);
            if (!Version.isKnownGxlVersion(version)) {
                GraphInfo.addErrors(graph, new FormatErrorSet("GXL file format version '%s' is higher than supported version '%s'", version, "curly"));
            }
            AttrGraph attrGraph = graph;
            return attrGraph;
        }
        finally {
            in.close();
        }
    }

    private AttrGraph gxlToGraph(GraphType gxlGraph) throws FormatException {
        AttrGraph graph = new AttrGraph(gxlGraph.getId());
        LayoutMap layoutMap = new LayoutMap();
        for (GraphElementType gxlElement : gxlGraph.getNodeOrEdgeOrRel()) {
            if (!(gxlElement instanceof NodeType)) continue;
            String nodeId = gxlElement.getId();
            if (graph.hasNode(nodeId)) {
                throw new FormatException("The node " + nodeId + " is declared more than once.", new Object[0]);
            }
            AttrNode node = graph.addNode(nodeId);
            Map<String, String> attrs = this.loadAttributes(gxlElement);
            String layoutText = attrs.remove(LAYOUT_ATTR_NAME);
            if (layoutText != null) {
                this.loadNodeLayout(layoutMap, node, layoutText);
            }
            for (Map.Entry e : attrs.entrySet()) {
                node.setAttribute((String)e.getKey(), (String)e.getValue());
            }
        }
        for (GraphElementType gxlElement : gxlGraph.getNodeOrEdgeOrRel()) {
            if (!(gxlElement instanceof RelType)) continue;
            ArrayList<String> nodeIds = new ArrayList<String>();
            for (RelendType relEnd : ((RelType)gxlElement).getRelend()) {
                nodeIds.add(relEnd.getId());
            }
            graph.addTuple(nodeIds);
        }
        for (GraphElementType gxlElement : gxlGraph.getNodeOrEdgeOrRel()) {
            if (!(gxlElement instanceof EdgeType)) continue;
            EdgeType gxlEdge = (EdgeType)gxlElement;
            NodeType gxlSource = (NodeType)gxlEdge.getFrom();
            if (gxlSource == null) {
                throw new FormatException("Unable to find source node of %s", gxlEdge);
            }
            String sourceId = gxlSource.getId();
            AttrNode sourceNode = graph.getNode(sourceId);
            if (sourceNode == null) {
                throw new FormatException("Unable to find edge source node %s", sourceId);
            }
            NodeType gxlTarget = (NodeType)gxlEdge.getTo();
            if (gxlTarget == null) {
                throw new FormatException("Unable to find target node of %s", gxlEdge);
            }
            String targetId = ((NodeType)gxlEdge.getTo()).getId();
            AttrNode targetNode = graph.getNode(targetId);
            if (targetNode == null) {
                throw new FormatException("Unable to find edge target node %s", targetId);
            }
            Map<String, String> attrs = this.loadAttributes(gxlElement);
            String labelText = attrs.remove(LABEL_ATTR_NAME);
            if (labelText == null) {
                throw new FormatException("Edge %s -> %s must have a %s attribute ", sourceId, targetId, LABEL_ATTR_NAME);
            }
            AttrEdge edge = (AttrEdge)graph.addEdge(sourceNode, labelText, targetNode);
            String layoutText = attrs.remove(LAYOUT_ATTR_NAME);
            if (layoutText != null) {
                this.loadEdgeLayout(layoutMap, edge, layoutText);
            }
            for (Map.Entry<String, String> e : attrs.entrySet()) {
                edge.setAttribute(e.getKey(), e.getValue());
            }
        }
        GraphProperties properties = new GraphProperties();
        for (AttrType graphAttr : gxlGraph.getAttr()) {
            String attrName = graphAttr.getName();
            Object dataValue = graphAttr.isBool() != null ? graphAttr.isBool() : (graphAttr.getInt() != null ? graphAttr.getInt() : (graphAttr.getFloat() != null ? graphAttr.getFloat() : graphAttr.getString()));
            properties.setProperty(attrName, dataValue.toString());
        }
        GraphInfo.setProperties(graph, properties);
        String roleName = gxlGraph.getRole();
        graph.setRole(roleName == null ? GraphRole.HOST : GraphRole.roles.get(roleName));
        GraphInfo.setLayoutMap(graph, layoutMap);
        return graph;
    }

    private Map<String, String> loadAttributes(GraphElementType gxlElement) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (AttrType attr : gxlElement.getAttr()) {
            String value = attr.getString();
            if (value == null) continue;
            String key = attr.getName();
            result.put(key, value);
        }
        return result;
    }

    private void loadNodeLayout(LayoutMap layoutMap, AttrNode node, String layoutText) throws FormatException {
        String[] parts = layoutText.split(" ");
        Rectangle bounds = LayoutIO.toBounds(parts, 0);
        if (bounds == null) {
            throw new FormatException("Bounds for " + parts[1] + " cannot be parsed", new Object[0]);
        }
        layoutMap.putNode((Node)node, new JVertexLayout(bounds));
    }

    private void loadEdgeLayout(LayoutMap layoutMap, AttrEdge edge, String layout) throws FormatException {
        String[] parts = layout.split(" ");
        if (parts.length > 2) {
            List<Point2D> points = LayoutIO.toPoints(parts, 2);
            if (points.size() <= 1) {
                throw new FormatException("Edge layout needs at least 2 points", new Object[0]);
            }
            int lineStyle = Integer.parseInt(parts[parts.length - 1]);
            if (!LineStyle.isStyle(lineStyle)) {
                lineStyle = LineStyle.DEFAULT_VALUE.getCode();
            }
            JVertexLayout sourceLayout = layoutMap.getLayout((Node)edge.source());
            JVertexLayout targetLayout = layoutMap.getLayout((Node)edge.target());
            if (sourceLayout != null && targetLayout != null) {
                LayoutIO.correctPoints(points, sourceLayout, targetLayout);
            }
            Point2D labelPosition = LayoutIO.calculateLabelPosition(LayoutIO.toPoint(parts, 0), points, 2, edge.isLoop());
            JEdgeLayout result = new JEdgeLayout(points, labelPosition, LineStyle.getStyle(lineStyle));
            layoutMap.putEdge((Edge)edge, result);
        }
    }

    private GraphType unmarshal(InputStream inputStream) throws IOException {
        try {
            JAXBElement doc = (JAXBElement)this.unmarshaller.unmarshal(inputStream);
            inputStream.close();
            return (GraphType)((GxlType)doc.getValue()).getGraph().get(0);
        }
        catch (JAXBException e) {
            throw new IOException(String.format("Error in %s: %s", inputStream, e.getMessage()));
        }
    }

    public static GxlIO getInstance() {
        return INSTANCE;
    }
}

