/*
 * Decompiled with CFR 0.152.
 */
package groove.lts;

import groove.control.CtrlSchedule;
import groove.control.CtrlState;
import groove.grammar.host.HostElement;
import groove.grammar.host.HostNode;
import groove.graph.Element;
import groove.lts.GTS;
import groove.lts.GraphState;
import groove.lts.GraphTransition;
import groove.lts.GraphTransitionStub;
import groove.lts.IdentityTransitionStub;
import groove.lts.MatchResult;
import groove.lts.RuleTransition;
import groove.lts.RuleTransitionStub;
import groove.lts.StateCache;
import groove.lts.StateReference;
import groove.transform.Record;
import groove.util.cache.AbstractCacheHolder;
import groove.util.cache.CacheReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public abstract class AbstractGraphState
extends AbstractCacheHolder<StateCache>
implements GraphState {
    private final int nr;
    private CtrlSchedule schedule;
    private GraphTransitionStub[] transitionStubs = EMPTY_TRANSITION_STUBS;
    private HostElement[] frozenGraph;
    private int status;
    private static int frozenGraphCount;
    private static final GraphTransitionStub[] EMPTY_TRANSITION_STUBS;
    private static final HostNode[] EMPTY_NODE_LIST;

    static {
        EMPTY_TRANSITION_STUBS = new RuleTransitionStub[0];
        EMPTY_NODE_LIST = new HostNode[0];
    }

    public AbstractGraphState(CacheReference<StateCache> reference, int number) {
        super(reference);
        assert (number >= 0);
        this.nr = number;
    }

    @Override
    public GTS getGTS() {
        return ((StateReference)this.getCacheReference()).getGTS();
    }

    @Override
    public final Set<? extends GraphTransition> getTransitions() {
        return this.getTransitions(GraphTransition.Class.COMPLETE);
    }

    @Override
    public final Set<RuleTransition> getRuleTransitions() {
        return this.getTransitions(GraphTransition.Class.RULE);
    }

    @Override
    public Set<? extends GraphTransition> getTransitions(GraphTransition.Class claz) {
        return ((StateCache)this.getCache()).getTransitions(claz);
    }

    @Override
    public boolean addTransition(GraphTransition transition) {
        return ((StateCache)this.getCache()).addTransition(transition);
    }

    @Override
    public RuleTransitionStub getOutStub(MatchResult match) {
        assert (match != null);
        RuleTransitionStub result = null;
        Iterator<? extends GraphTransitionStub> outTransIter = this.getTransitionStubIter();
        while (outTransIter.hasNext()) {
            GraphTransitionStub stub = outTransIter.next();
            if (!(stub instanceof RuleTransitionStub) || ((RuleTransitionStub)stub).getKey(this) != match) continue;
            result = (RuleTransitionStub)stub;
            break;
        }
        return result;
    }

    protected RuleTransitionStub createTransitionStub(MatchResult match, HostNode[] addedNodes, GraphState target) {
        if (target instanceof AbstractGraphState) {
            return ((AbstractGraphState)target).createInTransitionStub(this, match, addedNodes);
        }
        return new IdentityTransitionStub(match, addedNodes, target);
    }

    protected RuleTransitionStub createInTransitionStub(GraphState source, MatchResult match, HostNode[] addedNodes) {
        return new IdentityTransitionStub(match, addedNodes, this);
    }

    protected final Iterator<? extends GraphTransitionStub> getTransitionStubIter() {
        if (this.isClosed()) {
            return this.getStoredTransitionStubs().iterator();
        }
        return this.getCachedTransitionStubs().iterator();
    }

    private Set<GraphTransitionStub> getCachedTransitionStubs() {
        return ((StateCache)this.getCache()).getStubSet();
    }

    final Collection<GraphTransitionStub> getStoredTransitionStubs() {
        return Arrays.asList(this.transitionStubs);
    }

    private void setStoredTransitionStubs(Collection<GraphTransitionStub> outTransitionSet) {
        if (outTransitionSet.isEmpty()) {
            this.transitionStubs = EMPTY_TRANSITION_STUBS;
        } else {
            this.transitionStubs = new GraphTransitionStub[outTransitionSet.size()];
            outTransitionSet.toArray(this.transitionStubs);
        }
    }

    @Override
    public List<MatchResult> getMatches() {
        return new ArrayList<MatchResult>(((StateCache)this.getCache()).getMatches());
    }

    @Override
    public MatchResult getMatch() {
        return ((StateCache)this.getCache()).getMatch();
    }

    @Override
    public RuleTransition applyMatch(MatchResult match) {
        RuleTransition trans;
        RuleTransition result = null;
        if (match instanceof RuleTransition && (trans = (RuleTransition)((Object)match)).source() == this) {
            result = trans;
        }
        if (result == null) {
            result = this.getGTS().getMatchApplier().apply(this, match);
        }
        return result;
    }

    @Override
    public boolean isClosed() {
        return this.hasFlag(GraphState.Flag.CLOSED);
    }

    @Override
    public boolean setClosed(boolean complete) {
        boolean result = this.setStatus(GraphState.Flag.CLOSED, true);
        if (result) {
            this.setStoredTransitionStubs(this.getCachedTransitionStubs());
            this.updateClosed();
            if (!complete) {
                this.setSchedule(this.getCtrlState().getSchedule());
            }
            ((StateCache)this.getCache()).notifyClosed();
            this.fireStatus(GraphState.Flag.CLOSED);
        }
        return result;
    }

    protected abstract void updateClosed();

    @Override
    public boolean setError() {
        boolean result = this.setStatus(GraphState.Flag.ERROR, true);
        if (result) {
            this.fireStatus(GraphState.Flag.ERROR);
        }
        return result;
    }

    @Override
    public boolean isError() {
        return this.hasFlag(GraphState.Flag.ERROR);
    }

    @Override
    public final boolean isTransient() {
        return this.getSchedule().isTransient();
    }

    @Override
    public boolean setAbsent() {
        boolean result = this.setStatus(GraphState.Flag.ABSENT, true);
        if (result) {
            this.fireStatus(GraphState.Flag.ABSENT);
        }
        return result;
    }

    @Override
    public boolean isAbsent() {
        return this.hasFlag(GraphState.Flag.ABSENT);
    }

    @Override
    public boolean isPresent() {
        if (this.isAbsent()) {
            return false;
        }
        if (this.isDone()) {
            return true;
        }
        return ((StateCache)this.getCache()).isPresent();
    }

    @Override
    public boolean setDone(boolean present) {
        boolean result = this.setStatus(GraphState.Flag.DONE, true);
        if (result) {
            if (!present) {
                this.setStatus(GraphState.Flag.ABSENT, true);
            }
            ((StateCache)this.getCache()).notifyDone();
            this.setCacheCollectable();
            this.fireStatus(GraphState.Flag.DONE);
        }
        return result;
    }

    @Override
    public boolean isDone() {
        return this.hasFlag(GraphState.Flag.DONE);
    }

    @Override
    public boolean hasFlag(GraphState.Flag flag) {
        return flag.test(this.status);
    }

    @Override
    public boolean setFlag(GraphState.Flag flag, boolean value) {
        assert (flag.isStrategy());
        return this.setStatus(flag, value);
    }

    private boolean setStatus(GraphState.Flag flag, boolean value) {
        boolean result = value ^ this.hasFlag(flag);
        if (result) {
            this.status = value ? flag.set(this.status) : flag.reset(this.status);
        }
        return result;
    }

    private void fireStatus(GraphState.Flag flag) {
        this.getGTS().fireUpdateState(this, flag);
    }

    protected HostElement[] getFrozenGraph() {
        return this.frozenGraph;
    }

    protected void setFrozenGraph(HostElement[] frozenGraph) {
        this.frozenGraph = frozenGraph;
        ++frozenGraphCount;
    }

    public int compareTo(Element obj) {
        if (obj instanceof GraphState) {
            return this.getNumber() - ((GraphState)obj).getNumber();
        }
        if (obj instanceof GraphTransition) {
            return this.getNumber() - ((GraphTransition)obj).source().getNumber();
        }
        throw new UnsupportedOperationException(String.format("Classes %s and %s cannot be compared", this.getClass(), obj.getClass()));
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("s");
        if (this.hasNumber()) {
            result.append(this.getNumber());
        } else {
            result.append("??");
        }
        if (this.getBoundNodes().length > 0) {
            result.append(Arrays.toString(this.getBoundNodes()));
        }
        return result.toString();
    }

    @Override
    protected StateCache createCache() {
        return new StateCache(this);
    }

    @Override
    public void clearCache() {
        if (!this.isClosed()) {
            this.setStoredTransitionStubs(this.getCachedTransitionStubs());
        }
        super.clearCache();
    }

    protected boolean hasNumber() {
        return this.nr >= 0;
    }

    @Override
    public int getNumber() {
        return this.nr;
    }

    protected Record getRecord() {
        return this.getGTS().getRecord();
    }

    @Override
    public HostNode[] getBoundNodes() {
        return EMPTY_NODE_LIST;
    }

    public final void setCtrlState(CtrlState ctrlState) {
        this.schedule = ctrlState.getSchedule();
    }

    @Override
    public CtrlState getCtrlState() {
        return this.schedule.getState();
    }

    @Override
    public void setSchedule(CtrlSchedule schedule) {
        assert (schedule != null);
        assert (schedule.getState() == this.getCtrlState());
        this.schedule = schedule;
    }

    @Override
    public final CtrlSchedule getSchedule() {
        return this.schedule;
    }

    public static int getFrozenGraphCount() {
        return frozenGraphCount;
    }
}

