/*
 * Decompiled with CFR 0.152.
 */
package groove.lts;

import groove.control.CtrlState;
import groove.control.CtrlTransition;
import groove.grammar.Recipe;
import groove.grammar.Rule;
import groove.grammar.host.DeltaHostGraph;
import groove.grammar.host.HostGraphMorphism;
import groove.grammar.host.HostNode;
import groove.grammar.model.FormatException;
import groove.graph.EdgeRole;
import groove.lts.AbstractGraphState;
import groove.lts.DefaultRuleTransition;
import groove.lts.GraphNextState;
import groove.lts.GraphState;
import groove.lts.GraphTransitionKey;
import groove.lts.MatchResult;
import groove.lts.RuleTransition;
import groove.lts.RuleTransitionLabel;
import groove.lts.RuleTransitionStub;
import groove.lts.StateCache;
import groove.transform.AbstractRuleEvent;
import groove.transform.DeltaApplier;
import groove.transform.Proof;
import groove.transform.RuleApplication;
import groove.transform.RuleEvent;
import java.util.Collections;

public class DefaultGraphNextState
extends AbstractGraphState
implements GraphNextState,
RuleTransitionStub {
    private HostNode[] boundNodes;
    private final AbstractGraphState source;
    private final RuleEvent event;
    private final CtrlTransition ctrlTrans;
    private final HostNode[] addedNodes;
    private static final boolean DEBUG = false;

    public DefaultGraphNextState(int number, AbstractGraphState source, MatchResult match, HostNode[] addedNodes, HostNode[] boundNodes) {
        super(source.getCacheReference(), number);
        this.source = source;
        this.event = match.getEvent();
        this.addedNodes = addedNodes;
        CtrlTransition ctrlTrans = this.ctrlTrans = match.getCtrlTransition();
        this.setCtrlState((CtrlState)ctrlTrans.target());
        this.boundNodes = boundNodes;
    }

    @Override
    public String text(boolean anchored) {
        return this.label().text(anchored);
    }

    @Override
    public RuleEvent getEvent() {
        return this.event;
    }

    @Override
    public Rule getAction() {
        return this.getEvent().getRule();
    }

    @Override
    public RuleTransition getInitial() {
        return this;
    }

    @Override
    public Iterable<RuleTransition> getSteps() {
        return Collections.singletonList(this);
    }

    @Override
    public String getOutputString() throws FormatException {
        return ((AbstractRuleEvent)this.getEvent()).getOutputString(this.getAddedNodes());
    }

    @Override
    public HostNode[] getAddedNodes() {
        return this.addedNodes;
    }

    @Override
    public HostNode[] getBoundNodes() {
        return this.boundNodes;
    }

    @Override
    public Proof getProof() {
        return this.getEvent().getMatch(this.source().getGraph());
    }

    @Override
    public HostGraphMorphism getMorphism() {
        return this.createRuleApplication().getMorphism();
    }

    @Override
    public RuleApplication createRuleApplication() {
        return new RuleApplication(this.getEvent(), this.source().getGraph(), this.getGraph(), this.getAddedNodes());
    }

    @Override
    public RuleTransitionLabel label() {
        return RuleTransitionLabel.createLabel(this.source(), this.getKey(), this.addedNodes);
    }

    @Override
    public EdgeRole getRole() {
        if (this.getEvent().getRule().isModifying() || this.getCtrlTransition().isModifying()) {
            return EdgeRole.BINARY;
        }
        return EdgeRole.FLAG;
    }

    @Override
    public AbstractGraphState source() {
        return this.source;
    }

    @Override
    public DefaultGraphNextState target() {
        return this;
    }

    @Override
    public boolean isLoop() {
        return this.source() == this.target();
    }

    @Override
    public GraphTransitionKey getKey(GraphState source) {
        if (source == this.source()) {
            return this.getKey();
        }
        return this.getSourceKey();
    }

    @Override
    public HostNode[] getAddedNodes(GraphState source) {
        if (source == this.source()) {
            return this.getAddedNodes();
        }
        return this.getSourceAddedNodes();
    }

    @Override
    public boolean isSymmetry() {
        return false;
    }

    @Override
    public MatchResult getKey() {
        return new MatchResult(this);
    }

    @Override
    public RuleTransitionStub toStub() {
        return this;
    }

    @Override
    public RuleTransition toTransition(GraphState source) {
        if (source != this.source()) {
            return new DefaultRuleTransition(source, this.getSourceKey(), this.getSourceAddedNodes(), this, this.isSymmetry());
        }
        return this;
    }

    @Override
    public GraphState getTarget(GraphState source) {
        return this;
    }

    @Override
    public DeltaHostGraph getGraph() {
        return ((StateCache)this.getCache()).getGraph();
    }

    public DeltaApplier getDelta() {
        return ((StateCache)this.getCache()).getDelta();
    }

    @Override
    protected void updateClosed() {
    }

    protected MatchResult getSourceKey() {
        if (this.source() instanceof GraphNextState) {
            return ((GraphNextState)((Object)this.source())).getKey();
        }
        return null;
    }

    protected HostNode[] getSourceAddedNodes() {
        if (this.source() instanceof GraphNextState) {
            return ((GraphNextState)((Object)this.source())).getAddedNodes();
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        return obj instanceof RuleTransition && this.equalsTransition((RuleTransition)obj);
    }

    protected boolean equalsTransition(RuleTransition other) {
        return this.source() == other.source() && this.getEvent().equals(other.getEvent()) && this.getCtrlTransition().equals(other.getCtrlTransition());
    }

    public int hashCode() {
        return this.source().getNumber() + this.getEvent().hashCode() + this.getCtrlTransition().hashCode();
    }

    @Override
    protected RuleTransitionStub createInTransitionStub(GraphState source, MatchResult match, HostNode[] addedNodes) {
        if (source == this.source() && match == this.getEvent()) {
            return this;
        }
        if (source != this.source() && match == this.getSourceKey()) {
            return this;
        }
        return super.createInTransitionStub(source, match, addedNodes);
    }

    @Override
    public CtrlTransition getCtrlTransition() {
        return this.ctrlTrans;
    }

    @Override
    public boolean isPartial() {
        return this.getRecipe() != null;
    }

    @Override
    public Recipe getRecipe() {
        return this.getCtrlTransition().getRecipe();
    }
}

