/*
 * Decompiled with CFR 0.152.
 */
package groove.lts;

import groove.control.CtrlTransition;
import groove.grammar.Recipe;
import groove.grammar.Rule;
import groove.grammar.host.HostEdge;
import groove.grammar.host.HostGraph;
import groove.grammar.host.HostGraphMorphism;
import groove.grammar.host.HostNode;
import groove.grammar.model.FormatException;
import groove.graph.AEdge;
import groove.graph.AGraph;
import groove.graph.EdgeRole;
import groove.graph.Morphism;
import groove.graph.iso.IsoChecker;
import groove.lts.DefaultGraphNextState;
import groove.lts.GraphState;
import groove.lts.GraphTransitionKey;
import groove.lts.IdentityTransitionStub;
import groove.lts.MatchResult;
import groove.lts.RuleTransition;
import groove.lts.RuleTransitionLabel;
import groove.lts.RuleTransitionStub;
import groove.lts.SymmetryTransitionStub;
import groove.transform.AbstractRuleEvent;
import groove.transform.Proof;
import groove.transform.RuleApplication;
import groove.transform.RuleEvent;
import java.util.Collections;

public class DefaultRuleTransition
extends AEdge<GraphState, RuleTransitionLabel>
implements RuleTransitionStub,
RuleTransition {
    private HostGraphMorphism morphism;
    private final boolean symmetry;
    private static int anchorImageCount = 0;

    public DefaultRuleTransition(GraphState source, MatchResult match, HostNode[] addedNodes, GraphState target, boolean symmetry) {
        super(source, RuleTransitionLabel.createLabel(source, match, addedNodes), target);
        this.symmetry = symmetry;
    }

    public DefaultRuleTransition(GraphState source, MatchResult match, GraphState target) {
        this(source, match, null, target, false);
    }

    @Override
    public String text(boolean anchored) {
        return ((RuleTransitionLabel)this.label()).text(anchored);
    }

    @Override
    public Rule getAction() {
        return this.getEvent().getRule();
    }

    @Override
    public RuleEvent getEvent() {
        return ((RuleTransitionLabel)this.label()).getEvent();
    }

    @Override
    public RuleTransition getInitial() {
        return this;
    }

    @Override
    public Iterable<RuleTransition> getSteps() {
        return Collections.singletonList(this);
    }

    @Override
    public String getOutputString() throws FormatException {
        return ((AbstractRuleEvent)this.getEvent()).getOutputString(this.getAddedNodes());
    }

    @Override
    public boolean isSymmetry() {
        return this.symmetry;
    }

    @Override
    public EdgeRole getRole() {
        if (this.getEvent().getRule().isModifying() || this.getCtrlTransition().isModifying()) {
            return EdgeRole.BINARY;
        }
        return EdgeRole.FLAG;
    }

    @Override
    public HostNode[] getAddedNodes() {
        return ((RuleTransitionLabel)this.label()).getAddedNodes();
    }

    @Override
    public MatchResult getKey() {
        return new MatchResult(this);
    }

    @Override
    public RuleTransitionStub toStub() {
        if (this.isSymmetry()) {
            return new SymmetryTransitionStub(this.getKey(), this.getAddedNodes(), (GraphState)this.target());
        }
        if (this.target() instanceof DefaultGraphNextState) {
            return ((DefaultGraphNextState)this.target()).createInTransitionStub((GraphState)this.source(), this.getKey(), this.getAddedNodes());
        }
        return new IdentityTransitionStub(this.getKey(), this.getAddedNodes(), (GraphState)this.target());
    }

    @Override
    public Proof getProof() {
        return this.getEvent().getMatch(((GraphState)this.source()).getGraph());
    }

    @Override
    public GraphTransitionKey getKey(GraphState source) {
        if (source != this.source()) {
            throw new IllegalArgumentException("Source state incompatible");
        }
        return this.getKey();
    }

    @Override
    public HostNode[] getAddedNodes(GraphState source) {
        if (source != this.source()) {
            throw new IllegalArgumentException("Source state incompatible");
        }
        return this.getAddedNodes();
    }

    @Override
    public RuleTransition toTransition(GraphState source) {
        if (source != this.source()) {
            throw new IllegalArgumentException("Source state incompatible");
        }
        return this;
    }

    @Override
    public GraphState getTarget(GraphState source) {
        if (source != this.source()) {
            throw new IllegalArgumentException("Source state incompatible");
        }
        return (GraphState)this.target();
    }

    @Override
    public HostGraphMorphism getMorphism() {
        if (this.morphism == null) {
            this.morphism = this.computeMorphism();
        }
        return this.morphism;
    }

    @Override
    public RuleApplication createRuleApplication() {
        return new RuleApplication(this.getEvent(), ((GraphState)this.source()).getGraph(), ((GraphState)this.target()).getGraph(), this.getAddedNodes());
    }

    protected HostGraphMorphism computeMorphism() {
        Morphism result;
        HostGraph sourceGraph = ((GraphState)this.source()).getGraph();
        if (this.getAction().isModifying()) {
            RuleApplication appl = this.getEvent().newApplication(sourceGraph);
            result = appl.getMorphism();
            if (this.isSymmetry()) {
                HostGraph derivedTarget = appl.getTarget().clone();
                HostGraph realTarget = ((GraphState)this.target()).getGraph().clone();
                Morphism iso = IsoChecker.getInstance(true).getIsomorphism(derivedTarget, realTarget);
                assert (iso != null) : "Can't reconstruct derivation from graph transition " + this + ": \n" + AGraph.toString(derivedTarget) + " and \n" + AGraph.toString(realTarget) + " \nnot isomorphic";
                result = result.then(iso);
            }
        } else {
            result = sourceGraph.getFactory().createMorphism();
            for (HostNode node : sourceGraph.nodeSet()) {
                result.putNode(node, node);
            }
            for (HostEdge edge : sourceGraph.edgeSet()) {
                result.putEdge(edge, edge);
            }
        }
        return result;
    }

    protected boolean equalsSource(RuleTransition other) {
        return this.source() == other.source();
    }

    protected boolean equalsEvent(RuleTransition other) {
        return this.getEvent().equals(other.getEvent());
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof RuleTransition && this.equalsSource((RuleTransition)obj) && this.equalsEvent((RuleTransition)obj);
    }

    @Override
    protected int computeHashCode() {
        return System.identityHashCode(this.source()) + System.identityHashCode(this.getEvent());
    }

    @Override
    public CtrlTransition getCtrlTransition() {
        return ((RuleTransitionLabel)this.label).getCtrlTransition();
    }

    @Override
    public boolean isPartial() {
        return this.getRecipe() != null;
    }

    @Override
    public Recipe getRecipe() {
        return this.getCtrlTransition().getRecipe();
    }

    public static int getAnchorImageCount() {
        return anchorImageCount;
    }
}

