/*
 * Decompiled with CFR 0.152.
 */
package groove.lts;

import groove.lts.GTS;
import groove.lts.GTSListener;
import groove.lts.GraphState;
import groove.lts.GraphTransition;
import groove.lts.RuleTransition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GTSCounter
implements GTSListener {
    private GTS gts;
    private final int[] count = new int[GraphState.Flag.values().length];
    private int transientStateCount;
    private int partialTransitionCount;
    private int ruleTransitionCount;
    private int absentTransitionCount;
    private final Map<GraphState, List<RuleTransition>> inTransMap = new HashMap<GraphState, List<RuleTransition>>();

    public void setGTS(GTS gts) {
        if (this.gts != null) {
            this.gts.removeLTSListener(this);
        }
        this.gts = gts;
        this.initialise();
        if (gts != null) {
            gts.addLTSListener(this);
        }
    }

    public void initialise() {
        GraphState.Flag[] flagArray = GraphState.Flag.values();
        int n = flagArray.length;
        int n2 = 0;
        while (n2 < n) {
            GraphState.Flag flag = flagArray[n2];
            this.count[flag.ordinal()] = 0;
            ++n2;
        }
        this.transientStateCount = 0;
        this.partialTransitionCount = 0;
        this.ruleTransitionCount = 0;
        this.absentTransitionCount = 0;
        this.inTransMap.clear();
        if (this.gts != null) {
            for (GraphState graphState : this.gts.nodeSet()) {
                this.register(graphState);
            }
            for (GraphTransition graphTransition : this.gts.edgeSet()) {
                this.register(graphTransition);
            }
        }
    }

    @Override
    public void addUpdate(GTS gts, GraphState state) {
        this.register(state);
    }

    private void register(GraphState state) {
        GraphState.Flag[] flagArray = GraphState.Flag.values();
        int n = flagArray.length;
        int n2 = 0;
        while (n2 < n) {
            GraphState.Flag flag = flagArray[n2];
            if (state.hasFlag(flag)) {
                int n3 = flag.ordinal();
                this.count[n3] = this.count[n3] + 1;
            }
            ++n2;
        }
        if (!state.isDone()) {
            this.inTransMap.put(state, new ArrayList());
        } else if (state.isTransient()) {
            ++this.transientStateCount;
        }
    }

    @Override
    public void addUpdate(GTS gts, GraphTransition transition) {
        this.register(transition);
    }

    private void register(GraphTransition trans) {
        GraphState target;
        if (trans.isPartial()) {
            ++this.partialTransitionCount;
        }
        if (trans instanceof RuleTransition) {
            ++this.ruleTransitionCount;
        }
        if ((target = trans.target()).isAbsent()) {
            ++this.absentTransitionCount;
        } else if (trans instanceof RuleTransition && !target.isDone()) {
            this.inTransMap.get(target).add((RuleTransition)trans);
        }
    }

    @Override
    public void statusUpdate(GTS gts, GraphState state, GraphState.Flag flag) {
        int n = flag.ordinal();
        this.count[n] = this.count[n] + 1;
        if (flag == GraphState.Flag.CLOSED && state.isTransient()) {
            ++this.transientStateCount;
        } else if (flag == GraphState.Flag.DONE) {
            List<RuleTransition> inTrans = this.inTransMap.remove(state);
            if (state.isAbsent()) {
                this.absentTransitionCount += inTrans.size();
                int n2 = GraphState.Flag.ABSENT.ordinal();
                this.count[n2] = this.count[n2] + 1;
            }
        }
    }

    public int getStateCount() {
        return this.gts.nodeCount();
    }

    public int getTransientStateCount() {
        return this.transientStateCount;
    }

    public int getFinalStateCount() {
        return this.gts.getFinalStates().size();
    }

    public int getOpenStateCount() {
        return this.gts.openStateCount();
    }

    public int getTransitionCount() {
        return this.gts.edgeCount();
    }

    public int getPartialTransitionCount() {
        return this.partialTransitionCount;
    }

    public int getRuleTransitionCount() {
        return this.ruleTransitionCount;
    }

    public int getAbsentTransitionCount() {
        return this.absentTransitionCount;
    }

    public int getStateCount(GraphState.Flag flag) {
        return this.count[flag.ordinal()];
    }
}

