/*
 * Decompiled with CFR 0.152.
 */
package groove.lts;

import groove.control.CtrlLabel;
import groove.control.CtrlTransition;
import groove.grammar.Rule;
import groove.graph.EdgeComparator;
import groove.lts.GraphState;
import groove.lts.GraphTransitionKey;
import groove.lts.RuleTransition;
import groove.transform.RuleEvent;
import java.util.Comparator;

public class MatchResult
implements GraphTransitionKey {
    private int hashcode;
    private final RuleTransition ruleTrans;
    private final RuleEvent event;
    private final CtrlTransition ctrlTrans;
    public static final Comparator<MatchResult> COMPARATOR = new Comparator<MatchResult>(){

        @Override
        public int compare(MatchResult o1, MatchResult o2) {
            int result = o1.getEvent().compareTo(o2.getEvent());
            if (result == 0) {
                result = edgeComparator.compare(o1.getCtrlTransition(), o2.getCtrlTransition());
            }
            return result;
        }
    };
    private static final EdgeComparator edgeComparator = EdgeComparator.instance();

    public MatchResult(RuleTransition ruleTrans) {
        this.ruleTrans = ruleTrans;
        this.event = ruleTrans.getEvent();
        this.ctrlTrans = ruleTrans.getCtrlTransition();
    }

    public MatchResult(RuleEvent event, CtrlTransition ctrlTrans) {
        this.ruleTrans = null;
        this.event = event;
        this.ctrlTrans = ctrlTrans;
    }

    public boolean hasRuleTransitionFrom(GraphState state) {
        return this.hasRuleTransition() && this.getRuleTransition().source() == state;
    }

    public boolean hasRuleTransition() {
        return this.ruleTrans != null;
    }

    public RuleTransition getRuleTransition() {
        return this.ruleTrans;
    }

    public RuleEvent getEvent() {
        return this.event;
    }

    public CtrlTransition getCtrlTransition() {
        return this.ctrlTrans;
    }

    public Rule getRule() {
        return this.event.getRule();
    }

    public int hashCode() {
        int hashcode = this.hashcode;
        if (hashcode == 0) {
            hashcode = this.computeHashCode();
            if (hashcode == 0) {
                ++hashcode;
            }
            this.hashcode = hashcode;
        }
        return hashcode;
    }

    private int computeHashCode() {
        int result = 1;
        result = 31 * result + this.getCtrlTransition().hashCode();
        result = 31 * result + this.getEvent().hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MatchResult)) {
            return false;
        }
        MatchResult other = (MatchResult)obj;
        if (!this.getCtrlTransition().equals(other.getCtrlTransition())) {
            return false;
        }
        return this.getEvent().equals(other.getEvent());
    }

    public String toString() {
        return ((CtrlLabel)this.ctrlTrans.label()).text();
    }
}

