/*
 * Decompiled with CFR 0.152.
 */
package groove.lts;

import groove.grammar.Recipe;
import groove.lts.GraphState;
import groove.lts.GraphTransitionKey;
import groove.lts.GraphTransitionStub;
import groove.lts.RecipeTransition;
import groove.lts.RuleTransition;
import groove.lts.RuleTransitionStub;
import groove.transform.Event;

public class RecipeEvent
implements GraphTransitionStub,
Event,
GraphTransitionKey {
    private final Recipe recipe;
    private final RuleTransitionStub initial;
    private final GraphState target;

    public RecipeEvent(RecipeTransition trans) {
        this.recipe = trans.getAction();
        this.initial = trans.getInitial().toStub();
        this.target = (GraphState)trans.target();
    }

    public RecipeEvent(Recipe recipe, RuleTransition initial, GraphState target) {
        this.recipe = recipe;
        this.initial = initial.toStub();
        this.target = target;
    }

    @Override
    public Recipe getAction() {
        return this.recipe;
    }

    @Override
    public GraphState getTarget(GraphState source) {
        assert (this.initial.getTarget(source) != null);
        return this.target;
    }

    @Override
    public GraphTransitionKey getKey(GraphState source) {
        return this;
    }

    @Override
    public RecipeTransition toTransition(GraphState source) {
        return new RecipeTransition(source, this.initial.toTransition(source), this.target);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.recipe.hashCode();
        result = 31 * result + this.initial.hashCode();
        result = 31 * result + this.target.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecipeEvent)) {
            return false;
        }
        RecipeEvent other = (RecipeEvent)obj;
        if (!this.recipe.equals(other.recipe)) {
            return false;
        }
        if (!this.initial.equals(other.initial)) {
            return false;
        }
        return this.target.equals(other.target);
    }
}

